package com.yidianling.dynamic.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.WindowManager
import com.yidianling.dynamic.R
import com.yidianling.dynamic.dialog.listener.TrendsQuestionListener
import kotlinx.android.synthetic.main.dynamic_question_and_trends_dialog_layout.*

/**
 * Created by xj on 2019/9/25.
 */
class TrendsAndQuestionDialog(val mContext: Context, val listener: TrendsQuestionListener): Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.dynamic_question_and_trends_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        params.gravity=Gravity.BOTTOM

        window.attributes = params
        setCanceledOnTouchOutside(true)
        ll_publish_trends.setOnClickListener {
            listener.publishTrends()
            hide()
        }

        ll_publish_question.setOnClickListener {
            listener.publishQuestion()
            hide()
        }
        publish_close.setOnClickListener {
            hide()
        }

    }

}