package com.yidianling.dynamic.members;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.alibaba.android.arouter.launcher.ARouter;
import com.google.gson.internal.LinkedTreeMap;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.base.config.YDLConstants;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.ui.ParcelableImage;
import com.ydl.ydlcommon.utils.StatusBarUtils;
import com.ydl.ydlcommon.view.dialog.ListDialog;
import com.ydl.ydlcommon.view.widgets.BorderCircleImageView;
import com.ydl.ydlcommon.view.widgets.MyNestedScrollView;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.bean.DynamicConstants;
import com.yidianling.dynamic.common.browsePictures.BrowsePicturesActivity;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.dialog.CancelFocusDialog;
import com.yidianling.dynamic.event.BlackEvent;
import com.yidianling.dynamic.event.LoginStateEvent;
import com.yidianling.dynamic.event.dynamicFocusEvent;
import com.yidianling.dynamic.model.Command;
import com.yidianling.dynamic.model.MemberInfoBean;
import com.yidianling.dynamic.router.DynamicIn;
import com.yidianling.dynamic.trendList.TrendListInFragment;
import com.yidianling.user.api.event.UserLoginEvent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import de.greenrobot.event.EventBus;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;



/**
 * 会员主页
 */
public class MembersActivity extends BaseActivity implements View.OnClickListener, MyNestedScrollView.ScrollViewListener, SwipeRefreshLayout.OnRefreshListener {

    private MyNestedScrollView members_myScrov;
    String mem_id;
    private ImageView members_title_back_iv, members_title_top_right_tv, members_top_bg_iv, members_top_user_gender_iv, members_top_user_focus_iv;
    private BorderCircleImageView members_top_head_iv;
    private TextView members_title_top_tv, members_top_user_tv, members_top_user_visit_num_tv, members_top_user_fensi_num_tv, members_top_user_zan_num_tv, members_top_user_focus_ortion_tv,
            members_trend_tv, members_trend_hint_tv, members_information_tv, members_information_hint_tv;
    private RelativeLayout members_title_rel, members_top_head_rel, members_trend_rel, members_information_rel, members_top_user_focus_ortion_rel;

    LinearLayout members_type_lin;
    private TrendListInFragment trendlisfragment;
    private MemberFragment memberfragment;

    List<String> reportReasonsId;//举报内容id
    List<String> reportReasons;//举报内容列表

    private FragmentManager fragmentManager;
    String age, emotional_state, job, address, introduction, ipProvince;
    String focus_state;//关注状态
    boolean zan_state;

    String zan_count, fans_count;//赞数和粉丝数
//    private View members_top_view;

    //顶部渐变
    private int height;
    String name;
    protected int DIS = 0;
    protected int title_rel_bottom;

    boolean shielding = false;//屏蔽状态
    private SwipeRefreshLayout member_swrl;
    private Handler mHandler1;
    int select_tab;//当前动态列表的标示
    String tab;
    boolean is_first_refreh;
    String head;//头像

    private CancelFocusDialog cancelFocusDialog = null;

    private static final String USER_ID = "user_id";



    public static Intent newIntent(Activity activity, String userId) {
        Intent intent = new Intent(activity, MembersActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString(USER_ID, userId);
        intent.putExtra(YDLConstants.BUNDLE, bundle);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dynamic_activity_members);
        EventBus.getDefault().register(this);
//        mem_id = getIntent().getStringExtra("user_id");
        Bundle bundle = getIntent().getBundleExtra(YDLConstants.BUNDLE);
        mem_id = bundle.getString(USER_ID);
        if (!"".equals(mem_id) && mem_id != null) {
            if (mem_id.equals(DynamicIn.INSTANCE.getUserInfo().getUid() + "")) {
                focus_state = "4";
            }
        }
        fragmentManager = getSupportFragmentManager();
        initView();
//        initWindows();
        initEvent();
        initListeners();
//        initDatas();
        setTabSelection(0);
        StatusBarUtils.Companion.setCustomStatusViewForMembers(this,members_title_rel,true);
    }

    private void initEvent() {
        members_title_back_iv.setOnClickListener(this);
        members_title_top_right_tv.setOnClickListener(this);
        members_trend_rel.setOnClickListener(this);
        members_information_rel.setOnClickListener(this);
        members_top_user_focus_ortion_rel.setOnClickListener(this);
        members_top_user_focus_iv.setOnClickListener(this);
        members_top_head_iv.setOnClickListener(this);
    }

    private void initView() {
        member_swrl = (SwipeRefreshLayout) findViewById(R.id.member_swrl);
        members_title_top_tv = (TextView) findViewById(R.id.members_title_top_tv);
        members_myScrov = (MyNestedScrollView) findViewById(R.id.members_myScrov);
//        members_top_view = (View) findViewById(R.id.members_top_view);
        members_top_head_rel = (RelativeLayout) findViewById(R.id.members_top_head_rel);
        members_title_rel = (RelativeLayout) findViewById(R.id.members_title_rel);
        members_title_back_iv = (ImageView) findViewById(R.id.members_title_back_iv);
        members_title_top_right_tv = (ImageView) findViewById(R.id.members_title_top_right_tv);
        members_top_bg_iv = (ImageView) findViewById(R.id.members_top_bg_iv);
        members_top_user_gender_iv = (ImageView) findViewById(R.id.members_top_user_gender_iv);
//        members_top_user_focus_ortion_hint_iv=(ImageView)findViewById(members_top_user_focus_ortion_hint_iv);
        members_top_user_focus_iv = (ImageView) findViewById(R.id.members_top_user_focus_iv);
        members_top_head_iv = (BorderCircleImageView) findViewById(R.id.members_top_head_iv);
        members_top_user_tv = (TextView) findViewById(R.id.members_top_user_tv);
        members_top_user_visit_num_tv = (TextView) findViewById(R.id.members_top_user_visit_num_tv);
        members_top_user_fensi_num_tv = (TextView) findViewById(R.id.members_top_user_fensi_num_tv);
        members_top_user_zan_num_tv = (TextView) findViewById(R.id.members_top_user_zan_num_tv);
        members_top_user_focus_ortion_tv = (TextView) findViewById(R.id.members_top_user_focus_ortion_tv);
        members_trend_tv = (TextView) findViewById(R.id.members_trend_tv);
        members_trend_hint_tv = (TextView) findViewById(R.id.members_trend_hint_tv);
        members_information_tv = (TextView) findViewById(R.id.members_information_tv);
        members_information_hint_tv = (TextView) findViewById(R.id.members_information_hint_tv);
        members_trend_rel = (RelativeLayout) findViewById(R.id.members_trend_rel);
        members_information_rel = (RelativeLayout) findViewById(R.id.members_information_rel);
        members_type_lin = (LinearLayout) findViewById(R.id.members_type_lin);
        members_top_user_focus_ortion_rel = (RelativeLayout) findViewById(R.id.members_top_user_focus_ortion_rel);

        initLoadMore();
    }

    /**
     * 加载更多初始化
     */
    private void initLoadMore() {
        member_swrl.setOnRefreshListener(this);
        member_swrl.setColorSchemeResources(R.color.platform_main_theme);
        member_swrl.post(new Runnable() {
            @Override
            public void run() {
                member_swrl.setProgressViewOffset(false, 0, 100);
                member_swrl.setRefreshing(true);
                onRefresh();
            }
        });
    }

    /**
     * 获取顶部图片高度后，设置滚动监听
     */
    private void initListeners() {

        ViewTreeObserver vto = members_top_head_rel.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                members_title_rel.getViewTreeObserver().removeGlobalOnLayoutListener(
                        this);
                height = members_top_head_rel.getHeight();

                members_myScrov.setScrollViewListener(MembersActivity.this);
            }
        });
    }


    private void initDatas() {
        Command.MemberInfoCmd cmd = new Command.MemberInfoCmd(mem_id);
        DynamicApiUtils.getMemberInfo(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp-> {
                        if (resp.code == 0) {
                            MemberInfoBean.MemberInfo person = resp.data.person;
                            name = person.name;
                            String gender = person.gender + "";
                            head = person.head;
                            String visit_count = person.visit_count + "";
                            zan_count = person.zan_count + "";
                            fans_count = person.fans_count + "";
                            String is_focused = person.is_focused + "";
                            String is_zan = person.is_zan + "";
                            String is_black = person.is_black + "";
                            age = person.age + "";
                            emotional_state = person.marriage;
                            job = person.profession;
                            address = person.address;
                            introduction = person.description;
                            ipProvince = person.ipProvince;
                            String bg = person.bg;
                            GlideApp.with(MembersActivity.this)
                                    .load(head)
                                    .error(R.drawable.dynamic_head_place_hold_pic)
                                    .into(members_top_head_iv);
                            GlideApp.with(MembersActivity.this)
                                    .load(bg)
                                    .placeholder(R.drawable.dynamic_default_img)
                                    .error(R.drawable.dynamic_default_img)
                                    .centerCrop()
                                    .into(members_top_bg_iv);
                            members_top_user_tv.setText(name);
                            if ("1".equals(gender)) {//1男2女
                                members_top_user_gender_iv.setImageResource(R.drawable.dynamic_male);
                            } else if ("2".equals(gender)) {
                                members_top_user_gender_iv.setImageResource(R.drawable.dynamic_female);
                            }
                            members_top_user_visit_num_tv.setText("访客 " + visit_count);
                            members_top_user_fensi_num_tv.setText("粉丝 " + fans_count);
                            members_top_user_zan_num_tv.setText("温暖 " + zan_count);
                            if (!"4".equals(focus_state)) {
                                members_top_user_focus_iv.setVisibility(View.VISIBLE);
                                if ("1".equals(is_black)) { //黑名单关系，1已加入黑名单，2未入黑名单
                                    members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focused_topic_detail_bg);
                                    members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, null, null);
                                    members_top_user_focus_iv.setVisibility(View.GONE);
                                    members_top_user_focus_ortion_tv.setText("已屏蔽");
                                    shielding = true;
                                } else {
                                    shielding = false;
                                    members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focus_topic_detail_bg);
                                    members_top_user_focus_iv.setVisibility(View.VISIBLE);
                                    if ("1".equals(is_focused)) {//关注：1已关注，2未关注
                                        members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_has_focus_bg);
                                        Drawable drawable = getResources().getDrawable(R.drawable.dynamic_ic_expand);
                                        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                                        members_top_user_focus_ortion_tv.setCompoundDrawablePadding(20);
                                        members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, drawable, null);

//                                    members_top_user_focus_ortion_hint_iv.setVisibility(View.VISIBLE);
                                        members_top_user_focus_ortion_tv.setText("已关注");
                                        members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                                        focus_state = "1";
                                    } else {
                                        members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focus_topic_detail_bg);
                                        members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, null, null);
                                        members_top_user_focus_ortion_tv.setText("+ 关注");
                                        members_top_user_focus_ortion_tv.setTextColor(Color.parseColor("#ffffff"));
                                        focus_state = "2";
                                    }

                                    if ("1".equals(is_zan)) {//1赞，2未赞
                                        members_top_user_focus_iv.setImageResource(R.drawable.dynamic_newsfeed_like_sel);
                                        zan_state = true;
                                    } else {
                                        members_top_user_focus_iv.setImageResource(R.drawable.dynamic_newsfeed_like);
                                        zan_state = false;
                                    }
                                }
                            }
                            members_top_user_focus_ortion_rel.setVisibility(View.VISIBLE);
                            members_top_user_focus_iv.setVisibility(View.VISIBLE);
                        } else {
                            ToastUtil.toastShort(MembersActivity.this, resp.msg);
                        }
                }, throwable ->{
                    DynamicApiUtils.handleError(MembersActivity.this, throwable);
                });

    }


    @Override
    public void onClick(View v) {
        if (v.getId()==R.id.members_title_back_iv){
            onBackPressed();
        }else if (v.getId()==R.id.members_title_top_right_tv){
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(this, true)) {
                RightSet();
            }
        }else if (v.getId()==R.id.members_trend_rel){
            setTabSelection(0);
        }else if (v.getId()==R.id.members_information_rel){
            setTabSelection(1);
        }else if (v.getId()==R.id.members_top_user_focus_ortion_rel){
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(this, true)) {
                if (shielding == false) {
                    if ("1".equals(focus_state)) {//1已关注,2未关注,4代表自己
                        String phone = DynamicIn.INSTANCE.getUserInfo().getPhone();
                        // 弹框提示是否取消关注
                        if (cancelFocusDialog == null) {
                            cancelFocusDialog = new CancelFocusDialog(this, () -> Focus());
                        }
                        cancelFocusDialog.show();
                    } else if ("2".equals(focus_state)) {
                        //关注
                        Focus();
                    } else if ("4".equals(focus_state)) {
                        JumpToPersonInfo();
                    } else {
                        //屏蔽状态，点击无反应
                    }

                }
            }
        }else if (v.getId()==R.id.members_top_user_focus_iv){
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(this,true)) {
                Zan();
            }
        }else if (v.getId()== R.id.members_top_head_iv){
            Intent intent = new Intent();
            intent.putExtra("browse_type", "member");
            Bundle bd = new Bundle();
            List<ParcelableImage> images = new ArrayList<ParcelableImage>();
            ParcelableImage image = new ParcelableImage(head);
            images.add(image);
            bd.putParcelableArrayList("allTrendImages", (ArrayList<? extends Parcelable>) images);
            intent.putExtra("allTrendImages_bd", bd);
            intent.setClass(MembersActivity.this, BrowsePicturesActivity.class);
            startActivity(intent);
        }
    }

    /**
     * 点赞
     */
    private void Zan() {
        members_top_user_focus_iv.setEnabled(false);
        Command.ZanAction cmd = new Command.ZanAction("1", mem_id);
        DynamicApiUtils.zanAction(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                    members_top_user_focus_iv.setEnabled(true);
                    if (resp.code == 0) {
                        int zan_numi = Integer.valueOf(zan_count);
                        switch (resp.data.status) {
                            case 1: {
                                members_top_user_focus_iv.setImageResource(R.drawable.dynamic_newsfeed_like_sel);
                                ObjectAnimator animator1 = ObjectAnimator.ofFloat(members_top_user_focus_iv, "scaleX", 1f, 1.5f, 1f);
                                ObjectAnimator animator2 = ObjectAnimator.ofFloat(members_top_user_focus_iv, "scaleY", 1f, 1.5f, 1f);
                                AnimatorSet set = new AnimatorSet();
                                set.setDuration(500);
                                set.playTogether(animator1, animator2);
                                set.start();
                                zan_state = true;
                                zan_count = (zan_numi + 1) + "";
                                members_top_user_zan_num_tv.setText("温暖 " + zan_count);
                                break;
                            }
                            case 2: {
                                members_top_user_focus_iv.setImageResource(R.drawable.dynamic_newsfeed_like);
                                ObjectAnimator animator1 = ObjectAnimator.ofFloat(members_top_user_focus_iv, "scaleX", 1f, 1.5f, 1f);
                                ObjectAnimator animator2 = ObjectAnimator.ofFloat(members_top_user_focus_iv, "scaleY", 1f, 1.5f, 1f);
                                AnimatorSet set = new AnimatorSet();
                                set.setDuration(500);
                                set.playTogether(animator1, animator2);
                                set.start();
                                zan_state = false;
                                zan_count = (zan_numi - 1) + "";
                                members_top_user_zan_num_tv.setText("温暖 " + zan_count);
                                break;
                            }
                        }
                    } else {
                        ToastUtil.toastShort(MembersActivity.this, resp.msg);
                    }

                }, throwable -> {
                    members_top_user_focus_iv.setEnabled(true);
                    DynamicApiUtils.handleError(MembersActivity.this, throwable);
                });
    }

    /**
     * 跳转修改个人资料
     */
    private void JumpToPersonInfo() {
//        OuterEmptyImp.jumpToPersonInfoActivity(MembersActivity.this);
        DynamicIn.INSTANCE.personalInfoIntent(this);
    }

    /**
     *
     */
    @SuppressLint("CheckResult")
    private void Focus() {

        showProgressDialog("");
        Command.FocusCmd cmd = new Command.FocusCmd(mem_id, "1");
        DynamicApiUtils.focus(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                    if (resp.code == 0) {
                        //关注成功
                        dismissProgressDialog();
                        int fans_counti = Integer.valueOf(fans_count);
                        String status = String.valueOf(resp.data.status);//1关注，2取消关注
                        if ("1".equals(status)) {
                            members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_has_focus_bg);
                            fans_count = (fans_counti + 1) + "";
                            members_top_user_fensi_num_tv.setText("粉丝 " + fans_count);
                            focus_state = "1";
                            EventBus.getDefault().post(new dynamicFocusEvent(focus_state));
                            Drawable drawable = getResources().getDrawable(R.drawable.dynamic_ic_expand);
                            drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                            members_top_user_focus_ortion_tv.setCompoundDrawablePadding(20);
                            members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, drawable, null);
                            members_top_user_focus_ortion_tv.setText("已关注");
                            members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                        } else {
                            members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focus_topic_detail_bg);
                            fans_count = (fans_counti - 1) + "";
                            members_top_user_fensi_num_tv.setText("粉丝 " + fans_count);
                            focus_state = "2";
                            EventBus.getDefault().post(new dynamicFocusEvent(focus_state));
                            members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, null, null);
                            members_top_user_focus_ortion_tv.setText("+ 关注");
                            members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.dynamic_white));
                        }
                    } else {
                        String msg = resp.msg;
                        ToastUtil.toastShort(MembersActivity.this, msg);
                        dismissProgressDialog();
                    }
                }, throwable -> {
                    dismissProgressDialog();
                    DynamicApiUtils.handleError(MembersActivity.this, throwable);
                });
    }

    /**
     * 右上角按钮
     */
    private void RightSet() {

        final List<String> dialog_datas = new ArrayList<String>();
        if (!shielding) {
            dialog_datas.add("屏蔽ta");
        } else {
            dialog_datas.add("解除屏蔽");
        }
        dialog_datas.add("举报");
        dialog_datas.add("投诉与反馈");
        int itemTextColor = getResources().getColor(R.color.dynamic_black);
        ListDialog.Builder builder1 = new ListDialog.Builder(MembersActivity.this, dialog_datas, itemTextColor);
        builder1.SetLastStr("取消");
        builder1.SetLastButton("取消", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder1.SetOnItemClickLister(new ListDialog.Builder.OnItemClickLister() {
            @Override
            public void onItemClick(Dialog dialog, View view, int position) {
                switch (position) {
                    case 0:
                        if (!shielding) {
                            shieldHint();
                        } else {
                            RemoveShielding();
                        }
                        break;
                    case 1:
                        report();
                        break;
                    case 2:
                        ARouter.getInstance().build("/mine/FeedBackActivity").navigation();
                        break;
                }
                dialog.dismiss();
            }


            @Override
            public void onItemLongClick(Dialog dialog, View view, int position) {

            }
        });
        builder1.create().show();

    }


    /**
     * 解除屏蔽
     */
    private void RemoveShielding() {
        showProgressDialog("");
        Command.RmBlack cmd = new Command.RmBlack(mem_id);
        DynamicApiUtils.rmBlack(cmd)
                .subscribeOn(Schedulers.io())
                .compose(RxUtils.INSTANCE.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                    members_top_user_focus_iv.setVisibility(View.VISIBLE);
                    if ("1".equals(focus_state)) {//关注：1已关注，2未关注
                        members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_has_focus_bg);
                        Drawable drawable = getResources().getDrawable(R.drawable.dynamic_ic_expand);
                        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                        members_top_user_focus_ortion_tv.setCompoundDrawablePadding(20);
                        members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, drawable, null);
                        members_top_user_focus_ortion_tv.setText("已关注");
                        members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                    } else {
                        members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focus_topic_detail_bg);
                        members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, null, null);
                        members_top_user_focus_ortion_tv.setText("+ 关注");
                        members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.dynamic_white));
                    }
                    if (zan_state == true) {//1赞，2未赞
                        members_top_user_focus_iv.setImageResource(R.drawable.dynamic_newsfeed_like_sel);
                    } else {
                        members_top_user_focus_iv.setImageResource(R.drawable.dynamic_newsfeed_like);
                    }
                    members_top_user_focus_iv.setVisibility(View.VISIBLE);
                    shielding = false;
                    dismissProgressDialog();
                    ToastUtil.toastShort("解除屏蔽成功");
                    BlackEvent changeEvent = new BlackEvent(true);
                    EventBus.getDefault().post(changeEvent);
                }, throwable -> {
                    dismissProgressDialog();
                    DynamicApiUtils.handleError(MembersActivity.this, throwable);
                });

    }

    /**
     * 屏蔽提示
     */
    private void shieldHint() {
        AlertDialog.Builder builder = new AlertDialog.Builder(MembersActivity.this);
        builder.setTitle("提示");
        builder.setMessage("屏蔽之后将收不到对方的任何消息,并且看不到ta的动态");
        builder.setPositiveButton("确定屏蔽",
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        Shielding();
                        dialog.dismiss();
                    }
                });
        builder.setNegativeButton("放弃",
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
        if (!MembersActivity.this.isFinishing()){
            builder.create().show();
        }
    }

    /**
     * 屏蔽
     */
    private void Shielding() {
        showProgressDialog("");
        Command.SetBlackCall cmd = new Command.SetBlackCall(mem_id);
        DynamicApiUtils.setBlackCall(cmd)
                .subscribeOn(Schedulers.io())
                .compose(RxUtils.INSTANCE.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                        members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focused_topic_detail_bg);
                        members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, null, null);
                        members_top_user_focus_iv.setVisibility(View.GONE);
                        members_top_user_focus_ortion_tv.setText("已屏蔽");
                        members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.dynamic_white));
                        ToastUtil.toastShort("已屏蔽");
                        BlackEvent changeEvent = new BlackEvent(true);
                        EventBus.getDefault().post(changeEvent);
                        focus_state = "2";
                        shielding = true;
                        dismissProgressDialog();
                }, throwable -> {
                    dismissProgressDialog();
                    DynamicApiUtils.handleError(MembersActivity.this, throwable);
                });

    }

    /**
     * //获取举报的内容列表
     */
    public void report() {
        if (reportReasons == null) {
            Command.GetReportReason cmd = new Command.GetReportReason();
            DynamicApiUtils.getReportReason(cmd)
                    .subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(resp -> {
                        if (resp.code!=0){
                            ToastUtil.toastShort(resp.msg);
                            return;
                        }
                        LinkedTreeMap<String, String> reportReasonsmaps =
                                (LinkedTreeMap<String, String>) resp.data;
                        if (reportReasonsmaps == null)
                            return;
                        reportReasonsId = new ArrayList<>();
                        reportReasons = new ArrayList<>();
                        for (Map.Entry<String, String> entry : reportReasonsmaps.entrySet()) {
                            reportReasonsId.add(entry.getKey());
                            reportReasons.add(entry.getValue());
                        }
                        showReportReason();
                    }, throwable -> DynamicApiUtils.handleError(MembersActivity.this, throwable));
        } else {
            showReportReason();
        }
    }

    /**
     * 举报
     */
    public void showReportReason() {
        if (reportReasons == null || reportReasons.size() <= 0) return;
        int itemTextColor = Color.RED;
        ListDialog.Builder builder1 = new ListDialog.Builder(this, reportReasons, itemTextColor);
        builder1.SetLastStr("取消");
        builder1.SetLastButton("取消", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder1.SetOnItemClickLister(new ListDialog.Builder.OnItemClickLister() {
            @Override
            public void onItemClick(Dialog dialog, View view, int position) {
                dialog.dismiss();
                if (!DynamicIn.INSTANCE.loginByOneKeyLogin(MembersActivity.this,true)) {
                    return;
                }
                Command.ReportWorry cmd = new Command.ReportWorry(Integer.valueOf(mem_id), Integer.valueOf(reportReasonsId.get(position)), 0, reportReasons.get(position), 2);
                DynamicApiUtils.reportWorry(cmd)
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .doOnSubscribe(new Consumer<Disposable>() {
                            @Override
                            public void accept(Disposable disposable) throws Exception {
                                showProgressDialog("");
                            }
                        })
                        .doAfterTerminate(() -> dismissProgressDialog())
                        .subscribe(resp -> {
                            if (resp.code == 0) {
                                ToastUtil.toastShort(MembersActivity.this, "举报成功");
                            } else {
                                ToastUtil.toastShort(MembersActivity.this, resp.msg);
                            }

                        }, throwable -> DynamicApiUtils.handleError(MembersActivity.this, throwable));
            }

            @Override
            public void onItemLongClick(Dialog dialog, View view, int position) {

            }
        });
        builder1.create().show();
    }

    private void setTabSelection(int index) {
        // 重置按钮
        resetText();
        // 开启一个Fragment事务
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        // 先隐藏掉所有的Fragment，以防止有多个Fragment显示在界面上的情况
        hideFragments(transaction);
        switch (index) {
            case 0:
                members_trend_tv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                members_trend_hint_tv.setBackgroundColor(getResources().getColor(R.color.platform_main_theme));

                if (trendlisfragment == null) {
                    trendlisfragment = TrendListInFragment.newInstance("3", "0", "member_trend", mem_id);
                    transaction.add(R.id.members_content_frm, trendlisfragment);
                } else {
                    transaction.show(trendlisfragment);
                }
                select_tab = 0;
                break;
            case 1:
                members_information_tv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                members_information_hint_tv.setBackgroundColor(getResources().getColor(R.color.platform_main_theme));
                if (memberfragment == null) {
                    memberfragment = MemberFragment.newInstance(age, emotional_state, job, address, introduction, ipProvince);
                    transaction.add(R.id.members_content_frm, memberfragment);
                } else {
                    transaction.show(memberfragment);
                }
                select_tab = 1;
                break;

        }
        transaction.commit();
    }

    private void hideFragments(FragmentTransaction transaction) {
        if (trendlisfragment != null) {
            transaction.hide(trendlisfragment);
        }
        if (memberfragment != null) {
            transaction.hide(memberfragment);
        }

    }

    private void resetText() {
        members_trend_tv.setTextColor(getResources().getColor(R.color.dynamic_text_gray));
        members_trend_hint_tv.setBackgroundColor(getResources().getColor(R.color.dynamic_white));
        members_information_tv.setTextColor(getResources().getColor(R.color.dynamic_text_gray));
        members_information_hint_tv.setBackgroundColor(getResources().getColor(R.color.dynamic_white));
    }

    @Override
    public void onScrollChanged(MyNestedScrollView scrollView, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {

        if (DIS == 0) {
            DIS = members_type_lin.getTop();
            title_rel_bottom = members_title_rel.getBottom();
        }
        int y = members_myScrov.getScrollY();
        if (y < DIS - title_rel_bottom) {
            members_type_lin.setTranslationY(-y);
        } else {
            members_type_lin.setTranslationY(title_rel_bottom - DIS);
        }

        if (scrollY <= 0) {   //设置标题的背景颜色
            members_title_top_tv.setTextColor(getResources().getColor(R.color.dynamic_trend_transparent));
            members_title_top_tv.setText("");
            members_title_back_iv.setImageResource(R.drawable.dynamic_titlebar_back2);
            members_title_top_right_tv.setImageResource(R.drawable.dynamic_more_green2);
            members_title_rel.setBackgroundColor(getResources().getColor(R.color.dynamic_trend_transparent));
//            members_top_view.setBackgroundColor(getResources().getColor(R.color.dynamic_trend_transparent));
        } else if (scrollY > 0 && scrollY <= height - 55) { //滑动距离小于banner图的高度时，设置背景和字体颜色颜色透明度渐变
            members_title_top_tv.setTextColor(getResources().getColor(R.color.dynamic_trend_transparent));
            members_title_top_tv.setText("");
            members_title_back_iv.setImageResource(R.drawable.dynamic_titlebar_back2);
            members_title_top_right_tv.setImageResource(R.drawable.dynamic_more_green2);
//            members_top_view.setBackgroundColor(getResources().getColor(R.color.dynamic_trend_transparent));
            members_title_rel.setBackgroundColor(getResources().getColor(R.color.dynamic_trend_transparent));
        } else {    //滑动到banner下面设置普通颜色
            members_title_top_tv.setTextColor(getResources().getColor(R.color.dynamic_black));
            members_title_top_tv.setText(name);
            members_title_back_iv.setImageResource(R.drawable.platform_common_back);
            members_title_top_right_tv.setImageResource(R.drawable.platform_common_notice_more_un);
//            members_top_view.setBackgroundColor(getResources().getColor(R.color.dynamic_black));
            members_title_rel.setBackgroundDrawable(getResources().getDrawable(R.drawable.dynamic_layout_border));
        }

    }

    @SuppressLint("WrongConstant")
    @Override
    protected void onResume() {
        super.onResume();
        if (mem_id.equals(DynamicIn.INSTANCE.getUserInfo().getUid() + "")) {
            focus_state = "4";
//            members_top_user_focus_ortion_rel.setVisibility(View.VISIBLE);
            members_top_user_focus_ortion_rel.setBackgroundResource(R.drawable.dynamic_focused_topic_detail_bg);
//             members_top_user_focus_ortion_hint_iv.setVisibility(View.GONE);
            members_top_user_focus_ortion_tv.setCompoundDrawables(null, null, null, null);
            members_top_user_focus_iv.setVisibility(View.GONE);
            members_top_user_focus_ortion_tv.setText("修改资料");
            members_top_user_focus_ortion_tv.setTextColor(getResources().getColor(R.color.dynamic_text_trend_black));
            members_title_top_right_tv.setVisibility(View.GONE);
            members_top_user_focus_iv.setVisibility(View.GONE);
        }
    }

    public void setHandler(Handler handler, String tab) {
        this.tab = tab;
        if ("3".equals(tab)) {//TrendListInFragment.newInstance("3", "0", "member_trend", mem_id);
            mHandler1 = handler;
        }
    }

    @Override
    public void onRefresh() {
        initDatas();
        if (is_first_refreh) {
            if (0 == select_tab && "3".equals(tab)) {
                Message msg = new Message();
                msg.what = DynamicConstants.MEMBER_REFRESH;
                msg.obj = mem_id;
                mHandler1.sendMessage(msg);
            }
        }
        member_swrl.setRefreshing(false);
        is_first_refreh = true;
    }

    public void onEvent(LoginStateEvent event) {
        if ("login".equals(event.getLogin_state())) {
            initDatas();
        }
    }

    public void onEvent(UserLoginEvent event) {
        if ("login".equals(event.getLogin_state())) {
            initDatas();
        }
    }

    @Override
    public void onBackPressed() {
        getIntent().putExtra("focus", focus_state);
        setResult(-1, getIntent());
        finish();
    }

    @Override
    protected int layoutResId() {
        return 0;
    }

    @Override
    protected void initDataAndEvent() {

    }
}
