package com.yidianling.dynamic.model;

import com.google.gson.annotations.SerializedName;
import com.ydl.ydlcommon.bean.ShareData;

import java.util.ArrayList;
import java.util.List;

/**
 * 动态详情Bean
 * Created by hgw on 2017/3/21.
 */

public class TrendsDetailInfoBean {

    public TrendBody active;//帖子内容

    public List<ZanImg> members;//点赞用户列表

    public List<CommentBean> comments;//评论列表

    public List<Ad> adsData;//广告列表

    public static class Ad {
        public int focId;

        public String adImg;

        public String url;

        public String title;

        public String content;

        public ShareData share;

        public int visitCount;

        @Override
        public String toString() {
            return "Ad{" +
                    "focId=" + focId +
                    ", adImg='" + adImg + '\'' +
                    ", url='" + url + '\'' +
                    ", title='" + title + '\'' +
                    ", content='" + content + '\'' +
                    ", share=" + share +
                    ", visitCount=" + visitCount +
                    '}';
        }
    }

    //帖子详情
    public static class TrendBody {

        public int id;//帖子id
        @SerializedName(value = "isSelf",alternate = "is_self")
        public int is_self;//是否是自己的帖子1是0不是
        public String name;
        @SerializedName(value = "header",alternate = "avatar")
        public String header;//头像
        public int gender;//1男2女
        public int is_top;//1普通2置顶
        public String title;//帖子标题
        public String timeStr;//时间
        public String from;//来自设备
        public String visitCount;//访问量
        public int isZan;//是否已赞 1已赞2未赞
        public int zanCount;
        public int replyCounter;//回复数
        public String content;//正文
        public ArrayList<IMage> bigAttach;//大图
        public int topicId;//话题id
        public String topicTitle;//话题标题
        public int isFocused;//1已关注，2未关注
        public String uid;
        public String multitextType;//动态类型
        public ExtAd ext;
        public String ipProvince;
    }

    //图片
    public static class IMage {
        public String url;
        public int width;
        public int height;
    }

    //赞列表Bean
    public static class ZanImg {
        public String head;//赞头像
        public int uid;//赞用户id

        public ZanImg() {
        }

        public ZanImg(String head, int uid) {
            this.head = head;
            this.uid = uid;
        }
    }

    /**
     * 广告
     */
    public static class ExtAd {
        public String title;
        public String url;
        public String cover;
    }

}
