package com.yidianling.dynamic.publishTrend;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;

import com.miracle.view.imageeditor.utils.FileUtils;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_image.transform.GlideRoundTransform;
import com.ydl.ydlcommon.ui.ParcelableImage;
import com.yidianling.dynamic.R;

import java.util.List;

public class DynamicPublishImageAdapter extends RecyclerView.Adapter<PublishImageViewHolder> {
    private static final String TAG = "RecommendTrendImgAdapte";

    protected Context mContext;
    protected List<ParcelableImage> mDatas;
    protected LayoutInflater mInflater;

    public interface OnItemClickLister {
        void onItemClick(View view, int position);

        void onItemLongClick(View view, int position);
    }

    public interface OnDeleteClickLister {
        void onDeleteClick(View view, int position);

        void onDeleteLongClick(View view, int position);
    }

    public interface OnAddClickLister {
        void OnAddClick(View view, int position);

        void OnAddLongClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;
    private OnDeleteClickLister mOnDeleteClickLister;
    private OnAddClickLister mOnAddClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public void setOnDeleteClickLister(OnDeleteClickLister lister) {
        this.mOnDeleteClickLister = lister;
    }

    public void setOnAddClickLister(OnAddClickLister lister) {
        this.mOnAddClickLister = lister;
    }

    public DynamicPublishImageAdapter(List<ParcelableImage> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public PublishImageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = null;
        view = mInflater.inflate(R.layout.dynamic_publish_img_item, parent, false);
        PublishImageViewHolder viewHolder = new PublishImageViewHolder(view);
        return viewHolder;
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Override
    public void onBindViewHolder(PublishImageViewHolder holder, final int position) {
        ParcelableImage trendImage = mDatas.get(position);
        String path = trendImage.getImage_url();

        if ("default".equals(path)) {
            holder.bg_iv.setVisibility(View.VISIBLE);
            holder.item_publish_iv.setVisibility(View.GONE);
            holder.item_publish_cancel_iv.setVisibility(View.GONE);
        } else {
            holder.item_publish_cancel_iv.setVisibility(View.VISIBLE);
            holder.bg_iv.setVisibility(View.GONE);
            holder.item_publish_iv.setVisibility(View.VISIBLE);
            Uri uriByPath = FileUtils.INSTANCE.getUriByPath(mContext, path);
            GlideApp.with(mContext)
                    .load(uriByPath)
                    .error(R.drawable.dynamic_add_temp)
                    .transform(new GlideRoundTransform(mContext, 6))
//                    .centerCrop()
                    .into(holder.item_publish_iv);
        }

        setUpItemEvent(holder);
        setUpDeleteEvent(holder);
        setUpAddEvent(holder);
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }


    public void updateDate(List<ParcelableImage> mDatas) {
        this.mDatas = mDatas;
        notifyDataSetChanged();
    }

    /**
     * 添加据到指定位置
     *
     * @param pos        数据添加的位置
     * @param trendImage 数据
     */
    public void addData(int pos, ParcelableImage trendImage) {
        mDatas.add(trendImage);
        notifyItemInserted(pos);
    }

    /**
     * 删除指定位置数据
     *
     * @param pos
     */
    public void deleteData(int pos) {
        mDatas.remove(pos);
        notifyItemRemoved(pos);
    }

    /**
     * 给item添加监听
     *
     * @param holder
     */
    protected void setUpItemEvent(final PublishImageViewHolder holder) {
        if (mOnItemClickLister != null) {
            holder.item_publish_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.item_publish_iv, layoutPosition);

                }
            });
            holder.itemView.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemLongClick(holder.item_publish_iv, layoutPosition);
                    return false;
                }
            });
        }
    }

    /**
     * 添加监听
     *
     * @param holder
     */
    protected void setUpDeleteEvent(final PublishImageViewHolder holder) {
        if (mOnItemClickLister != null) {
            holder.item_publish_cancel_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnDeleteClickLister.onDeleteClick(holder.item_publish_cancel_iv, layoutPosition);

                }
            });
            holder.item_publish_cancel_iv.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnDeleteClickLister.onDeleteLongClick(holder.item_publish_cancel_iv, layoutPosition);
                    return false;
                }
            });
        }
    }

    /**
     * 添加监听
     *
     * @param holder
     */
    protected void setUpAddEvent(final PublishImageViewHolder holder) {
        if (mOnAddClickLister != null) {
            holder.bg_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnAddClickLister.OnAddClick(holder.bg_iv, layoutPosition);

                }
            });
            holder.bg_iv.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnAddClickLister.OnAddLongClick(holder.bg_iv, layoutPosition);
                    return false;
                }
            });
        }
    }


}

class PublishImageViewHolder extends RecyclerView.ViewHolder {
    ImageView item_publish_iv, item_publish_cancel_iv, bg_iv;

    public PublishImageViewHolder(View itemView) {
        super(itemView);
        bg_iv = (ImageView) itemView.findViewById(R.id.item_publish_defult_iv);
        item_publish_iv = (ImageView) itemView.findViewById(R.id.item_publish_iv);
        item_publish_cancel_iv = (ImageView) itemView.findViewById(R.id.item_publish_cancel_iv);
    }
}