package com.yidianling.dynamic.thank.view

import android.app.Activity
import android.text.TextUtils
import android.view.View
import android.widget.LinearLayout
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydl_image.transform.GlideCircleTransform
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.view.RoundCornerButton
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
import com.yidianling.dynamic.R
import com.yidianling.dynamic.common.net.DynamicApiUtils
import com.yidianling.dynamic.event.ThankReplyUpdateEvent
import com.yidianling.dynamic.model.Command
import com.yidianling.dynamic.router.DynamicIn
import com.yidianling.dynamic.thank.ShowIntroduceDialogFragment
import com.yidianling.dynamic.thank.ThankActivity
import com.yidianling.dynamic.thank.WorryDetailAnswer
import com.yidianling.dynamic.thank.data.ThxData
import com.yidianling.ydl_pay.common.CommonPayDialog
import de.greenrobot.event.EventBus
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.dynamic_ui_thank_head.view.*

/**
 * Created by softrice on 15/11/25.
 */
class ThankHeadView(activity: Activity) : LinearLayout(activity) {

    private val activity: BaseActivity
    open var rcb_msg_submit: RoundCornerButton? = null

    internal var thxData: ThxData? = null
    internal var worryDetailAnswer: WorryDetailAnswer? = null


    internal var answerId = 0

    internal var listNum = 0

    val selectId: Int
        get() = tsv_select!!.getSelectId()

    val content: String
        get() = et_msg!!.text.toString()

    fun setAnswerId(answerId: Int) {
        this.answerId = answerId
    }

    fun setlistNum(listNum: Int) {
        this.listNum = listNum
    }

    fun setWorryDetailAnswer(worryDetailAnswer: WorryDetailAnswer) {
        this.worryDetailAnswer = worryDetailAnswer
    }


    init {
        View.inflate(activity, R.layout.dynamic_ui_thank_head, this)
        this.activity = activity as BaseActivity
    }

    fun setData(thxData: ThxData) {
        this.thxData = thxData
        tsv_select!!.setData(thxData.star_money)
        LogUtil.d("thank userInfo head: " + thxData.userInfo.head)
        GlideApp.with(activity)
            .load(thxData.userInfo.head)
            .transform(GlideCircleTransform(activity))
            .placeholder(R.drawable.dynamic_head_place_hold_pic)
            .error(R.drawable.dynamic_head_place_hold_pic)
            .into(sdv_head!!)

        rcb_submit.setOnClickListener {
            if (answerId == 0)
                return@setOnClickListener
            if (thxData == null || thxData!!.userInfo == null || thxData!!.userInfo.uid == null)
                return@setOnClickListener
            if (thxData!!.userInfo.uid == DynamicIn.getUserInfo()!!.uid) {
                ToastUtil.toastShort("不能给自己点赞")
                return@setOnClickListener
            }
            submitWithMoney()
        }
    }

//    @OnClick(R2.id.rcb_submit, R2.id.rcb_msg_submit)
//    internal fun click(view: View) {
//
//        if (view.id == R.id.rcb_submit) {
//            submitWithMoney()
//        } else if (view.id == R.id.rcb_msg_submit) {
//            submitWithoutMoney()
//        }
//    }

    internal fun submitWithMoney() {
        var starNum = 0
        if (selectId == -1) {
            ToastUtil.toastShort("请选择你的心意")
            return
        } else {
            starNum = thxData!!.star_money[selectId].star_num
        }
        activity.showProgressDialog(null)
        val cmd = Command.SubmitZan(
            Integer.parseInt(thxData!!.userInfo.uid),
            starNum, content, answerId, 1
        )
        val disposable = DynamicApiUtils.submitZan(cmd)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ resp ->
                activity.dismissProgressDialog()
                if (resp.code == 0) {
                    val sendThxWithMoney = resp.data
//                    val payParams = PayParams()
//                    payParams.setTitle("送感谢")
//                    payParams.setPayId(sendThxWithMoney.payId)
//                    payParams.setNeedPay(sendThxWithMoney.money)
//                    YdlCommonOut.startPayActivity(context as Activity, payParams, 0)

                    toPay(sendThxWithMoney.payId, sendThxWithMoney.money)
                } else {
                    ToastUtil.toastShort(resp.msg)
                }
            }, { throwable ->
                DynamicApiUtils.handleError(context, throwable)
                activity.dismissProgressDialog()
            })
    }

    internal fun submitWithoutMoney() {
        val starNum = 0
        activity.showProgressDialog(null)
        val cmd = Command.SubmitZan(
            Integer.parseInt(thxData!!.userInfo.uid),
            starNum, content, answerId, 2
        )
        val disposable = DynamicApiUtils.submitZan(cmd)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ resp ->
                activity.dismissProgressDialog()
                if (resp.code == 0) {
                    if (worryDetailAnswer != null) {
                        val showIntroduceDialogFragment = ShowIntroduceDialogFragment()
                            .setPamrams(
                                worryDetailAnswer!!.pDoctorId.toString(),
                                worryDetailAnswer!!.pUid.toString(),
                                worryDetailAnswer!!.listener_id.toString(),
                                worryDetailAnswer!!.pName,
                                worryDetailAnswer!!.pHead,
                                ""
                            )
                        showIntroduceDialogFragment.show(
                            (context as Activity).fragmentManager,
                            showIntroduceDialogFragment.javaClass.name
                        )
                        ToastUtil.toastImg(context, R.drawable.dynamic_dialog_send_thx_success)
                        EventBus.getDefault().post(ThankReplyUpdateEvent())
                    } else {
                        ToastUtil.toastImg(context, R.drawable.dynamic_dialog_send_thx_success)
                        EventBus.getDefault().post(ThankReplyUpdateEvent())
                        //通知更新
                    }
                } else {
                    ToastUtil.toastShort(resp.msg)
                }
            }, { throwable ->
                DynamicApiUtils.handleError(context, throwable)
                activity.dismissProgressDialog()
            })

    }


    fun toPay(payId: String, money: Float) {
        val userInfo = DynamicIn.getUserInfo()
        if (userInfo == null || TextUtils.isEmpty(userInfo.uid)) {
            DynamicIn.loginByOneKeyLogin(activity,true)
            return
        }
//
        val build = CommonPayDialog.Build(activity)
            .setPayId(payId)
            .setPayMoney(money)
            .setToken(userInfo.accessToken!!)
            .setUid(userInfo.uid)
            .setFfrom(PlatformDataManager.getRam().getChannelName())
            .setListener(object : CommonPayDialog.OnPayResultListener {
                override fun onSuccesed() {
                    //刷新界面

                    (activity as ThankActivity).getData(false)
                }

                override fun onFailed() {

                }
            })
            .setIsTestEnvironment(false)
        build.build().show()
    }

}
