package com.yidianling.dynamic.topic.topicDetail;


import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.mvp.base.IView;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.model.Command;
import com.yidianling.dynamic.topic.http.TopicDataManager;

import io.reactivex.disposables.Disposable;

/**
 * Created by Jim on 2017/12/28 0028.
 */

public class TopicDetailInteractor {

    public TopicDetailInteractor(ITopicDetailPresenter.ITopicDetailInteracor callBack) {
        this.callBack = callBack;
    }

    private ITopicDetailPresenter.ITopicDetailInteracor callBack;

    public Disposable getTopicDetail(String topicId, IView iView) {
        StringBuffer sb = new StringBuffer();
        sb.append("topicId=").append(topicId);
        return TopicDataManager.INSTANCE.getHttp()
                .getTopicDetail(sb.toString())
                .compose(RxUtils.INSTANCE.applySchedulers(iView))
                .compose(RxUtils.resultJavaData())
                .subscribe(topicDetail -> callBack.onTopicDetailDataFetched(topicDetail),
                        throwable -> callBack.onTopicDetailDataFetchFailed(throwable));
    }

    public Disposable focusTopic(String topicId,IView iView) {
        Command.FocusCmd cmd = new Command.FocusCmd(topicId, "2");
        return DynamicApiUtils.focus(cmd)
                .compose(RxUtils.INSTANCE.applySchedulers(iView))
                .compose(RxUtils.INSTANCE.resultData())
                .subscribe(resp->{callBack.onFocusResultFetched(resp);},throwable -> {callBack.onFocusFailed(throwable);});
    }

}
