package com.yidianling.dynamic.trendList;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

/**
 * Created by Jim on 2017/9/25 0025.
 */

public abstract class BaseLazyFragment extends Fragment {

    protected boolean isVisible;
    protected boolean isUseLazyMode=true;


    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(getLayoutId(), container, false);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        afterViewCreated(savedInstanceState);
    }

    public abstract void afterViewCreated(Bundle savedInstanceState);

    public abstract int getLayoutId();

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (!isUseLazyMode){
            return;
        }
        if (getUserVisibleHint()) {
            isVisible = true;
            onVisible();
        } else {
            isVisible = false;
            onInvisible();
        }
    }

    public BaseLazyFragment setIsUseLazyMode(boolean isUseLazyMode){
        this.isUseLazyMode=isUseLazyMode;
        return this;
    }

    protected void onInvisible() {
    }

    protected void onVisible() {
        lazyLoad();
    };

    public abstract void lazyLoad();

}
