package com.yidianling.dynamic.trendList

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.interpolator.view.animation.FastOutLinearInInterpolator
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.utils.BuryPointUtils
import com.ydl.ydlcommon.utils.SharedPreferencesEditor
import com.ydl.ydlcommon.view.WrapContentLinearLayoutManager
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
import com.yidianling.dynamic.R
import com.yidianling.dynamic.bean.DynamicConstants
import com.yidianling.dynamic.common.net.DynamicApiUtils
import com.yidianling.dynamic.model.*
import com.yidianling.dynamic.publishTrend.PublishTrendActivity
import com.yidianling.dynamic.router.DynamicIn
import com.yidianling.dynamic.topic.AllTopicActivity
import com.yidianling.dynamic.trendList.adapter.RecommendTopAdapter
import com.yidianling.dynamic.trendList.adapter.RecommendTopicListAdapter
import com.yidianling.dynamic.trendList.adapter.TrendsListAdapter
import com.yidianling.dynamic.trendList.adapter.TrendsListAdapter.*
import com.yidianling.dynamic.trendsDetail.TrendsDetailActivity
import com.yidianling.dynamic.trendsHome.TrendsHomeFragment
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.dynamic_fragment_trends_list.*


/**
 * 我的动态列表
 * Created by Jim on 2017/9/22 0022.
 */
class TrendsListFragment : BaseLazyFragment(), ITrendsListView,
    SwipeRefreshLayout.OnRefreshListener {

    private val mActivity =activity
    private val REQUEST_CODE = 1001
    private val eachPageDataNum = 20

    internal var totalItemCount: Int = 0
    internal var lastVisibleItem: Int = 0
    internal var visibleItemCount: Int = 0
    internal var firstVisibleItem: Int = 0
    protected var isPrepared: Boolean = false
    private var tab: Int = 0
    private var page: Int = 0
    private var topic_id: Int = 0
    private var last_id: Int = 0
    private var trendType: String? = null
    private var userid: String? = null
    private var isTrendsListLoading: Boolean = false
    private var isRefresh: Boolean = false
    private var isTopicLoading: Boolean = false
    private var isDoLikeAction: Boolean = false
    private var mPresenter: TrendsListPresenter? = null
    private var mRcvAdapter: TrendsListAdapter? = null
    private var trendsDatas: MutableList<TrendsListBean.Trend>? = null
    private var recommendTopicDatas: List<RecommendTopic>? = null
    private var mScrollListener: RecyclerView.OnScrollListener? = null
    private var mRecommendTopicListAdapter: RecommendTopicListAdapter? = null  //最新推荐话题Adapter
    private var mRecommendTopAdapter: RecommendTopAdapter<TrendsListBean.ExtData>? = null
    private var mRecommendTopRcv: RecyclerView? = null
    private var headers: Array<View>? = null

    //推荐话题Header View
    private val headerView: View
        get() {
            val view = LayoutInflater.from(activity)
                .inflate(R.layout.dynamic_item_trends_head_recommend_topic, null)
            recommendTopicDatas = ArrayList()
            mRecommendTopicListAdapter = RecommendTopicListAdapter(activity, recommendTopicDatas)
            val allTopicLin = view.findViewById<View>(R.id.all_topic_lin) as LinearLayout
            allTopicLin.setOnClickListener {
                val intent = Intent(activity, AllTopicActivity::class.java)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                startActivity(intent)
            }
            val headTopicRcv = view.findViewById<View>(R.id.recommend_topic_rcv) as RecyclerView
            val linearLayoutManager =
                LinearLayoutManager(activity)
            linearLayoutManager.orientation = LinearLayoutManager.HORIZONTAL
            headTopicRcv.layoutManager = linearLayoutManager
            headTopicRcv.adapter = mRecommendTopicListAdapter
            return view
        }

    //置顶帖Header View
    private val recommendTopHeaderView: View
        get() {
            val view =
                LayoutInflater.from(activity).inflate(R.layout.dynamic_item_recommend_top, null)
            val linearLayoutManager =
                LinearLayoutManager(activity)
            mRecommendTopAdapter = RecommendTopAdapter<TrendsListBean.ExtData>(activity)
            mRecommendTopRcv = view.findViewById<View>(R.id.recy_top) as RecyclerView
            mRecommendTopRcv?.layoutManager = linearLayoutManager
            mRecommendTopRcv?.adapter = mRecommendTopAdapter
            mRecommendTopRcv?.visibility = View.GONE
            return view
        }

    private val headerCount: Int
        get() {
            if (tab == 1 && trendType == TREND_TYPE_DEFAULT) {
                headers = arrayOf(headerView, recommendTopHeaderView)
                return headers?.size?:0
            }
            return 0
        }

    private val footerView: View
        get() {
            val view: View
            if (trends_rcv != null) {
                view =
                    LayoutInflater.from(activity)
                        .inflate(R.layout.dynamic_progress_item, trends_rcv, false)
            } else {
                view = LayoutInflater.from(activity).inflate(R.layout.dynamic_progress_item, null)
            }
            return view
        }

    private//关注
    val isNeedLogin: Boolean
        get() {
            tab = arguments?.getInt("tab")?:0
            return tab == 3
        }

    private val lastId: Int
        get() {
            var id: String? = "0"
            trendsDatas?.let { trendsDatas ->
                if (trendsDatas.size > 0) {
                    id = trendsDatas[trendsDatas.size - 1].id
                    return if (id == null || id == "") {
                        0
                    } else {
                        Integer.valueOf(id)
                    }
                }
            }

            return 0
        }


    override fun afterViewCreated(savedInstanceState: Bundle?) {
        isPrepared = true      //View创建完成
        lazyLoad()
    }

    override fun getLayoutId(): Int {
        return R.layout.dynamic_fragment_trends_list
    }

    override fun lazyLoad() {
        if (!isUseLazyMode) {
            isVisible = true
        }
        if (!isPrepared || !isVisible) {
            return
        }
        initDatas()
        initViews()
        initClick()
        onRefresh()
        isPrepared = false
    }

    override fun setIsUseLazyMode(isUseLazyMode: Boolean): TrendsListFragment {
        super.setIsUseLazyMode(isUseLazyMode)
        return this
    }

    private fun initViews() {
        if (trendType == TREND_TYPE_USER_TREND || trendType == TREND_TYPE_TOPIC_TREND) {
            trends_lastr_swl?.isEnabled = false
            trends_rcv?.isNestedScrollingEnabled = false
        } else {
            trends_lastr_swl?.setViewGroup(trends_rcv)
            trends_lastr_swl?.setOnRefreshListener(this)
            trends_lastr_swl?.setColorSchemeResources(R.color.platform_main_theme)
        }
        initRecyclerView()
    }

    private fun initDatas() {
        isTopicLoading = false
        isRefresh = false
        isDoLikeAction = false
        isTrendsListLoading = false
        mPresenter = TrendsListPresenter(this)
        arguments?.let {
            tab = it.getInt(KEY_TAB)
            topic_id = it.getInt(KEY_TOPIC_ID)
            trendType = it.getString(KEY_TREND_TYPE)
            userid = it.getString(KEY_USER_ID)
        }
        trendType = if (TextUtils.isEmpty(trendType)) TREND_TYPE_DEFAULT else trendType
        page = 1
        last_id = 0
    }


    private fun initRecyclerView() {
        trendsDatas = ArrayList<TrendsListBean.Trend>()
        mRcvAdapter = TrendsListAdapter(activity, trendsDatas)
        mRcvAdapter?.setOnItemClickListener(object : TrendsListAdapter.OnItemClickListener {
            override fun onItemLikeClick(
                view: View,
                position: Int,
                mDatas: List<TrendsListBean.Trend>
            ) {
                doLikeAction(view, position, mDatas)
            }

            override fun onItemClick(id: Int, commentCount: Int, position: Int) {
                val trend = trendsDatas?.get(position - (mRcvAdapter?.headersCount?:0))
                if (trend?.isAd == 1) {
                    //广告跳转H5
                    NewH5Activity.start(context, H5Params(trend?.url, null, trend?.share))
                    DynamicApiUtils.adClickCount(Command.AdClickCount(trend?.focId))
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe({ objectBaseResponse ->

                        }, { throwable ->

                        })
                    return
                }
                BuryPointUtils.getInstance().createMap()
                    .put("dynamic_ID", trend?.id)
                    .put("dynamic_name", trend?.title)
                    .put("dynamic_type", trend?.topicTitle)
                    .burryPoint("Dynamic_click")
                TrendsDetailActivity.startForResult(
                    this@TrendsListFragment,
                    id,
                    commentCount,
                    false,
                    position,
                    REQUEST_CODE
                )
            }

            override fun onItemCommentClick(id: Int, commentCount: Int, position: Int) {
                BuryPointUtils.getInstance().createMap()
                    .put("dynamic_name", trendsDatas?.get(position - (mRcvAdapter?.headersCount ?: 0))?.title)
                    .put("dynamic_ID", trendsDatas?.get(position - (mRcvAdapter?.headersCount ?: 0))?.id)
                    .put(
                        "dynamic_type",
                        trendsDatas?.get(position - (mRcvAdapter?.headersCount ?: 0))?.topicTitle
                    )
                    .burryPoint("Comment_dynamic")
                TrendsDetailActivity.startForResult(
                    this@TrendsListFragment,
                    id,
                    commentCount,
                    true,
                    position,
                    REQUEST_CODE
                )
            }
        })
        val layoutManager =
            WrapContentLinearLayoutManager(activity, WrapContentLinearLayoutManager.VERTICAL, false)
        //        LinearLayoutManager layoutManager = new LinearLayoutManager(getActivity());
        trends_rcv?.adapter = mRcvAdapter
        trends_rcv?.layoutManager = layoutManager
        trends_rcv?.itemAnimator?.changeDuration = 0  //解决局部刷新闪屏
        mScrollListener = object : RecyclerView.OnScrollListener() {
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                if (RecyclerView.SCROLL_STATE_IDLE == newState) {
                    if (totalItemCount <= lastVisibleItem + 1 && totalItemCount > visibleItemCount && visibleItemCount > 0) {
                        isRefresh = false
                        last_id = lastId
                        LogUtil.i("loadMore last id: $last_id page: $page")
                        this@TrendsListFragment.page++
                        switchDataToFetch()
                    }
                    val pos = layoutManager.findFirstCompletelyVisibleItemPosition()
                    if (pos >= 10) {
                        val parentFragment = parentFragment
                        if (parentFragment != null && parentFragment is TrendsHomeFragment) {
                            parentFragment.displayShowCase()
                        }
                    }
                }
            }

            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                try {
                    if (!recyclerView?.canScrollVertically(-1)) {
                        //滑到顶部，隐藏按钮
                        image_scroll_top?.animate()?.cancel()
                        image_scroll_top?.animate()
                            ?.scaleX(0f)
                            ?.scaleY(0f)
                            ?.alpha(0f)
                            ?.setDuration(200)
                            ?.setInterpolator(FastOutLinearInInterpolator())
                            ?.setListener(object : AnimatorListenerAdapter() {
                                private var mCancelled: Boolean = false

                                @SuppressLint("RestrictedApi")
                                override fun onAnimationStart(animation: Animator) {
                                    if (image_scroll_top != null) {
                                        image_scroll_top?.visibility = View.VISIBLE
                                    }
                                    mCancelled = false
                                }

                                override fun onAnimationCancel(animation: Animator) {
                                    mCancelled = true
                                }

                                @SuppressLint("RestrictedApi")
                                override fun onAnimationEnd(animation: Animator) {
                                    if (!mCancelled && image_scroll_top != null) {
                                        image_scroll_top?.visibility = View.INVISIBLE
                                    }
                                }
                            })
                    }
                    //                    LogUtil.d("onScrolled ");
                    //                    btnScrollTop.setVisibility(View.VISIBLE);
                    val layoutManager = recyclerView.layoutManager as WrapContentLinearLayoutManager
                    totalItemCount = layoutManager.itemCount
                    firstVisibleItem = layoutManager.findFirstVisibleItemPosition()
                    lastVisibleItem = layoutManager.findLastVisibleItemPosition()
                    visibleItemCount = layoutManager.childCount

                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }

        }
        mScrollListener?.let { listener ->
            trends_rcv?.addOnScrollListener(listener)
        }
        mRcvAdapter?.addFooterView(footerView)
        if (headerCount > 0) {
            for (i in headers?.indices!!) {
                mRcvAdapter?.addHeaderView(headers?.get(i))
            }
        }
    }


    private fun doLikeAction(view: View, position: Int, mDatas: List<TrendsListBean.Trend>) {
        if (mActivity?.let { DynamicIn.loginByOneKeyLogin(it,true) } == true) {
            if (!isDoLikeAction) {
                isDoLikeAction = true
                mPresenter?.doLikeAction(
                    view,
                    position,
                    Integer.valueOf(mDatas[position].id),
                    mDatas
                )
            }
        }
    }

    private fun fetchUserPersonalTrend() {
        LogUtil.i("TAG get param: tab: $tab page: $page topicId: $topic_id lastId: $last_id")
        if (!isTrendsListLoading) {
            isTrendsListLoading = true
            mPresenter?.fetchUserTrendsList(userid, page, tab)
        }
    }

    private fun fetchTrendsList() {
        if (!isTrendsListLoading) {
            isTrendsListLoading = true
            mPresenter?.fetchPhpTrendsInfo(tab, page, topic_id, last_id)
        }
    }

    private fun fetchRecommendTopicList() {
        if (tab == 1 && !isTopicLoading && trendType == TREND_TYPE_DEFAULT) {
            isTopicLoading = true
            mPresenter?.fetchTopicListInfo(2, 0)
        }
    }

    override fun onResume() {
        super.onResume()
        if ("success" == SharedPreferencesEditor.getString("trend_state")) {
            onRefresh()
        }
    }

    override fun onVisible() {
        super.onVisible()
        LogUtil.d("onVisible")
        if (isNeedLogin && !DynamicIn.isLogin()) {
            isPrepared = true
            return
        } else if (isNeedLogin && DynamicIn.isLogin()) {
            lazyLoad()
        }

    }

    private fun showLoadSuccessView() {
        if (trend_list_no_datas_rel?.visibility != View.GONE) {
            trend_list_no_datas_rel?.visibility = View.GONE
        }

    }

    private fun showErrorView() {
        if (page == 1) {
            trend_list_no_datas_rel?.visibility = View.VISIBLE
        } else {
            trend_list_no_datas_rel?.visibility = View.GONE
        }
    }

    override fun onRefresh() {
        LogUtil.d("TAG onRefresh")
        isRefresh = true
        Handler().postDelayed({
            page = 1
            last_id = 0
            trends_lastr_swl?.isRefreshing = true
            switchDataToFetch()
        }, 200)
    }

    private fun switchDataToFetch() {
        if (isNeedLogin && !DynamicIn.isLogin()) {
            showToast("请登录后刷新重试！")
            showErrorView()
            return
        }
        SharedPreferencesEditor.putString("trend_state", "")
        if (!TextUtils.isEmpty(trendType) && (trendType == TREND_TYPE_DEFAULT || trendType == TREND_TYPE_TOPIC_TREND)) {
            if (page == 1 && trendType == TREND_TYPE_DEFAULT) {
                fetchRecommendTopicList()
            }
            fetchTrendsList()
        } else if (!TextUtils.isEmpty(trendType)) {
            fetchUserPersonalTrend()
        }
    }

    fun initClick() {
        recommend_trend_add_iv.setOnClickListener {
            if (DynamicIn.loginByOneKeyLogin(requireContext(),true)) {
                val intent = Intent(activity?.applicationContext, PublishTrendActivity::class.java)
                val bundle = Bundle()
                bundle.putString(DynamicConstants.PUBLISH_TYPE, "default_publish")
                intent.putExtra("bundle", bundle)
                startActivity(intent)
            }
        }

        image_scroll_top.setOnClickListener {
            scrollToTop()
        }
    }

    fun scrollToTop() {
        if (firstVisibleItem > 10) {
            trends_rcv?.scrollToPosition(10)
            trends_rcv?.smoothScrollToPosition(0)
        } else {
            trends_rcv?.smoothScrollToPosition(0)
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        LogUtil.d("fragmentlist onDestroy() $tab")
        if (mPresenter != null) {
            mPresenter?.onDestroy()
        }
        if (image_scroll_top != null) {
            image_scroll_top?.animate()?.cancel()
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        LogUtil.d("requestCode $requestCode resultcode: $resultCode")
        if (data == null) {
            return
        }
        if (requestCode == REQUEST_CODE && resultCode == TrendsDetailActivity.RESULT_CODE) {
            val position = data.getIntExtra("position", 0)
            val likestate = data.getIntExtra("like_state", 0)
            val commentCount = data.getIntExtra("comment_count", 0)
            if (data.getStringArrayListExtra("comment_datas") != null) {
                LogUtil.d("comment data is not null")
                if (data.getStringArrayListExtra("comment_datas").size > 0) {
                    val comments = ArrayList<TrendsListBean.Trend.Comments>()
                    for (commentStr in data.getStringArrayListExtra("comment_datas")) {
                        val str = commentStr.split("/".toRegex()).dropLastWhile { it.isEmpty() }
                            .toTypedArray()
                        val comment = TrendsListBean.Trend.Comments()
                        LogUtil.d("str length: " + str.size)
                        comment.name = str[0]
                        comment.content = str[1]
                        comment.to_name =
                            if (str.size == 3) if (!TextUtils.isEmpty(str[2])) str[2] else "" else ""
                        comments.add(comment)
                    }
                    mRcvAdapter?.datas?.get(position - headerCount)?.comments = comments
                    mRcvAdapter?.datas?.get(position - headerCount)?.commentsCount = commentCount
                    mRcvAdapter?.notifyItemChanged(position)
                } else {
                    mRcvAdapter?.datas?.get(position - headerCount)?.comments?.clear()
                    mRcvAdapter?.datas?.get(position - headerCount)?.commentsCount = commentCount
                    mRcvAdapter?.notifyItemChanged(position)
                }
            }
            LogUtil.d("resultcode: $resultCode position: $position likestate: $likestate")
            if (likestate != 0) {
                mRcvAdapter?.datas?.get(position - headerCount)?.zanCount =
                    mRcvAdapter?.datas?.get(position - headerCount)?.zanCount?:0 + (mRcvAdapter?.datas?.get(position - headerCount)?.isZan?:0 - likestate)
                mRcvAdapter?.datas?.get(position - headerCount)?.isZan = likestate
                mRcvAdapter?.notifyItemChanged(position)
            }
        }
    }

    override fun showLoadingDialog(isNeedShowLoading: Boolean) {

    }

    override fun hideLoadingView() {}

    override fun hideRefreshProgress() {
        if (trends_lastr_swl?.isRefreshing == true && !isTopicLoading) {
            trends_lastr_swl?.isRefreshing = false
        }
    }

    override fun showBanner(banner: List<TrendsListBean.Banner>) {

    }

    override fun showTrendsListView(data: List<TrendsListBean.Trend>?) {
        isTrendsListLoading = false
        if (data == null || data.size < 0) {
            return
        }
        if (page == 1) {
            trendsDatas?.clear()
        }
        LogUtil.i("get datas  $data")
        showLoadSuccessView()
        if (data.size >= eachPageDataNum) {
            trendsDatas?.addAll(data)
            mRcvAdapter?.setDatas(trendsDatas, FOOTRE_STATE_LOAD_MORE)
            if (page == 1) {
                mRcvAdapter?.notifyDataSetChanged()
                return
            }
            mRcvAdapter?.notifyItemRangeInserted(
                trendsDatas?.size?:0 + headerCount - data.size,
                data.size
            )
        } else {
            LogUtil.i("get datas no more data$data")
            trendsDatas?.addAll(data)
            if (trendsDatas == null || trendsDatas?.size == 0) {
                mRcvAdapter?.setDatas(trendsDatas, FOOTRE_STATE_INIT)
                if (page == 1) {
                    mRcvAdapter?.notifyDataSetChanged()
                }
                trend_list_no_datas_rel?.visibility = View.VISIBLE
                return
            }
            mRcvAdapter?.setDatas(trendsDatas, FOOTER_STATE_NO_DATA)
            if (page == 1) {
                mRcvAdapter?.notifyDataSetChanged()
                return
            }
            mRcvAdapter?.notifyItemRangeInserted(
                trendsDatas?.size?:0 + headerCount - data.size,
                data.size
            )
        }
    }

    override fun showTrendsErrorView(e: Throwable) {
        isTrendsListLoading = false
        showErrorView()
    }

    //推荐话题列表信息
    override fun showRecommendTopicView(topicListDatas: TopicListDataBean) {
        isTopicLoading = false
        if (topicListDatas.list != null && topicListDatas.list.size > 0) {
            recommendTopicDatas = topicListDatas.list
            mRecommendTopicListAdapter?.setDatas(recommendTopicDatas)
            mRecommendTopicListAdapter?.notifyDataSetChanged()
        }
    }

    override fun showRecommendTopicErrorView(e: Throwable) {
        isTopicLoading = false
        LogUtil.i("Recommend Topic Fetch Failed: $e")
    }

    //未赞
    override fun showDisLikeView(
        view: View,
        position: Int,
        zanResultBaseBean: ZanResult,
        mDatas: List<TrendsListBean.Trend>
    ) {
        mDatas[position].isZan = 2
        mDatas[position].zanCount -= 1
        (view.findViewById<View>(R.id.item_trend_zan_iv) as ImageView).setImageResource(R.drawable.dynamic_newsfeed_like)
        (view.findViewById<View>(R.id.text_zan_num) as TextView).text =
            mDatas[position].zanCount.toString() + ""
        startLikeViewAnimation(view.findViewById(R.id.item_trend_zan_iv), position)
        isDoLikeAction = false
    }

    //赞
    override fun showLikedView(
        view: View,
        position: Int,
        zanResultBaseBean: ZanResult,
        mDatas: List<TrendsListBean.Trend>
    ) {
        BuryPointUtils.getInstance().createMap()
            .put("warmth_dynamic_name", mDatas[position].title)
            .put("warmth_dynamic_ID", mDatas[position].id)
            .put("warmth_category", mDatas[position].topicTitle)
            .put("warmth_way", "动态流页面")
            .burryPoint("Warmth_dynamic")
        mDatas[position].isZan = 1
        mDatas[position].zanCount += 1
        (view.findViewById<View>(R.id.item_trend_zan_iv) as ImageView).setImageResource(R.drawable.dynamic_newsfeed_like_sel)
        (view.findViewById<View>(R.id.text_zan_num) as TextView).text =
            mDatas[position].zanCount.toString() + ""
        startLikeViewAnimation(view.findViewById(R.id.item_trend_zan_iv), position)
        isDoLikeAction = false
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
    }

    override fun showTopTrendsView(extDatas: List<TrendsListBean.ExtData>?) {
        if (extDatas != null && extDatas.size > 0) {      //置顶信息
            mRecommendTopRcv?.visibility = View.VISIBLE
            mRecommendTopAdapter?.setExtData(extDatas)
            mRecommendTopAdapter?.notifyDataSetChanged()
        }
    }

    override fun showToast(msg: String) {
        ToastUtil.toastShort(msg)
    }

    override fun showLikeActionFailed() {
        isDoLikeAction = false
    }


    private fun startLikeViewAnimation(view: View, position: Int) {
        val animator1 = ObjectAnimator.ofFloat(view, "scaleX", 1f, 1.5f, 1f)
        val animator2 = ObjectAnimator.ofFloat(view, "scaleY", 1f, 1.5f, 1f)
        val set = AnimatorSet()
        set.duration = 500
        set.playTogether(animator1, animator2)
        set.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationEnd(animation: Animator) {}
        })
        set.start()

    }

    companion object {
        val KEY_TAB = "tab"
        val KEY_TOPIC_ID = "topic_id"
        val KEY_TREND_TYPE = "trend_type"
        val KEY_USER_ID = "trend_user_id"
        val TREND_TYPE_USER_TREND = "userTrend"
        val TREND_TYPE_DEFAULT = "default"   //动态列表
        val TREND_TYPE_MY_TREND = "myTrend" //个人列表
        val TREND_TYPE_TOPIC_TREND = "topicTrend"   //动态列表

        fun newInstance(
            tabType: Int,
            topicId: Int,
            trendType: String,
            trendUserid: String
        ): TrendsListFragment {
            val fragment = TrendsListFragment()
            val bundle = Bundle()
            bundle.putInt(KEY_TAB, tabType)
            bundle.putInt(KEY_TOPIC_ID, topicId)
            bundle.putString(KEY_TREND_TYPE, trendType)
            bundle.putString(KEY_USER_ID, trendUserid)
            fragment.arguments = bundle
            return fragment
        }
    }

}
