package com.yidianling.dynamic.trendList;


import android.view.View;

import com.yidianling.common.tools.LogUtil;
import com.yidianling.dynamic.model.TopicListDataBean;
import com.yidianling.dynamic.model.TrendsListBean;
import com.yidianling.dynamic.model.ZanResult;
import com.ydl.ydlcommon.data.http.BaseResponse;

import java.util.List;


/**
 * Created by Jim on 2017/9/25 0025.
 */

public class TrendsListPresenter implements ITrendsListPresenter, ITrendsListPresenter.onDataLoadCallBackListener {

    private ITrendsListView mTrendsListView;
    private TrendsListInteractor mInteractor;

    public TrendsListPresenter(ITrendsListView trendsListView) {
        mTrendsListView = trendsListView;
        mInteractor = new TrendsListInteractor();
        mInteractor.setCallBack(this);
    }

    @Override
    public void localData(int tab) {
        mInteractor.localData(tab);
    }

    @Override
    public void fetchPhpTrendsInfo(int tab, int page, int topicId, int lastId) {
        mInteractor.fetchPhpTrendsInfo(tab, page, topicId, lastId);
    }

    @Override
    public void fetchTrendsInfo(int tab, int page, int topicId, int lastId) {
        mInteractor.fetchTrendsInfo(tab, page, topicId, lastId);
    }

    @Override
    public void fetchTopicListInfo(int cat, int my) {
        if (mInteractor != null) {
            mInteractor.fetchTopicListInfo(cat, my);
        }
    }

    /**
     * 点赞
     */
    @Override
    public void doLikeAction(final View view, final int position, int trendId, final List<TrendsListBean.Trend> mDatas) {
        mInteractor.doLikeAction(view, position, trendId, mDatas);
    }

    @Override
    public void fetchUserTrendsList(String uid, int page, int tab) {
        mInteractor.fetchUserTrendsList(uid, page, tab);
    }

/*----结果回调---------*/

    @Override
    public void onTrendsListFetched(TrendsListBean trendsListBean) {
        LogUtil.d("onTrendsListFetched");
        if (mTrendsListView != null) {
            mTrendsListView.hideRefreshProgress();
            mTrendsListView.hideLoadingView();
            if (null != trendsListBean) {
                mTrendsListView.showTrendsListView(trendsListBean.data);
                mTrendsListView.showTopTrendsView(trendsListBean.ext_data);
                mTrendsListView.showBanner(trendsListBean.bannerResps);
            } else {
                mTrendsListView.showToast("加载失败：" + trendsListBean.msg);
            }
        }
    }

    @Override
    public void onTrendsListFetchFialed(Throwable e) {
        if (mTrendsListView != null) {
            LogUtil.i("onTrendsListFetchFialed: " + e);
            mTrendsListView.hideRefreshProgress();
            mTrendsListView.hideLoadingView();
            mTrendsListView.showTrendsErrorView(e);
            mTrendsListView.showToast("获取动态信息失败!");
        }
    }

    @Override
    public void onRecommendTopicFetched(BaseResponse<TopicListDataBean> topicListDatas) {
        if (mTrendsListView != null) {
            mTrendsListView.hideLoadingView();
            if (topicListDatas.code == 0) {
                mTrendsListView.showRecommendTopicView(topicListDatas.data);
            } else {
                mTrendsListView.showToast("话题信息获取失败： " + topicListDatas.msg);
            }
            mTrendsListView.hideRefreshProgress();
        }
    }

    @Override
    public void onRecommendTopicFetchFailed(Throwable e) {
        if (mTrendsListView != null) {
            LogUtil.i("onRecommendTopicFetchFailed: " + e);
            mTrendsListView.hideLoadingView();
            mTrendsListView.showRecommendTopicErrorView(e);
            mTrendsListView.hideRefreshProgress();
            mTrendsListView.showToast("话题信息获取失败!");
        }
    }

    @Override
    public void onLikeActionFetchedResult(View view, int position, BaseResponse<ZanResult> zanResultBaseBean, List<TrendsListBean.Trend> mDatas) {
        if (mTrendsListView != null) {
            if (zanResultBaseBean.code == 0) {
                switch (zanResultBaseBean.data.status) {
                    case 1:     //已赞
                        mTrendsListView.showLikedView(view, position, zanResultBaseBean.data, mDatas);
                        break;
                    case 2: //未赞
                        mTrendsListView.showDisLikeView(view, position, zanResultBaseBean.data, mDatas);
                        break;
                }
            } else {
                mTrendsListView.showToast("点赞失败： " + zanResultBaseBean.msg);
                mTrendsListView.showLikeActionFailed();
            }
        }
    }

    @Override
    public void onLikeActionFailed(Throwable throwable) {
        LogUtil.d("like error: " + throwable.toString());
        if (mTrendsListView != null) {
            mTrendsListView.showLikeActionFailed();
        }
    }

    @Override
    public void onUserTrendFetched(BaseResponse<List<TrendsListBean.Trend>> response) {
        if (mTrendsListView != null) {
            mTrendsListView.hideRefreshProgress();
            mTrendsListView.hideLoadingView();
            if (response.code == 0) {
                mTrendsListView.showTrendsListView(response.data);
            } else {
                mTrendsListView.showToast("获取列表信息失败： " + response.msg);
            }
        }
    }

    @Override
    public void onUserTrendFetchFailed(Throwable e) {
        if (mTrendsListView != null) {
            LogUtil.i("onUserTrendFetchFailed: " + e);
            mTrendsListView.hideRefreshProgress();
            mTrendsListView.hideLoadingView();
            mTrendsListView.showTrendsErrorView(e);
            mTrendsListView.showToast("获取列表信息失败!");
        }
    }

    @Override
    public void onDestroy() {
        mInteractor.onDestroy();
    }
}
