package com.yidianling.dynamic.trendsDetail;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.google.gson.internal.LinkedTreeMap;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_router.manager.YDLRouterManager;
import com.ydl.ydlcommon.actions.share.ShareActionCallBack;
import com.ydl.ydlcommon.actions.share.ShareMoreBean;
import com.ydl.ydlcommon.actions.share.ShareUtils;
import com.ydl.ydlcommon.base.BaseMvpActivity;
import com.ydl.ydlcommon.base.config.YDLConstants;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.http.BaseResponse;
import com.ydl.ydlcommon.router.IYDLRouterConstant;
import com.ydl.ydlcommon.ui.LogoLoadingView;
import com.ydl.ydlcommon.utils.BuryPointUtils;
import com.ydl.ydlcommon.utils.MoonUtil;
import com.ydl.ydlcommon.utils.ScreenUtil;
import com.ydl.ydlcommon.utils.SharedPreferencesEditor;
import com.ydl.ydlcommon.utils.StringUtils;
import com.ydl.ydlcommon.view.BaseViewHolder;
import com.ydl.ydlcommon.view.dialog.CommonDialog;
import com.ydl.ydlcommon.view.dialog.ListDialog;
import com.ydl.ydlcommon.view.dialog.NormalDialog;
import com.ydl.ydlcommon.view.dialog.YDLShareDialog;
import com.ydl.ydlcommon.view.widgets.MyScrollview;
import com.ydl.ydlcommon.view.widgets.RecyclerViewForScrollView;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.dynamic.bean.DynamicConstants;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.common.browsePictures.BrowsePicturesActivity2;
import com.yidianling.dynamic.common.emoji.EmoticonPickerView;
import com.yidianling.dynamic.common.emoji.IEmoticonSelectedListener;
import com.yidianling.dynamic.event.dynamicFocusEvent;
import com.yidianling.dynamic.members.MembersActivity;
import com.yidianling.dynamic.model.CommentBean;
import com.yidianling.dynamic.model.Reply;
import com.yidianling.dynamic.model.TrendsDetailInfoBean;
import com.yidianling.dynamic.router.DynamicIn;
import com.yidianling.dynamic.thank.ThankActivity;
import com.yidianling.dynamic.topic.topicDetail.TopicDetailActivity;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

import de.greenrobot.event.EventBus;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

import static android.view.View.GONE;
import static android.view.View.VISIBLE;


/**
 * Created by Jim on 2017/10/28 0028.
 * 动态详情
 */
@Route(path = "/trends/detail")
public class TrendsDetailActivity extends BaseMvpActivity<ITrendsDetailView, ITrendsDetailPresenterImpl> implements ITrendsDetailView, IEmoticonSelectedListener, SwipeRefreshLayout.OnRefreshListener, MyScrollview.ScrollViewListener {

    private TextView tvTrendInfoTitle;

    private TextView tvUserName;

    private ImageView ivUserHead;

    private ImageView ivSex;

    private TextView tvTime;

    private TextView tvFrom;

    private TextView tvGuanzhu;

    private TextView tvContent;

    private RecyclerView rcvZanListImag;

    private RelativeLayout relTrendAd;

    private ImageView ivAd;

    private TextView tvAdTitle;

    private TextView tvHuati;

    private TextView tvReadNum;

    private TextView tvZanNum;

    private TextView tvCommentNum;

    private RecyclerViewForScrollView rcvCommentsList;

    private LinearLayout linNullTip;

    private LinearLayout linContent;

    private SwipeRefreshLayout swl;

    private RelativeLayout relNotExist;

    private ImageView ivZanListMore;

    private RecyclerViewForScrollView rcvContentImags;

    private LinearLayout linZanList;

    private LinearLayout linComment;

    private ImageView ivLike;

    private EditText edCommentContent;

    private LinearLayout linCommentSend;

    private LinearLayout linBottomLikeShare;

    private EmoticonPickerView mEmoticonPickerView;

    private ImageView ivChooseEmoji;

    private MyScrollview myScrollView;

    private TextView tvShowAllComment;

    private FrameLayout flAds;

    private ViewPager vpAds;

    private CircleIndicator circleIndicator;

    private TextView tvNoComments;

    private ImageView iv_fm;

    private LinearLayout llHasLoad;

    private LogoLoadingView vLoading;

    private boolean isFirstLoad = true;

    public static final int RESULT_CODE = 10001;
    //键
    public static final String KEY_TREND_ID = "trend_id";
    public static final String KEY_COMMENT_COUNT = "comment_count";
    public static final String KEY_IS_COMMENT = "is_comment";
    public static final String KEY_POSITION = "position";
    public static final String KEY_IS_SPLASH = "is_splash";
    public static final String KEY_IS_SCROLL_TO_ZAN = "is_scroll_to_zan";
    public static final String KEY_IS_SCROLL_TO_COMMENT = "is_scroll_to_comment";
    public static final String KEY_LAST_ID = "last_id";
    public static final String KEY_TYPE = "type";
    private static final String ROUTER_PARAMS = "routerParam";
    public static final int SCROLL_TO_COMMENT = 1;
    public static final int SCROLL_TO_ZAN = 2;
    public static final int INIT_COMMENT_FLAG = 3;


    private final int zan_max_num = 7;
    private int commentCount;
    private int trendId; //动态id
    private int page;//评论列表页码
    private int lastId;//评论列表上一条id
    private int direction;//评论列表加载方向，1上加载，2下加载
    private boolean hasMore;//是否可以继续加载评论,服务端数据返回不准确所以加这个标志
    private int mPosition; //item位置
    private boolean isComment; //评论框是否去的焦点
    private int likeState; //用于返回当前页面的点赞状态
    private boolean isRefresh;
    private boolean isFromSplash;
    private boolean isScrollToZan;
    private boolean isScrollToComment;      //是否需要滚动到评论位置
    private int replierType; //回复评论类型
    private TrendsDetailInfoBean.TrendBody mTrendBody;
    private List<TrendsDetailInfoBean.ZanImg> zanMembers;
    private List<CommentBean> comments;
    private List<TrendsDetailInfoBean.IMage> contentImags;
    private CommonAdapter<TrendsDetailInfoBean.ZanImg> zanImgListAdapter;
    private CommonAdapter<CommentBean> commentListAdapter;
    private CommonAdapter<TrendsDetailInfoBean.IMage> imagsContentAdapter;
    private MyHandler uiHandler;
    private boolean isShowEmojiView;
    private boolean isTrendsBodyLoadError = false;
    private boolean isKeyboardShowed = true; // 是否显示键盘
    private boolean isCommentDataChanged = false;

    List<String> reportReasonsId;//举报内容id
    List<String> reportReasons;//举报内容列表

    //记录当前回复的是帖子还是评论
    private int type = 1;//业务类型：1回复动态，2盖楼
    private int id;//当前要回复的id
    private String toContent;//当前要回复的动态
    private String toUsername;//当前要回复的用户名
    private TrendsDetailActivity.ItemLikeActionCallBack mItemLikeCallBack;
    private ArrayList<String> returnCommentsData; //当在该页面执行评论操作后的返回给上一个Activity的评论变化数据

    private long stopTime = 0;
    private boolean isSendComment = false;
    private Disposable subscribe;
    private Runnable showEmojiRunnable;
    private Runnable showTextRunnable;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true, true);
    }

    public static Intent newIntent(Activity activity, int trendId, boolean isScrollToZan) {
        Intent intent = new Intent(activity, TrendsDetailActivity.class);
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_TREND_ID, trendId);
        bundle.putBoolean(KEY_IS_SCROLL_TO_ZAN, isScrollToZan);
        intent.putExtra(YDLConstants.BUNDLE, bundle);
        return intent;
    }

    public static Intent newIntent(Activity activity, int trendId, boolean isScrollToZan, int lastId) {
        Intent intent = new Intent(activity, TrendsDetailActivity.class);
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_TREND_ID, trendId);
        bundle.putBoolean(KEY_IS_SCROLL_TO_ZAN, isScrollToZan);
        bundle.putInt(KEY_LAST_ID, lastId);
        intent.putExtra(YDLConstants.BUNDLE, bundle);
        return intent;
    }

    public static Intent newIntent(Activity activity, int trendId) {
        Intent intent = new Intent(activity, TrendsDetailActivity.class);
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_TREND_ID, trendId);
        intent.putExtra(YDLConstants.BUNDLE, bundle);
        return intent;
    }

    public static void start(Activity activity, int trendId, int key_type, int id, String replyHint, boolean key_is_comment) {
        Intent intent = new Intent(activity, TrendsDetailActivity.class);
        Bundle bundle = new Bundle();

        bundle.putInt(KEY_TREND_ID, trendId);
        bundle.putInt(KEY_TYPE, key_type);
        bundle.putInt("id", id);
        bundle.putString("replyHint", replyHint);
        bundle.putBoolean(KEY_IS_COMMENT, key_is_comment);

        intent.putExtra("bundle", bundle);
        activity.startActivity(intent);
    }

    public static void start(Context activity, int trendId, boolean isSplash, boolean isComment, boolean isScrollToZan, boolean isScrollToComment, int lastId) {
        Intent intent = new Intent(activity, TrendsDetailActivity.class);
        Bundle bundle = new Bundle();

        bundle.putInt(KEY_TREND_ID, trendId);
        bundle.putBoolean(KEY_IS_SPLASH, isSplash);
        bundle.putBoolean(KEY_IS_COMMENT, isComment);
        bundle.putBoolean(KEY_IS_SCROLL_TO_ZAN, isScrollToZan);
        bundle.putBoolean(KEY_IS_SCROLL_TO_COMMENT, isScrollToComment);
        bundle.putInt(KEY_LAST_ID, lastId);

        intent.putExtra("bundle", bundle);
        if (activity instanceof Activity) {
        } else {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        activity.startActivity(intent);
    }

    public static void startForResult(Fragment fragment, int trendId, int commentCount, boolean isComment, int position, int requestCode) {
        Intent intent = new Intent(fragment.getActivity(), TrendsDetailActivity.class);
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_TREND_ID, trendId);
        bundle.putInt(KEY_COMMENT_COUNT, commentCount);
        bundle.putBoolean(KEY_IS_COMMENT, isComment);
        bundle.putInt(KEY_POSITION, position);
        intent.putExtra("bundle", bundle);
        fragment.startActivityForResult(intent, requestCode);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EventBus.getDefault().register(this);
        setContentView(R.layout.dynamic_activity_trend_details);
        bindView();
        initDatas();
        initViews();
        onRefresh();
        if (isComment) {
            reply("", 1, trendId, "", 0);
        }

        initNetLossView();
    }

    private void initNetLossView() {
        vLoading.setListener(new LogoLoadingView.LogoLoadingListener() {
            @Override
            public void onDataResetClick() {
                vLoading.setViewType(LogoLoadingView.TYPE_LOADING, null);
                onRefresh();
            }

            @Override
            public void onBackClick() {
                finish();
            }
        });
    }

    /**
     * 获取路由传递的参数
     */
    private void getParam() {
        if (null == getIntent() || !getIntent().hasExtra(ROUTER_PARAMS)) {
            return;
        }
        //路由传递的入参
        String json = getIntent().getStringExtra(ROUTER_PARAMS);
        try {
            JSONObject jsonObject = new JSONObject(json);
            //详情页ID
            trendId = jsonObject.getInt(IYDLRouterConstant.EXTRA_ID);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void showLoadingView(String message) {
        if (!swl.isRefreshing()) {
            dismissProgressDialog();
            if (isFirstLoad) {
                vLoading.setViewType(LogoLoadingView.TYPE_LOADING, null);
            } else {
                showProgressDialog(message);
            }
        }
    }

    @Override
    public void hideRefreshProgress() {
        if (swl.isRefreshing()) {
            swl.setRefreshing(false);
        }
    }

    @Override
    public void hideLoadingView() {
        dismissProgressDialog();

        vLoading.setVisibility(View.GONE);
        llHasLoad.setVisibility(View.VISIBLE);
    }

    @Override
    public void showTrendsBodyContent(TrendsDetailInfoBean.TrendBody trendBody) {
        isTrendsBodyLoadError = false;
        mTrendBody = trendBody;
        if (mTrendBody != null) {
            commentCount = mTrendBody.replyCounter;
            fillContent();
        }
    }

    private List<TrendsDetailInfoBean.Ad> mAdList;

    @Override
    public void showAds(List<TrendsDetailInfoBean.Ad> adList) {
        if (adList.size() > 0) {
            if (adList.size() > 4) {
                mAdList = adList.subList(0, 4);
            } else {
                mAdList = adList;
            }
            LogUtil.d("ad content: " + adList.toString());
            flAds.setVisibility(View.VISIBLE);
            AdViewPagerAdapter adapter = new AdViewPagerAdapter(this, mAdList);
            vpAds.setAdapter(adapter);
            circleIndicator.setViewPager(vpAds);
            if (mAdList.size() <= 1) {
                circleIndicator.setVisibility(View.INVISIBLE);
            }
            resetAdBannerTimer();
        }
    }

    @Override
    public void showSilencedDialog(String tips, String url) {
        CommonDialog.create(this)
                .setMessage(tips)
                .setLeftOnclick(TrendsDetailActivity.this.getString(R.string.dynamic_details), new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        String realUrl = TextUtils.isEmpty(url) ? DynamicConstants.HELP_URL : url;
                        H5Params params = new H5Params(realUrl, "");
                        NewH5Activity.start(TrendsDetailActivity.this, params);
                    }
                })
                .setRightClick(TrendsDetailActivity.this.getString(R.string.dynamic_approval), null)
                .show();
    }

    private void resetAdBannerTimer() {
        if (subscribe != null) {
            subscribe.dispose();
        }
        subscribe = Observable.interval(4000, TimeUnit.MILLISECONDS)
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(aLong -> vpAds.setCurrentItem(getNextItem(), true), Throwable::printStackTrace);
    }

    private int getNextItem() {
        return (vpAds.getCurrentItem() + 1) % mAdList.size();
    }

    @Override
    public void showTrendsNotExsitView() {
        isTrendsBodyLoadError = true;
        linContent.setVisibility(View.GONE);
        linComment.setVisibility(GONE);
        relNotExist.setVisibility(View.VISIBLE);
    }

    @Override
    public void showTrendsLoadErrorView() {
        isTrendsBodyLoadError = true;

        //如果是第一次加载且加载失败的情况下，才会展示网络开小差
        if (isFirstLoad) {
            linContent.setVisibility(View.GONE);
            linComment.setVisibility(GONE);
            llHasLoad.setVisibility(View.GONE);
            vLoading.setVisibility(View.VISIBLE);
            vLoading.setViewType(LogoLoadingView.TYPE_NET_LOSS, "哎呦，网络开小差了");
        }
    }

    //显示点赞用户列表
    @Override
    public void showZanList(List<TrendsDetailInfoBean.ZanImg> zanImgList) {
        if (zanImgList != null && zanImgList.size() > 0) {
            zanImgListAdapter.setDatas(zanImgList);
            zanImgListAdapter.notifyDataSetChanged();
            linZanList.setVisibility(View.VISIBLE);
            ivZanListMore.setVisibility(View.VISIBLE);
        }
    }

    //显示评论数据
    @Override
    public void showCommentsList(List<CommentBean> commentsBean) {
        if (page == 1) {
            commentListAdapter.clearHeaderViews();
            commentListAdapter.getDatas().clear();
            commentListAdapter.notifyDataSetChanged();
        }
        if (commentsBean != null && commentsBean.size() > 0) {
            commentListAdapter.addDatas(commentsBean);
            hasMore = true;
        } else {
            hasMore = false;
            commentListAdapter.notifyItemChanged(commentListAdapter.getDatas().size() - 1);
        }
        isShowNoCommentView(false);
        if (isScrollToComment) {
            Runnable scrollToCommentRunnable = new MyRunnable(this, SCROLL_TO_COMMENT);
            uiHandler.postDelayed(scrollToCommentRunnable, 200);
        }
        if (isFirstLoad) {
            vLoading.setVisibility(View.GONE);
            llHasLoad.setVisibility(View.VISIBLE);
            isFirstLoad = false;
        }
    }

    private void scrollToComment() {
        myScrollView.smoothScrollTo(0, rcvCommentsList.getTop());
        isScrollToComment = false;
    }


    @Override
    public void showCommentsLoadError() {
        isShowNoCommentView(true);
        if (commentListAdapter.getDatas() != null && commentListAdapter.getDatas().size() > 0) {
            linNullTip.setVisibility(GONE);
        } else {
            linNullTip.setVisibility(VISIBLE);
            tvNoComments.setText(this.getString(R.string.dynamic_trend_comments_load_error));
        }
    }

    private void setZanBackground(boolean isSelect) {
        Drawable drawable = getResources().getDrawable(isSelect ? R.drawable.dynamic_icon_warm_sel : R.drawable.dynamic_icon_warm_nor);
        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());//这句一定要加
        tvZanNum.setCompoundDrawables(drawable, null, null, null);
    }

    //帖子已赞
    @Override
    public void showLikedView() {
        BuryPointUtils.getInstance().createMap()
                .put("warmth_dynamic_name", mTrendBody.title)
                .put("warmth_dynamic_ID", mTrendBody.id + "")
                .put("warmth_category", mTrendBody.topicTitle)
                .put("warmth_way", "动态详情页面")
                .burryPoint("Warmth_dynamic");
        int length = zanImgListAdapter.getDatas().size() > 7 ? 7 : zanImgListAdapter.getDatas().size();
        likeState = 1;
        ivLike.setImageResource(R.drawable.dynamic_newsfeed_like_sel);
        startAnimation(ivLike);
        LogUtil.d("uid: " + DynamicIn.INSTANCE.getUserInfo().getUid());
        if (!isZanListContainUser() && DynamicIn.INSTANCE.isLogin() && length < 7) {
            zanImgListAdapter.addData(0, new TrendsDetailInfoBean.ZanImg(DynamicIn.INSTANCE.getUserInfo().getHead(), Integer.valueOf(DynamicIn.INSTANCE.getUserInfo().getUid())));
        }
        mTrendBody.zanCount += 1;
        tvZanNum.setText(String.valueOf(mTrendBody.zanCount));
        setZanBackground(true);
        showZanList();
    }

    //帖子未赞
    @Override
    public void showUnLikeView() {
        LogUtil.d("showUnLikeView");
        int length = zanImgListAdapter.getDatas().size() > 7 ? 7 : zanImgListAdapter.getDatas().size();
        likeState = 2;
        ivLike.setImageResource(R.drawable.dynamic_newsfeed_like);
        startAnimation(ivLike);
        mTrendBody.zanCount -= 1;
        tvZanNum.setText(String.valueOf(mTrendBody.zanCount));
        setZanBackground(false);
        LogUtil.d("uid: " + DynamicIn.INSTANCE.getUserInfo().getUid());
        for (int i = 0; i < length; i++) {
            if (zanImgListAdapter.getDatas().get(i).uid == Integer.valueOf(DynamicIn.INSTANCE.getUserInfo().getUid())) {
                LogUtil.d("user head index: " + i + " data size: " + zanImgListAdapter.getDatas().size());
                zanImgListAdapter.removeData(i);
                break;
            }
        }
        if (zanImgListAdapter.getDatas().size() <= 0) {
            linZanList.setVisibility(View.GONE);
            ivZanListMore.setVisibility(View.GONE);
        }
    }

    //回复点赞
    @Override
    public void showCommentsItemLikeStatus(int status) {
        mItemLikeCallBack.callBack(status);
    }

    @Override
    public void showFousChangeView() {
        tvGuanzhu.setText("已关注");
        tvGuanzhu.setEnabled(false);
        new Timer().schedule(new TimerTask() {
            @Override
            public void run() {
                runOnUiThread(() -> tvGuanzhu.setVisibility(View.GONE));
            }
        }, 1000);

    }

    @Override
    public void showReportContentView(BaseResponse response, int answerId, String commentContent) {
        try {
            LinkedTreeMap<String, String> reportReasonsmaps =
                    (LinkedTreeMap<String, String>) response.data;
            if (reportReasonsmaps == null)
                return;
            reportReasonsId = new ArrayList<>();
            reportReasons = new ArrayList<>();
            for (Map.Entry<String, String> entry : reportReasonsmaps.entrySet()) {
                reportReasonsId.add(entry.getKey());
                reportReasons.add(entry.getValue());
            }
            showReportReason(1, answerId, commentContent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void refreshCommentListAfterComment(BaseResponse<Reply> replyBaseResponse, int type, String content, String replyContent, String toName) {
        page = 1;
        lastId = 0;
        fetchTrendsDetailsInfo();
        replyReset();
//        mTrendBody.reply_count += 1;
//        tvCommentNum.setText(mTrendBody.reply_count + "个评论");
//        isCommentDataChanged = true;
//        Long time = System.currentTimeMillis();
//        Date date = new Date(time);
//        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm", Locale.getDefault());
//        String time_str = "今天 " + sdf.format(date);
//        commentListAdapter.addData(0, new CommentBean(Integer.valueOf(replyBaseResponse.data.id), DynamicIn.INSTANCE.getUserInfo().getUid(),
//                DynamicIn.INSTANCE.getUserInfo().getNick_name(), content, DynamicIn.INSTANCE.getUserInfo().getHead(), mTrendBody.id, 0, 0, toName, toContent, time_str, DynamicIn.INSTANCE.getUserInfo().getGender(), DynamicIn.INSTANCE.getUserInfo().getUser_type(), 2));
//        isShowNoCommentView(false);
//        myScrollView.smoothScrollTo(0, rcvCommentsList.getTop());
    }

    //删除评论或者动态
    @Override
    public void showDeleteReplyOrTrendView(BaseResponse<Object> response, int type, int position) {
        LogUtil.d("delete position: " + position);
        if (type == 1) {    //移除评论
            isCommentDataChanged = true;
            mTrendBody.replyCounter -= 1;
            tvCommentNum.setText(mTrendBody.replyCounter + "个评论");
            commentListAdapter.removeData(position);
            isShowNoCommentView(false);
        } else if (type == 2) {     //移除动态
            SharedPreferencesEditor.putString("trend_state", "success");
            setResultForActivity();
            finish();
        }
    }


    @Override
    public void showToast(String msg) {
        ToastUtil.toastShort(this, msg);
    }


    public void isShowNoCommentView(boolean isDataLoadError) {
        if (commentListAdapter.getDatas() != null && commentListAdapter.getDatas().size() > 0) {
            linNullTip.setVisibility(GONE);
        } else {
            linNullTip.setVisibility(VISIBLE);
            tvNoComments.setText(isDataLoadError ? this.getString(R.string.dynamic_trend_comments_load_error) : this.getString(R.string.dynamic_trend_waitting_for_comment));
        }
    }

    @Override
    protected int layoutResId() {
        return 0;
    }

    @Override
    protected void initDataAndEvent() {

    }

    private void bindView() {
        tvTrendInfoTitle = findViewById(R.id.item_trend_info_title);
        tvUserName = findViewById(R.id.text_userName);
        ivUserHead = findViewById(R.id.item_recommend_trend_user_head_iv);
        ivSex = findViewById(R.id.img_sex);
        tvTime = findViewById(R.id.text_time);
        tvFrom = findViewById(R.id.item_recommend_from);
        tvGuanzhu = findViewById(R.id.text_guanzhu);
        tvContent = findViewById(R.id.text_content);
        rcvZanListImag = findViewById(R.id.recy_ico_list);
        relTrendAd = findViewById(R.id.item_recommend_trend_ad_rel);
        ivAd = findViewById(R.id.item_recommend_trend_ad_iv);
        tvAdTitle = findViewById(R.id.item_recommend_trend_ad_tv);
        tvHuati = findViewById(R.id.text_huati);
        tvReadNum = findViewById(R.id.item_recommend_trend_readed_tv);
        tvZanNum = findViewById(R.id.item_recommend_trend_zannum_tv);
        tvCommentNum = findViewById(R.id.text_talk_num);
        rcvCommentsList = findViewById(R.id.talk_recyView);
        linNullTip = findViewById(R.id.lin_nullTip);
        linContent = findViewById(R.id.lin_content);
        swl = findViewById(R.id.trend_detail_swl);
        relNotExist = findViewById(R.id.rela_nullTip);
        ivZanListMore = findViewById(R.id.img_more);
        rcvContentImags = findViewById(R.id.list_img);
        linZanList = findViewById(R.id.lin_zan_list1);
        linComment = findViewById(R.id.lin_comment);
        ivLike = findViewById(R.id.img_wennuan);
        edCommentContent = findViewById(R.id.edit_content);
        linCommentSend = findViewById(R.id.trend_disscuss_send_lin);
        linBottomLikeShare = findViewById(R.id.trend_disscuss_bottom_img_lin);
        mEmoticonPickerView = findViewById(R.id.emoticon_picker_view);
        ivChooseEmoji = findViewById(R.id.publish_emoji_iv);
        myScrollView = findViewById(R.id.myScrollView);
        tvShowAllComment = findViewById(R.id.text_show_all);
        flAds = findViewById(R.id.fl_ads);
        vpAds = findViewById(R.id.vp_ads);
        circleIndicator = findViewById(R.id.circle_indicator);
        tvNoComments = findViewById(R.id.tv_no_comments);
        iv_fm = findViewById(R.id.iv_fm);
        llHasLoad = findViewById(R.id.ll_has_load);
        vLoading = findViewById(R.id.v_loading);
        View mTrendDisscussSendTv = findViewById(R.id.trend_disscuss_send_tv);
        View mImageBack = findViewById(R.id.image_back);
        View mImageRight = findViewById(R.id.image_right);
        View mImgShare = findViewById(R.id.img_share);
        relTrendAd.setOnClickListener(v -> {
            doClick(v);
        });
        ivChooseEmoji.setOnClickListener(v -> {
            doClick(v);
        });
        mTrendDisscussSendTv.setOnClickListener(v -> {
            doClick(v);
        });
        mImageBack.setOnClickListener(v -> {
            doClick(v);
        });
        ivLike.setOnClickListener(v -> {
            doClick(v);
        });
        mImageRight.setOnClickListener(v -> {
            doClick(v);
        });
        mImgShare.setOnClickListener(v -> {
            doClick(v);
        });
        ivUserHead.setOnClickListener(v -> {
            doClick(v);
        });
        tvHuati.setOnClickListener(v -> {
            doClick(v);
        });
        tvGuanzhu.setOnClickListener(v -> {
            doClick(v);
        });
        linZanList.setOnClickListener(v -> {
            doClick(v);
        });
    }

    private interface ItemLikeActionCallBack {
        void callBack(int result);
    }


    private void browsePicAction(int position) {
        Intent intent = new Intent();
        intent.setClass(TrendsDetailActivity.this, BrowsePicturesActivity2.class);
        intent.putExtra("position", position);
        intent.putExtra("browse_type", "browse");
        Bundle bd = new Bundle();
        ArrayList<String> imgList = new ArrayList<String>();
        for (TrendsDetailInfoBean.IMage iMage : mTrendBody.bigAttach) {
            imgList.add(iMage.url);
        }
        intent.putStringArrayListExtra("allTrendImages", imgList);
        intent.putExtra("trend_id", mTrendBody.id);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        TrendsDetailActivity.this.startActivity(intent);
    }

    private void initViews() {
        if (isScrollToComment) {
            tvShowAllComment.setVisibility(VISIBLE);
            tvShowAllComment.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    lastId = 0;
                    page = 1;
                    tvShowAllComment.setVisibility(GONE);
                    isScrollToComment = false;
                    fetchTrendsDetailsInfo();
                }
            });
        }
        swl.setOnRefreshListener(this);
        swl.setColorSchemeResources(R.color.platform_main_theme);
        vpAds.getLayoutParams().height = ScreenUtil.getDisplayWidth() * 19 / 66;
        vpAds.requestLayout();
        vpAds.setOnTouchListener((v, event) -> {
            swl.setEnabled(false);
            switch (event.getAction()) {
                case MotionEvent.ACTION_UP:
                    swl.setEnabled(true);
                    break;
            }
            return false;
        });
        myScrollView.setScrollViewListener(this);
        initImageContentRcv();
        initZanListImagRcv();
        initCommentListRcv();
        initEditCommentView();
        LogUtil.d("trend id " + trendId);
    }

    private void initEditCommentView() {
        edCommentContent.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    linCommentSend.setVisibility(View.VISIBLE);
                    linBottomLikeShare.setVisibility(View.GONE);
                } else {
                    linCommentSend.setVisibility(View.GONE);
                    linBottomLikeShare.setVisibility(View.VISIBLE);
                    hideEmojiLayout();
                    hideInputMethod();
                    replyReset();
                }
            }
        });
        edCommentContent.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                hideEmojiLayout();
                ivChooseEmoji.setImageResource(R.drawable.dynamic_edict_ico_emoji);
                return false;
            }
        });
        edCommentContent.addTextChangedListener(new TextWatcher() {
            private int start;
            private int count;

            @Override
            public void onTextChanged(CharSequence arg0, int start, int before, int count) {
                this.start = start;
                this.count = count;
                String editable = edCommentContent.getText().toString();
                String str = StringUtils.StringFilter(editable.toString());
                if (!editable.equals(str)) {
                    edCommentContent.setText(str);
                    edCommentContent.setSelection(str.length()); //光标置后
                }

            }

            @Override
            public void beforeTextChanged(CharSequence arg0, int start, int count, int after) {
            }


            @Override
            public void afterTextChanged(Editable arg0) {
                edCommentContent.removeTextChangedListener(this);
                MoonUtil.replaceEmoticons(TrendsDetailActivity.this, arg0, start, count);
                int editEnd = edCommentContent.getSelectionEnd();
                edCommentContent.removeTextChangedListener(this);
                while (StringUtils.counterChars(arg0.toString()) > 5000 && editEnd > 0) {
                    arg0.delete(editEnd - 1, editEnd);
                    editEnd--;
                }
                edCommentContent.setSelection(editEnd);
                edCommentContent.addTextChangedListener(this);
            }

        });
    }

    private void initDatas() {
        page = 1;
        direction = 0;
        isRefresh = false;
        likeState = 0;
        replierType = 0;
        uiHandler = new MyHandler(this);
        contentImags = new ArrayList<>();
        zanMembers = new ArrayList<>();
        comments = new ArrayList<>();

        Bundle bundle = getIntent().getBundleExtra(YDLConstants.BUNDLE);
        if (null != bundle) {
            lastId = bundle.getInt(KEY_LAST_ID, 0);
            isFromSplash = bundle.getBoolean(KEY_IS_SPLASH, false);
            trendId = bundle.getInt(KEY_TREND_ID, 0);
            commentCount = bundle.getInt(KEY_COMMENT_COUNT, 0);
            mPosition = bundle.getInt(KEY_POSITION, 0);
            isComment = bundle.getBoolean(KEY_IS_COMMENT, false);
            isScrollToZan = bundle.getBoolean(KEY_IS_SCROLL_TO_ZAN, false);
            isScrollToComment = bundle.getBoolean(KEY_IS_SCROLL_TO_COMMENT, false);
            if ((id = bundle.getInt("id", 0)) == 0) {
                id = trendId;
            }
            type = bundle.getInt(KEY_TYPE, 1);
            toUsername = bundle.getString("replyHint");
        }
        getParam();
        showEmojiRunnable = new ShowEmojiRunnable(this, mEmoticonPickerView);
        showTextRunnable = new ShowTextRunnable(this, edCommentContent);
    }

    private void initCommentListRcv() {
        LinearLayoutManager linlayoutmanager2 = new LinearLayoutManager(this);
        rcvCommentsList.setLayoutManager(linlayoutmanager2);
        rcvCommentsList.getItemAnimator().setChangeDuration(0);
        commentListAdapter = new CommonAdapter<CommentBean>(this, R.layout.dynamic_item_talk_list, comments) {
            @Override
            public void convert(BaseViewHolder holder, int position, CommentBean data, int dataState) {
                if (lastId == data.getId() && isScrollToComment) {
                    holder.setBackgroundColor(R.id.lin_body, TrendsDetailActivity.this.getResources().getColor(R.color.dynamic_fffaec));
                } else {
                    holder.setBackgroundColor(R.id.lin_body, TrendsDetailActivity.this.getResources().getColor(R.color.dynamic_white));
                }
                holder.setHeadImageWithUrl(R.id.item_recommend_trend_user_head_iv, data.getHeader());       //头像
                holder.setText(R.id.text_userName, data.getName());         //用户名
                holder.setText(R.id.text_time, data.getTime_str()); //发布时间
                holder.setText(R.id.tv_ip, "IP属地: " + data.getIpProvince()); // IP属地
                holder.setImageResource(R.id.img_comment_sex, data.getGender() == 1 ? R.drawable.dynamic_male : R.drawable.dynamic_female);
                holder.setImageResource(R.id.img_comment_zan, data.getIs_zan() == 1 ? R.drawable.dynamic_reply_zan_sel : R.drawable.dynamic_reply_zan);
                showCommentItemContent(holder, data);
                //咨询师标志
                holder.setVisibility(R.id.iv_shang, data.getUser_type() == 2 ? VISIBLE : View.GONE) //赏
                        .setVisibility(R.id.text_zixunshi, data.getUser_type() == 2 ? VISIBLE : GONE)
                        .setVisibility(R.id.text_chat, data.getUser_type() == 2 ? VISIBLE : GONE)
                        .setVisibility(R.id.text_confide, data.getIsAvailable() == 1 && data.getIsOpenListen() == 1 ? VISIBLE : GONE)
                        .setOnClickListener(R.id.text_confide, v -> {
                            NewH5Activity.start(TrendsDetailActivity.this, new H5Params(data.getListenLinkUrl(), "开始倾诉"));
                        })
                        .setOnClickListener(R.id.text_chat, v -> {
                            if (!DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
                               return;
                            }else {
                                BuryPointUtils.getInstance().createMap()
                                        .put("expert_entrance", "动态详情")
                                        .put("expert_ID", data.getDoctor_id())
                                        .put("expert_name", data.getName() == null ? "" : data.getName())
                                        .burryPoint("Chat_click");
                                getPresenter().getExpert(TrendsDetailActivity.this, data.getUid());
                            }
                        })
                        .setOnClickListener(R.id.iv_shang, v -> {
                            if (!DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
                                return;
                            }
                            BuryPointUtils.getInstance().createMap()
                                    .put("reward_expert_ID", data.getDoctor_id())
                                    .put("reward_expert_name", data.getName())
                                    .put("reward_dynamic_name", mTrendBody.title)
                                    .put("reward_dynamic_ID", mTrendBody.id)
                                    .put("reward_dynamic_type", mTrendBody.topicTitle)
                                    .burryPoint("Reward");
                            Intent intent = new Intent(TrendsDetailActivity.this, ThankActivity.class);
                            intent.putExtra("answerId", data.getId());
                            startActivity(intent);
                        });
                if (position == commentListAdapter.getItemCount() - 1) {       //显示加载更多进度条
                    LogUtil.d("position: " + position + " data size: " + commentListAdapter.getItemCount());
                    holder.setVisibility(R.id.item_trend_load_more_tv, View.VISIBLE);
                    if (hasMore && isHasMore()) {
                        holder.setText(R.id.item_trend_load_more_tv, "点击加载更多");
                        holder.setOnClickListener(R.id.item_trend_load_more_tv, new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                if (hasMore && isHasMore()) {
                                    page++;
//                                    lastId = comments.get(comments.size() - 1).getId();
                                    lastId = commentListAdapter.getDatas().get(commentListAdapter.getDatas().size() - 1).getId();
//                                    fetchTrendsDetailsInfo();
//                                    getPresenter().fetchTrendsDetails(trendId);
                                    getPresenter().fetchCommentsDatas(page);
                                } else {
                                    holder.setClickable(R.id.item_trend_load_more_tv, false);
                                }
                            }
                        });
                    } else {
                        String hint = "<font color='#B6B6B6'>" + "没有更多了" + "</font>";
                        holder.setText(R.id.item_trend_load_more_tv, Html.fromHtml(hint));
                        holder.setClickable(R.id.item_trend_load_more_tv, false);
                    }
                } else {
                    holder.setVisibility(R.id.item_trend_load_more_tv, View.GONE);
                }
                holder.setOnClickListener(R.id.lin_body, v -> {
                    reply(data.getName(), 2, data.getId(), data.getContent(), data.getUser_type());
                });
                holder.setOnLongClickListener(R.id.lin_body, v -> {
                    showDialog(holder.getItemView(), position, data);
                    return true;
                });
                holder.setOnClickListener(R.id.img_comment_discuss, v -> {
                    reply(data.getName(), 2, data.getId(), data.getContent(), data.getUser_type());
                });
                holder.setOnClickListener(R.id.img_comment_zan, v -> {
                    BuryPointUtils.getInstance().createMap()
                            .put("appreciate_replier_ID", data.getUser_type() == 2 ? data.getDoctor_id() : data.getUid())
                            .put("appreciate_replier_name", data.getName())
                            .put("appreciate_replier_type", data.getUser_type())
                            .burryPoint("appreciate");
                    mItemLikeCallBack = new TrendsDetailActivity.ItemLikeActionCallBack() {
                        @Override
                        public void callBack(int result) {
                            switch (result) {
                                case 1:         //已赞
                                    holder.setImageResource(R.id.img_comment_zan, R.drawable.dynamic_reply_zan_sel);
                                    startAnimation(holder.getView(R.id.img_comment_zan));
                                    break;
                                case 2:         //未赞
                                    holder.setImageResource(R.id.img_comment_zan, R.drawable.dynamic_reply_zan);
                                    startAnimation(holder.getView(R.id.img_comment_zan));
                                    break;
                            }
                        }
                    };
                    doLikeAction(3, data.getId());
                });
                holder.setOnClickListener(R.id.item_trend_user_head_rel, v -> {
                    if (2 == data.getUser_type()) {//1用户2专家3助理
                        BuryPointUtils.getInstance().createMap()
                                .put("expert_entrance", "动态详情")
                                .put("expert_ID", data.getDoctor_id())
                                .put("expert_name", data.getName())
                                .burryPoint("Expert_particulars");
                        String url = DynamicIn.INSTANCE.getExpertHost() + data.getDoctor_id();
                        H5Params h5Params = new H5Params(url, null);
                        h5Params.setShareData(data.getShare_data());
                        LogUtil.d("share data: " + data.getShare_data());
                        NewH5Activity.start(TrendsDetailActivity.this, h5Params);
                    } else {
                        if (TextUtils.isEmpty(data.getUid()) || TextUtils.equals("0", data.getUid())) {
                            return;
                        }
                        Intent intent = new Intent(TrendsDetailActivity.this, MembersActivity.class);
                        Bundle bundle = new Bundle();
                        bundle.putString("user_id", data.getUid());
                        intent.putExtra("bundle", bundle);
                        startActivity(intent);
                    }
                });
            }

            private void showCommentItemContent(BaseViewHolder holder, CommentBean data) {
                boolean isToContentEmpty = TextUtils.isEmpty(data.getTo_content());
                holder.setVisibility(R.id.lin_reply, !isToContentEmpty ? VISIBLE : GONE);     //ToContent的布局
                if (!isToContentEmpty) {     //评论内容
                    holder.setVisibility(R.id.text_all, data.getTo_content().trim().length() > 30 ? VISIBLE : GONE);
                    MoonUtil.identifyFaceExpression(TrendsDetailActivity.this, holder.getView(R.id.text_comment_content), data.getContent(), ImageSpan.ALIGN_BOTTOM);
                    MoonUtil.SetItemDicussContent(TrendsDetailActivity.this, holder.getView(R.id.text_reply), data.getTo_content().trim().length() > 30 ? data.getTo_content().substring(0, 30) + "..." : data.getTo_content(), data.getTo_name(), "", ImageSpan.ALIGN_BOTTOM);
                    holder.setOnClickListener(R.id.text_all, v -> {
                        MoonUtil.SetItemDicussContent(TrendsDetailActivity.this, holder.getView(R.id.text_reply), data.getTo_content(), data.getTo_name(), "", ImageSpan.ALIGN_BOTTOM);
                        holder.setVisibility(R.id.text_all, GONE);
                    });
                    holder.setOnClickListener(R.id.text_reply, v -> {
                        reply(data.getTo_name(), 2, data.getId(), data.getContent(), data.getUser_type());
                    });
                } else {
                    MoonUtil.identifyFaceExpression(TrendsDetailActivity.this, holder.getView(R.id.text_comment_content), data.getContent(), ImageSpan.ALIGN_BOTTOM);
                }
            }
        };
        rcvCommentsList.getItemAnimator().setChangeDuration(0);
        rcvCommentsList.setAdapter(commentListAdapter);
    }

    private boolean isFirst = true;

    private void initImageContentRcv() {
        LinearLayoutManager linlayoutmanager1 = new LinearLayoutManager(this);
        rcvContentImags.setLayoutManager(linlayoutmanager1);
        imagsContentAdapter = new CommonAdapter<TrendsDetailInfoBean.IMage>(this, R.layout.dynamic_item_image, contentImags) {
            @Override
            public void convert(BaseViewHolder holder, int position, TrendsDetailInfoBean.IMage data, int dataState) {
                GlideApp.with(TrendsDetailActivity.this)
                        .load(data.url)
                        .fitCenter()
                        .into((ImageView) holder.getView(R.id.img_img));
                holder.setOnClickListener(R.id.img_img, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        browsePicAction(position);
                    }
                });
            }
        };
        rcvContentImags.setAdapter(imagsContentAdapter);
    }

    private void initZanListImagRcv() {
        LinearLayoutManager horizontallinManager = new LinearLayoutManager(TrendsDetailActivity.this);
        horizontallinManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        zanImgListAdapter = new CommonAdapter<TrendsDetailInfoBean.ZanImg>(this, R.layout.dynamic_item_circleimg, zanMembers) {
            @Override
            public void convert(BaseViewHolder holder, int position, TrendsDetailInfoBean.ZanImg data, int dataState) {
                if (position == zan_max_num) {
                    holder.setImageResource(R.id.img_ico, R.drawable.dynamic_newsfeed_zan_more);
                } else if (position > zan_max_num) {
                    //多余图片不展示
                } else {
                    holder.setHeadImageWithUrl(R.id.img_ico, data.head);
                }
                holder.setOnClickListener(R.id.img_ico, v -> {
                    H5Params h5Params = new H5Params(DynamicConstants.Companion.getTRENDS_ZAN_LIST_H5() + "/" + trendId, null);
                    NewH5Activity.start(TrendsDetailActivity.this, h5Params);
                });
            }
        };
        rcvZanListImag.setLayoutManager(horizontallinManager);
        rcvZanListImag.setAdapter(zanImgListAdapter);
    }


    private void doClick(View v) {
        if (v.getId() == R.id.trend_disscuss_send_tv) {
            LogUtil.d("click send comment");
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
                if (TextUtils.isEmpty(edCommentContent.getText().toString())) {
                    ToastUtil.toastShort("评论内容不能为空");
                    return;
                }
                sendComment(type, id, edCommentContent.getText().toString(), toContent, toUsername);
            }
        } else if (v.getId() == R.id.publish_emoji_iv) {
            //点击发送表情
            toggleEmojiLayout();
        } else if (v.getId() == R.id.image_right) {
            try {
                share();
            } catch (Exception e) {
                LogUtil.e("share error: " + e);
            }
        } else if (v.getId() == R.id.image_back) {
            if (isFromSplash) {
                DynamicIn.INSTANCE.mainIntent(this);
            }
            setResultForActivity();
            this.finish();
        } else if (v.getId() == R.id.img_wennuan) {
            doLikeAction(2, trendId);
        } else if (v.getId() == R.id.edit_content) {

        } else if (v.getId() == R.id.item_recommend_trend_user_head_iv) {
            if (TextUtils.isEmpty(mTrendBody.uid) || TextUtils.equals("0", mTrendBody.uid)) {
                return;
            }
            LogUtil.d("start memberActivity uid: " + mTrendBody.uid);
            Intent intent = new Intent();
            intent.setClass(this, MembersActivity.class);
            Bundle bundle = new Bundle();
            bundle.putString("user_id", mTrendBody.uid);
            intent.putExtra("bundle", bundle);
            startActivity(intent);
        } else if (v.getId() == R.id.text_huati) {
            gotoTopicPage();
        } else if (v.getId() == R.id.text_guanzhu) {
            getPresenter().focus(mTrendBody.uid);
        } else if (v.getId() == R.id.lin_zan_list1) {
            H5Params h5Params = new H5Params(DynamicConstants.Companion.getTRENDS_ZAN_LIST_H5() + "/" + trendId, null);
            NewH5Activity.start(TrendsDetailActivity.this, h5Params);
        } else if (v.getId() == R.id.item_recommend_trend_ad_rel) {//内容AD点击事件
            gotoAd();
        } else if (v.getId() == R.id.img_share) {
            share();
        }

    }

    private void sendComment(int type, int id, String content, String toContent, String toName) {
        if (mTrendBody == null) {
            return;
        }
        if (TextUtils.isEmpty(DynamicIn.INSTANCE.getUserInfo().getPhone())) {
            CommonDialog.create(this)
                    .setLeftOnclick("忍痛放弃", null)
                    .setRightClick("果断绑定", v -> {
                        startActivity(DynamicIn.INSTANCE.inputPhoneIntent(this, DynamicConstants.BIND_PHONE_ACTION));
                    })
                    .setMessage("\n" + DynamicConstants.Companion.getBIND_PHONE() + "\n")
                    .show();
            return;
        }

        if (!isSendComment) {
            if (replierType == 0) {
                BuryPointUtils.getInstance().createMap()
                        .put("dynamic_name", mTrendBody.title)
                        .put("dynamic_ID", mTrendBody.id + "")
                        .put("dynamic_type", mTrendBody.topicTitle)
                        .burryPoint("Comment_dynamic");
            } else {
                BuryPointUtils.getInstance().createMap()
                        .put("replier_ID", id)
                        .put("replier_name", toName)
                        .put("replier_type", replierType == 2 ? "专家" : "用户")
                        .burryPoint("Reply_dynamic");
            }
            isSendComment = true;
            Runnable initCommentFlagRunnable = new MyRunnable(this, INIT_COMMENT_FLAG);
            uiHandler.postDelayed(initCommentFlagRunnable, 1000);
            getPresenter().commitOrReply(type, String.valueOf(id), content, toContent, toName);
        }
    }

    private void initCommentFlag() {
        isSendComment = false;
    }

    private void gotoTopicPage() {
        Intent intent = new Intent();
        intent.setClass(TrendsDetailActivity.this, TopicDetailActivity.class);
        intent.putExtra("topic_id", mTrendBody.topicId + "");
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    private void doLikeAction(int type, int id) {
        if (DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
            getPresenter().doLikeAction(type, id);
        }
    }

    private void fetchTrendsDetailsInfo() {
        getPresenter().fetchTrendsDetails(trendId);
    }

    private void showZanList() {
        linZanList.setVisibility(View.VISIBLE);
        ivZanListMore.setVisibility(View.VISIBLE);
    }

    private boolean isZanListContainUser() {
        boolean isContainUser = false;
        if (zanImgListAdapter.getDatas() == null || !DynamicIn.INSTANCE.isLogin()) {
            isContainUser = false;
        } else {
            int length = zanImgListAdapter.getDatas().size() > zan_max_num ? zan_max_num : zanImgListAdapter.getDatas().size();
            for (int i = 0; i < length; i++) {
                if (Integer.valueOf(DynamicIn.INSTANCE.getUserInfo().getUid()) == zanImgListAdapter.getDatas().get(i).uid) {
                    isContainUser = true;
                    break;
                }
            }
        }
        return isContainUser;
    }

    //重置当前评论类型
    private void replyReset() {
        this.type = 1;
        this.id = trendId;
        this.toUsername = "";
        this.toContent = "";
        edCommentContent.setText("");
        edCommentContent.setHint("发表评论");
        hideInputMethod();
        edCommentContent.clearFocus();
    }


    private void reply(String toName, int type, int id, String toContent, int replierType) {
        this.replierType = replierType;
        this.type = type;
        this.id = id;
        this.toContent = toContent;
        this.toUsername = toName;
        hideEmojiLayout();
        ivChooseEmoji.setImageResource(R.drawable.dynamic_edict_ico_emoji);
        edCommentContent.setFocusable(true);
        edCommentContent.setFocusableInTouchMode(true);
        edCommentContent.requestFocus();
        if (!TextUtils.isEmpty(toName)) {
            edCommentContent.setHint("回复" + toName);
        } else {
            edCommentContent.setHint("发表评论");
        }
        uiHandler.postDelayed(showTextRunnable, 200);
    }


    // 隐藏表情布局
    @SuppressLint("WrongConstant")
    private void hideEmojiLayout() {
        uiHandler.removeCallbacks(showEmojiRunnable);

        if (mEmoticonPickerView != null) {
            mEmoticonPickerView.setVisibility(View.GONE);
        }
        isShowEmojiView = false;
    }

    // 显示表情布局
    private void showEmojiLayout() {
        hideInputMethod();
        edCommentContent.requestFocus();
        uiHandler.postDelayed(showEmojiRunnable, 100);
        mEmoticonPickerView.show(this);
        isShowEmojiView = true;
    }

    private void hideInputMethod() {
        isKeyboardShowed = false;
        uiHandler.removeCallbacks(showTextRunnable);
        @SuppressLint("WrongConstant") InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(edCommentContent.getWindowToken(), 0);
    }

    // 点击表情，切换到表情布局
    @SuppressLint("WrongConstant")
    private void toggleEmojiLayout() {
        if (mEmoticonPickerView == null || mEmoticonPickerView.getVisibility() == View.GONE) {
            showEmojiLayout();
            ivChooseEmoji.setImageResource(R.drawable.dynamic_edict_ico_key);
        } else {
            hideEmojiLayout();
            showInputMethod(edCommentContent);
            ivChooseEmoji.setImageResource(R.drawable.dynamic_edict_ico_emoji);
        }
    }

    // 显示键盘布局
    private void showInputMethod(EditText editTextMessage) {
        editTextMessage.requestFocus();
        //如果已经显示,则继续操作时不需要把光标定位到最后
        if (!isKeyboardShowed) {
            editTextMessage.setSelection(editTextMessage.getText().length());
            isKeyboardShowed = true;
        }
        @SuppressLint("WrongConstant") InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(editTextMessage, 0);
    }

    /**
     * 举报
     */
    public void showReportReason(final int ttype, final int answerId, final String answerContent) {
        if (reportReasons == null || reportReasons.size() <= 0) {
            getPresenter().fetchReportReasonContent(answerId, answerContent);
            return;
        }
        int itemTextColor = Color.RED;
        ListDialog.Builder builder1 = new ListDialog.Builder(this, reportReasons, itemTextColor);
        builder1.SetLastStr("取消");
        builder1.SetLastButton("取消", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder1.SetOnItemClickLister(new ListDialog.Builder.OnItemClickLister() {
            @Override
            public void onItemClick(Dialog dialog, View view, int position) {
                dialog.dismiss();
                if (!DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
                    return;
                }
                getPresenter().report(trendId, ttype, Integer.valueOf(reportReasonsId.get(position)), answerId, answerContent);
            }

            @Override
            public void onItemLongClick(Dialog dialog, View view, int position) {

            }
        });
        builder1.create().show();
    }

    private boolean isHasMore() {
        LogUtil.d("comment count: " + commentCount + " comment size: " + commentListAdapter.getDatas().size());
        return commentCount > commentListAdapter.getDatas().size();
    }

    @SuppressLint("SetTextI18n")
    private void fillContent() {
        linComment.setVisibility(VISIBLE);
        linContent.setVisibility(View.VISIBLE);
        relNotExist.setVisibility(View.GONE);
        linNullTip.setVisibility(mTrendBody.replyCounter > 0 ? GONE : VISIBLE);
        tvGuanzhu.setVisibility(mTrendBody.isFocused == 1 || mTrendBody.uid.equals("0") || TextUtils.equals(mTrendBody.uid, DynamicIn.INSTANCE.getUserInfo().getUid()) ? View.GONE : View.VISIBLE);
        ivLike.setImageResource(mTrendBody.isZan == 1 ? R.drawable.dynamic_newsfeed_like_sel : R.drawable.dynamic_newsfeed_like);
        if (!TextUtils.isEmpty(mTrendBody.content)) {
            MoonUtil.identifyFaceExpression(this, tvContent, mTrendBody.content, ImageSpan.ALIGN_BOTTOM);
            tvContent.setVisibility(View.VISIBLE);
        } else {
            tvContent.setVisibility(View.GONE);
        }
        tvUserName.setText(mTrendBody.name);
        tvTime.setText(mTrendBody.timeStr);    //发布时间
        tvFrom.setText("IP属地: " + mTrendBody.ipProvince); // IP属地

        if (TextUtils.isEmpty(mTrendBody.title)) {
            tvTrendInfoTitle.setVisibility(GONE);
        } else {
            tvTrendInfoTitle.setVisibility(VISIBLE);
            tvTrendInfoTitle.setText(mTrendBody.title);  //标题
        }

        tvReadNum.setText(mTrendBody.visitCount);  //阅读量
        tvZanNum.setText(String.valueOf(mTrendBody.zanCount));  //点赞数量
        setZanBackground(mTrendBody.isZan == 1);
        tvHuati.setText("#" + mTrendBody.topicTitle + "#");
        tvCommentNum.setText(mTrendBody.replyCounter + "个评论");
        ivSex.setImageResource(mTrendBody.gender == 2 ? R.drawable.dynamic_female : R.drawable.dynamic_male);
        GlideApp.with(this)
                .load(mTrendBody.header)
                .placeholder(R.drawable.dynamic_head_place_hold_pic)
                .error(R.drawable.dynamic_head_place_hold_pic)
                .circleCrop()
                .skipMemoryCache(true)
                .into(ivUserHead);//头像
        LogUtil.d("multitext_type: " + mTrendBody.multitextType);
        if (mTrendBody.multitextType.equals("2") || mTrendBody.multitextType.equals("3")) {
            fillImageContent();
        } else if (mTrendBody.multitextType.equals("4")) {
            fillAdContent();
        }
        if (isScrollToZan) {
            Runnable scrollToZanRunnable = new MyRunnable(this, SCROLL_TO_ZAN);
            uiHandler.postDelayed(scrollToZanRunnable, 400);
        }
    }

    private void scrollToZan() {
        myScrollView.smoothScrollTo(0, linZanList.getTop() - ScreenUtil.screenHeight / 2);
        isScrollToZan = false;
    }

    private void fillAdContent() {
        relTrendAd.setVisibility(View.VISIBLE);
        rcvContentImags.setVisibility(View.GONE);
        tvAdTitle.setText(mTrendBody.ext.title);
        GlideApp.with(this)
                .load(mTrendBody.ext.cover)
                .placeholder(R.drawable.dynamic_default_img)
                .centerCrop()
                .into(ivAd);
        iv_fm.setVisibility((null != mTrendBody && null != mTrendBody.ext && mTrendBody.ext.url.contains("fm/detail")) ? View.VISIBLE : View.GONE);
    }

    private void fillImageContent() {
        rcvContentImags.setVisibility(View.VISIBLE);
        relTrendAd.setVisibility(View.GONE);
        contentImags = mTrendBody.bigAttach;
        imagsContentAdapter.clearData();
        imagsContentAdapter.setDatas(contentImags);
        imagsContentAdapter.notifyDataSetChanged();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (uiHandler != null) {
            uiHandler.removeCallbacksAndMessages(null);
        }
        if (subscribe != null) {
            subscribe.dispose();
        }
        EventBus.getDefault().unregister(this);
    }
    public void onEvent(dynamicFocusEvent event) {
        // 1已关注 2关注
        if (event.getFocusState().equals("1")){
            tvGuanzhu.setVisibility(GONE);
            tvGuanzhu.setText("已关注");
        }else{
            tvGuanzhu.setEnabled(true);
            tvGuanzhu.setVisibility(VISIBLE);
            tvGuanzhu.setText("关注");
        }
    }
    @NonNull
    @Override
    public ITrendsDetailPresenterImpl createPresenter() {
        return new ITrendsDetailPresenterImpl();
    }

    @Override
    public void onBackPressed() {
        setResultForActivity();
//        overridePendingTransition(R.anim.activity_close_enter_anim, R.anim.activity_close_exit_anim);
        this.finish();
    }

    private void setResultForActivity() {
        if (isTrendsBodyLoadError || mTrendBody == null) {
            return;
        }
        LogUtil.d("pos: " + mPosition + " likestate: " + likeState + " reply_count: " + mTrendBody.replyCounter + " zancount: " + mTrendBody.zanCount);
        Intent i = new Intent();
        i.putExtra("position", mPosition);
        i.putExtra("like_state", likeState);
        i.putExtra("comment_count", mTrendBody.replyCounter);
        i.putExtra("like_count", mTrendBody.zanCount);
//        returnCommentsData.add(DynamicIn.INSTANCE.getUserInfo().nickName+"/"+content+"/"+toName);
        LogUtil.d("isCommentDataChanged: " + isCommentDataChanged);
        if (isCommentDataChanged && commentListAdapter.getDatas().size() > 0) {
            returnCommentsData = new ArrayList<>();
            for (int j = 0; j < (commentListAdapter.getDatas().size() > 6 ? 6 : commentListAdapter.getDatas().size()); j++) {
                CommentBean commentBean = commentListAdapter.getDatas().get(j);
                LogUtil.d("retrun comment name: " + commentBean.getName() + " content: " + commentBean.getContent() + " to name: " + commentBean.getTo_name());
                if (TextUtils.isEmpty(commentBean.getTo_name())) {
                    returnCommentsData.add(commentBean.getName() + "/" + commentBean.getContent());
                } else {
                    returnCommentsData.add(commentBean.getName() + "/" + commentBean.getContent() + "/" + commentBean.getTo_name());
                }
            }
            i.putStringArrayListExtra("comment_datas", returnCommentsData);
        }
        setResult(RESULT_CODE, i);
    }

    @Override
    public void onRefresh() {
        isScrollToComment = false;
        tvShowAllComment.setVisibility(View.GONE);
        page = 1;
        lastId = 0;
        swl.setRefreshing(true);
        fetchTrendsDetailsInfo();
    }

    private void gotoAd() {
        if (YDLRouterManager.Companion.router(mTrendBody.ext.url)) {
            return;
        }
        Map<String, String> map = StringUtils.IsHttpReturn(mTrendBody.ext.url);
        String jumpType = map.get("jump_type");
        LogUtil.d("jumpType: " + jumpType);
        if ("url".equals(jumpType)) {
            String realUrl = map.get("url");
            String urlPage = map.get("url_page");
            if ("experts_search".equals(urlPage)) {
                startActivity(DynamicIn.INSTANCE.expertSearchIntent(TrendsDetailActivity.this, 0, 0, false));
            } else if ("test_detail".equals(urlPage)) {
                String[] strs = realUrl.split("/");
                String containsId = strs[strs.length - 1];
                try {
                    int id = Integer.parseInt(containsId.replaceAll("[^0-9]*", ""));
//                    OuterEmptyImp.jumpToTestDetailActivity(TrendsDetailActivity.this, id);
//                    startActivity(DynamicIn.INSTANCE.testDetailIntent(this, id));
                    DynamicIn.INSTANCE.testDetailH5(id);
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else if ("test_result".equals(urlPage)) {
                String[] strs = realUrl.split("/");
                strs = strs[strs.length - 1].split("&");
                String containsId = strs[0];
                try {
                    int id = Integer.parseInt(containsId.replaceAll("[^0-9]*", ""));
//                    OuterEmptyImp.jumpToTestResultActivity(this, id);
//                    startActivity(DynamicIn.INSTANCE.testResultIntent(this, id));
                    DynamicIn.INSTANCE.testResultH5(id);
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else if ("test".equals(urlPage)) {
                String[] strs = realUrl.split("/");
                strs = strs[strs.length - 1].split("&");
                String containsId = strs[0];
                if (!DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
                    return;
                }
                DynamicIn.INSTANCE.testDetailH5(Integer.valueOf(containsId));
            } else if (realUrl.contains("fm/detail")) {
                //因为ios已经做了，就是这么判断的，所以后续改吧
                String id = realUrl.substring(realUrl.lastIndexOf("/") + 1);
                if (!TextUtils.isEmpty(id)) {
                    startActivity(DynamicIn.INSTANCE.fmDetailIntent(this, Integer.valueOf(id)));
                }
            } else {
                H5Params h5Params = new H5Params(realUrl, null);
                NewH5Activity.start(getMContext(), h5Params);
            }
        } else if ("native".equals(jumpType)) {
            String nativePage = map.get("native_page");
            if ("listen".equals(nativePage)) {
//                Intent intent = new Intent(mContext, PhoneCallActivity.class);
//                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                mContext.startActivity(intent);
//                OuterEmptyImp.jumpToPhoneCallActivity(TrendsDetailActivity.this);
                startActivity(DynamicIn.INSTANCE.phoneCallIntent(this));
            } else if ("fm".equals(nativePage)) {
                String fmId = map.get("id");
                int fm_idi = Integer.valueOf(fmId);
//                OuterEmptyImp.jumpToFMDetailActivity(getMContext(),Integer.valueOf(map.get("id")));
                startActivity(DynamicIn.INSTANCE.fmDetailIntent(this, fm_idi));

            }
        }
    }

    //分享
    public void share() {
        if (mTrendBody == null) {
            return;
        }
        List<ShareMoreBean> shareMoreBeanList = new ArrayList<>();
        if (mTrendBody.is_self == 1) {
            //自己的帖子
//            shareMoreBeanList.add(new ShareMoreBean(R.drawable.pop_delete, getString(R.string.delete), () -> {
//                //删除
//                deleteDialog(2, mTrendBody.id, 0);//
//            }));
            YDLShareDialog dialog = YDLShareDialog.Companion.style2(this, mTrendBody.title, DynamicConstants.Companion.getTRENF_INFO_SHARE_H5() + trendId, mTrendBody.content, "http://static.ydlcdn.com/v1/images/logo320.png");
            dialog.setCallBack(type -> {
                if (2 == type) {
                    //删除
                    deleteDialog(2, mTrendBody.id, 0);
                } else if (4 == type) {
                    backHome();
                }
            });
            dialog.show(getFragmentManager(), "lose");
        } else {
            //别人帖子
            YDLShareDialog dialog = YDLShareDialog.Companion.style3(this, mTrendBody.title, DynamicConstants.Companion.getTRENF_INFO_SHARE_H5() + trendId, mTrendBody.content, "http://static.ydlcdn.com/v1/images/logo320.png");
            dialog.setCallBack(type -> {
                if (3 == type) {
                    if (!DynamicIn.INSTANCE.loginByOneKeyLogin(TrendsDetailActivity.this,true)) {
                        return;
                    }
                    showReportReason(1, 0, null);
                } else if (4 == type) {
                    backHome();
                }
            });
            dialog.show(getFragmentManager(), "lose");
        }
//        ShareUtils.INSTANCE.share(this, mTrendBody.title, DynamicConstants.TRENF_INFO_SHARE_H5 + trendId, mTrendBody.content, "http://static.ydlcdn.com/v1/images/logo320.png", shareMoreBeanList);
        ShareUtils.INSTANCE.setCallBack(new ShareActionCallBack() {
            @Override
            public void onShareFailed(@NotNull SHARE_MEDIA share_media, @NotNull Throwable throwable) {
                BuryPointUtils.getInstance().createMap()
                        .put("share_where", share_media.toString())
                        .put("share_what", trendId + (mTrendBody != null ? mTrendBody.title : ""))
                        .put("share_succeed", false)
                        .burryPoint("Share");
                LogUtil.d("Share Failed: " + share_media);
            }

            @Override
            public void onShareSuccessed(@NotNull SHARE_MEDIA share_media) {
                LogUtil.d("share successed: " + share_media);
                BuryPointUtils.getInstance().createMap()
                        .put("share_where", share_media.toString())
                        .put("share_what", trendId + (mTrendBody != null ? mTrendBody.title : ""))
                        .put("share_succeed", true)
                        .burryPoint("Share");
            }

        });
    }

    private void backHome() {
        DynamicIn.INSTANCE.mainIntent(this, 0);
    }

    /**
     * 删除提示
     *
     * @param type
     * @param id
     * @param position 删除帖子的位置
     */
    public void deleteDialog(final int type, final int id, final int position) {
        NormalDialog.Builder builder = new NormalDialog.Builder(this);
        builder.setTitle("");
        builder.setMessage("覆水难收啊，陛下，真的删除吗？");
        builder.setPositiveButton("删了吧",
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        getPresenter().delTrendsReply(type, id, position);
                    }
                });
        builder.setNegativeButton("我纠结了",
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
        builder.create().show();
    }

    /**
     * 长按评论弹出dialog
     *
     * @param view1
     * @param positionm 位置
     */
    public void showDialog(final View view1, final int positionm, CommentBean commentData) {

        String uid = "-2";
        try {
            uid = DynamicIn.INSTANCE.getUserInfo().getUid();
        } catch (Exception e) {
        }

        final boolean isSelf = TextUtils.equals(commentData.getUid(), uid);

        //自己的回复
        List<String> dialogDatas = new ArrayList<String>();
        if (isSelf) {
            dialogDatas.add("复制");
            dialogDatas.add("删除");
        } else { //ta人的回复
            dialogDatas.add("回复");
            dialogDatas.add("举报");
        }
        dialogDatas.add("取消");
        ListDialog.Builder builder1 = new ListDialog.Builder(TrendsDetailActivity.this, dialogDatas, Color.BLACK);
        builder1.SetOnItemClickLister(new ListDialog.Builder.OnItemClickLister() {
            @Override
            public void onItemClick(Dialog dialog, View view, int position) {
                switch (position) {
                    case 0:
                        if (isSelf) {
                            //复制
                            @SuppressLint("WrongConstant") ClipboardManager cm = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
                            // 将文本内容放到系统剪贴板里。
                            TextView textCommentContent = (TextView) view1.findViewById(R.id.text_comment_content);
                            String word = textCommentContent.getText().toString();
                            if (word.indexOf("：") != -1) {
                                word = word.substring(word.indexOf("：") + 1);
                            }
                            cm.setText(word);
                            ToastUtil.toastShort("复制成功");
                        } else {
                            reply(commentData.getName(), 2, commentData.getId(), commentData.getContent(), commentData.getUser_type());
                        }
                        break;
                    case 1:
                        if (isSelf) {
                            deleteDialog(1, commentData.getId(), positionm);//删除
                        } else {
                            showReportReason(1, commentData.getId(), commentData.getContent());
                        }
                        break;
                }
                dialog.dismiss();
            }

            @Override
            public void onItemLongClick(Dialog dialog, View view, int position) {
            }
        });
        builder1.create().show();
    }

    @Override
    public void onEmojiSelected(String key) {
        if (key.equals("/DEL")) {
            edCommentContent.dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_DEL));
        } else {
            int start = edCommentContent.getSelectionStart() > 0 ? edCommentContent.getSelectionStart() : 0;
            int end = edCommentContent.getSelectionEnd() > 0 ? edCommentContent.getSelectionEnd() : 0;
            edCommentContent.getText().replace(start, end, key);
        }

    }

    @Override
    public void onStickerSelected(String categoryName, String stickerName) {

    }

    @Override
    public void onScrollChanged(MyScrollview scrollView, int x, int y, int oldx, int oldy) {
        hideEmojiLayout();
        hideInputMethod();
        ivChooseEmoji.setImageResource(R.drawable.dynamic_edict_ico_key);
        edCommentContent.clearFocus();
    }

    private void startAnimation(ImageView imgView) {
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat("scaleX", 1f, 1.5f, 1f);
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat("scaleY", 1f, 1.5f, 1f);
        ObjectAnimator.ofPropertyValuesHolder(imgView, scaleX, scaleY).setDuration(500).start();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        //所有友盟分享，都必须复写这里，保证返回到分享界面时，能够回调友盟的接口。
        //友盟分享必须重写
//        InnerEmptyImp.UMShareOnActivityResult();
        UMShareAPI.get(this).onActivityResult(requestCode, resultCode, data);
    }

    static class MyHandler extends Handler {
        WeakReference<Context> mActivity;

        public MyHandler(Context activity) {
            mActivity = new WeakReference<Context>(activity);
        }
    }

    static class MyRunnable implements Runnable {
        WeakReference<TrendsDetailActivity> mActivity;
        int flag = -1;

        public MyRunnable(TrendsDetailActivity activity, int scrollPlace) {
            mActivity = new WeakReference<TrendsDetailActivity>(activity);
            this.flag = scrollPlace;
        }

        @Override
        public void run() {
            if (mActivity.get() == null) {
                return;
            }
            if (flag == SCROLL_TO_ZAN) {
                mActivity.get().scrollToZan();
            } else if (flag == SCROLL_TO_COMMENT) {
                mActivity.get().scrollToComment();
            } else if (flag == INIT_COMMENT_FLAG) {
                mActivity.get().initCommentFlag();
            }
        }
    }

    static class ShowEmojiRunnable implements Runnable {
        WeakReference<TrendsDetailActivity> mActivity;
        WeakReference<EmoticonPickerView> mEmoticonPickerView;

        public ShowEmojiRunnable(TrendsDetailActivity activity, EmoticonPickerView emoticonPickerView) {
            mActivity = new WeakReference<TrendsDetailActivity>(activity);
            mEmoticonPickerView = new WeakReference<EmoticonPickerView>(emoticonPickerView);
        }

        @Override
        public void run() {
            if (mEmoticonPickerView.get() != null) {
                mEmoticonPickerView.get().setVisibility(View.VISIBLE);
            }
        }
    }

    static class ShowTextRunnable implements Runnable {
        WeakReference<TrendsDetailActivity> mActivity;
        WeakReference<EditText> edCommentContent;

        public ShowTextRunnable(TrendsDetailActivity activity, EditText edCommentContent) {
            mActivity = new WeakReference<TrendsDetailActivity>(activity);
            this.edCommentContent = new WeakReference<EditText>(edCommentContent);
        }

        @Override
        public void run() {
            if (mActivity.get() != null && edCommentContent.get() != null) {
                mActivity.get().showInputMethod(edCommentContent.get());
            }
        }

    }


    private boolean judgeIsSlienced() {
        if (DynamicIn.INSTANCE.getUserInfo() != null && DynamicIn.INSTANCE.getUserInfo().is_silenced() == 2) {
            CommonDialog.create(this)
                    .setMessage(TrendsDetailActivity.this.getString(R.string.dynamic_silence_content))
                    .setLeftOnclick(TrendsDetailActivity.this.getString(R.string.platform_appeal), new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            DynamicIn.INSTANCE.startChat(TrendsDetailActivity.this, "14");
                        }
                    })
                    .setRightClick(TrendsDetailActivity.this.getString(R.string.dynamic_approval), null)
                    .show();
            return true;
        }
        return false;
    }

}
