package com.yidianling.dynamic.trendsHome;

import static com.yidianling.dynamic.bean.DynamicConstants.YDL_USER_ASK_PAGE_STAY_VISIT;
import static com.yidianling.dynamic.bean.DynamicConstants.YDL_USER_ASK_PAGE_VISIT;
import static com.yidianling.dynamic.bean.DynamicConstants.YDL_USER_ASK_QUESTIONS_BUTTON_CLICK;
import static com.yidianling.dynamic.bean.DynamicConstants.YDL_USER_ASK_TYPE_CLICK;
import static com.yidianling.dynamic.bean.DynamicConstants.YDL_USER_THOUGHTS_GROUP_MORE_CLICK;
import static com.yidianling.dynamic.bean.DynamicConstants.YDL_USER_THOUGHTS_GROUP_TYPE_CLICK;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.appcompat.widget.Toolbar;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.viewpager.widget.ViewPager;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.base.BaseFragment;
import com.ydl.ydlcommon.utils.BuryPointUtils;
import com.ydl.ydlcommon.utils.ScreenUtil;
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils;
import com.yidianling.common.tools.RxDeviceTool;
import com.yidianling.common.tools.RxImageTool;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.bean.DynamicConstants;
import com.yidianling.dynamic.common.view.LooperTextView;
import com.yidianling.dynamic.dialog.TrendsAndQuestionDialog;
import com.yidianling.dynamic.dialog.listener.TrendsQuestionListener;
import com.yidianling.dynamic.model.TopicListDataBean;
import com.yidianling.dynamic.model.TrendsListBean;
import com.yidianling.dynamic.publishTrend.PublishTrendActivity;
import com.yidianling.dynamic.router.DynamicIn;
import com.yidianling.dynamic.topic.AllTopicActivity;
import com.yidianling.dynamic.topic.topicDetail.TopicDetailActivity;
import com.yidianling.dynamic.trendsHome.content.TrendsContentListFragment;
import com.yidianling.dynamic.trendsHome.view.TrendsHomeBannerView;

import java.util.List;

import jp.wasabeef.glide.transformations.RoundedCornersTransformation;

/**
 * Created by Jim on 2017/9/22 0022.
 * 首页问答fragment
 */
@Route(path = "/dynamic/dynamic")
public class TrendsHomeFragment extends BaseFragment implements ITrendHomeView, SwipeRefreshLayout.OnRefreshListener {

    private SwipeRefreshLayout swl;

    private ViewPager vpContent;

    private ImageView topicRoundIv1;

    private ImageView topicRoundIv2;

    private ImageView topicRoundIv3;

    private ConstraintLayout mConstraintLayout;

    private TextView tvMindGroup;

    private TextView tvMindMore;

    private FrameLayout frlTopicIv3;

    private FrameLayout frlTopicIv2;

    private FrameLayout frlTopicIv1;

    private AppBarLayout mAppBarLayout;
    private TextView mItemRecommendTv;
    private TextView mItemHotTv;
    private TextView mItemFocusTv;
    private TextView trendsTopicTv3;
    private TextView trendsTopicTv2;
    private TextView trendsTopicTv1;
    private FloatingActionButton mPublishTrendButton;
    private LooperTextView mLooperTextView;
    private Toolbar mToolBarTv;
    private TrendsHomeBannerView v_banner;
    private TrendsHomePresenter mPresenter;
    private Fragment[] mFragments;
    private TrendsHomeVpAdapter vpAdapter;
    private long lastTabClick = 0;
    private int currentPostion = -1;
    String tab;
    private long startTime;
    private long endTime;
    private TrendsAndQuestionDialog trendsAndQuestionDialog = null;

    public TrendsHomeFragment setTab(String tab) {
        this.tab = tab;
        return this;
    }

    public static TrendsHomeFragment newInstance() {
        return new TrendsHomeFragment();
    }


    @Override
    public int layoutResId() {
        return R.layout.dynamic_fragment_moments;
    }

    @Override
    public void initDataAndEvent() {
        bindView(getView());
        initViews();
        initDatas();

    }

    @Override
    public void initDataAndEventLazy() {
//        initDatas();
    }

    private void initViews() {
        initBannerView();
        swl.setOnRefreshListener(this);
        swl.setColorSchemeResources(R.color.platform_main_theme);
        mAppBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener() {
            @Override
            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (verticalOffset == 0) {
                    swl.setEnabled(true);
                } else {
                    swl.setEnabled(false);
                }
                if (verticalOffset <= -appBarLayout.getTotalScrollRange() + mToolBarTv.getHeight()) {
                    mToolBarTv.setAlpha(1f);
                } else {
                    mToolBarTv.setAlpha(0f);
                }
            }
        });
        initStatus();
    }

    private void initStatus() {
        //4.4以下不支持状态栏变色
        int statusBarHeight = ScreenUtil.getStatusBarHeight(getActivity());
        CollapsingToolbarLayout.LayoutParams layoutParams = (CollapsingToolbarLayout.LayoutParams) mToolBarTv.getLayoutParams();
        layoutParams.height = (int) (getResources().getDimension(R.dimen.title_bar_height) + statusBarHeight);
        mToolBarTv.setPadding(0, statusBarHeight, 0, 0);
        mToolBarTv.setLayoutParams(layoutParams);

    }

    private void initDatas() {
        mPresenter = new TrendsHomePresenter();
        mPresenter.callBack = this;
        mPresenter.fetchDats();
    }

    private void initBannerView() {
        int screenSize = RxDeviceTool.getScreenWidth(getActivity());
        int topicRoundIv1Width = (screenSize - RxImageTool.dip2px(31)) * 2 / 3;
        int topicRoundIv23Width = (screenSize - RxImageTool.dip2px(31)) / 3;

        int topicRoundIv1Height = (int) (topicRoundIv1Width / 1.5f);
        int topicRoundIv23Height = (int) ((topicRoundIv1Height - RxImageTool.dip2px(1)) / 2f);

        ConstraintLayout.LayoutParams params1 = new ConstraintLayout.LayoutParams(topicRoundIv1Width, topicRoundIv1Height);
        params1.topMargin = RxImageTool.dp2px(10);
        params1.leftMargin = RxImageTool.dp2px(15);
        params1.leftToRight = mConstraintLayout.getId();
        params1.topToBottom = tvMindGroup.getId();
        frlTopicIv1.setLayoutParams(params1);

        ConstraintLayout.LayoutParams params2 = new ConstraintLayout.LayoutParams(topicRoundIv23Width, topicRoundIv23Height);
        params2.topMargin = RxImageTool.dp2px(10);
        params2.leftMargin = RxImageTool.dp2px(1);
        params2.leftToRight = frlTopicIv1.getId();
        params2.topToBottom = tvMindGroup.getId();
        frlTopicIv2.setLayoutParams(params2);

        ConstraintLayout.LayoutParams params3 = new ConstraintLayout.LayoutParams(topicRoundIv23Width, topicRoundIv23Height);
        params3.topMargin = RxImageTool.dp2px(1);
        params3.leftMargin = RxImageTool.dp2px(1);
        params3.leftToRight = frlTopicIv1.getId();
        params3.topToBottom = frlTopicIv2.getId();
        frlTopicIv3.setLayoutParams(params3);
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser && isResumed()) {
            startTime = System.currentTimeMillis();
            ActionCountUtils.Companion.count(YDL_USER_ASK_PAGE_VISIT);
        } else {
            if (startTime != 0L) {
                endTime = System.currentTimeMillis();
                ActionCountUtils.Companion.count(YDL_USER_ASK_PAGE_STAY_VISIT, String.valueOf(endTime - startTime));
            }
        }
        if (isVisibleToUser && isResumed()) {
            onResume();
        }
    }

    private void initViewPager() {
        vpAdapter = new TrendsHomeVpAdapter(getChildFragmentManager(), mFragments);
        vpContent.setAdapter(vpAdapter);
        vpContent.setOffscreenPageLimit(1);
        vpContent.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                if (position == currentPostion) {
                    return;
                }
                currentPostion = position;
                if (position >= 1) {
                    vpContent.setOffscreenPageLimit(2);
                }

                switchTab(position);
                switch (position) {
                    case 0:
                        BuryPointUtils.getInstance().createMap()
                                .put("toptab_name", "推荐")
                                .burryPoint("topTabClick");
                        BuryPointUtils.getInstance().trackViewScreen(getActivity(), "动态-推荐", "com.cxzapp.yidianling.trends.trendList.TrendsListFragment");
                        break;
                    case 1:
                        BuryPointUtils.getInstance().createMap()
                                .put("toptab_name", "最新")
                                .burryPoint("topTabClick");
                        BuryPointUtils.getInstance().trackViewScreen(getActivity(), "动态-最新", "com.cxzapp.yidianling.trends.trendList.TrendsListFragment");
                        break;
                    case 2:
                        BuryPointUtils.getInstance().createMap()
                                .put("toptab_name", "关注")
                                .burryPoint("topTabClick");
                        if (!DynamicIn.INSTANCE.loginByOneKeyLogin(getActivity(), true)) {
                            return;
                        }
                        BuryPointUtils.getInstance().trackViewScreen(getActivity(), "动态-关注", "com.cxzapp.yidianling.trends.trendList.TrendsListFragment");
                        break;
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        if ("hot".equals(tab)) {
            vpContent.setCurrentItem(1);
            switchTab(1);
        } else if ("new".equals(tab)) {
            vpContent.setCurrentItem(0);
            switchTab(0);
        } else {
            vpContent.setCurrentItem(0);
            switchTab(0);
        }
    }


    private void switchTab(int index) {
        switch (index) {
            case 0:
                mItemRecommendTv.setSelected(false);
                mItemRecommendTv.setTextColor(getResources().getColor(R.color.dynamic_text_666666));
                mItemFocusTv.setSelected(false);
                mItemFocusTv.setTextColor(getResources().getColor(R.color.dynamic_text_666666));
                mItemHotTv.setSelected(true);
                mItemHotTv.setTextColor(getResources().getColor(R.color.platform_but_text_color));
                break;
            case 1:
                mItemRecommendTv.setSelected(true);
                mItemRecommendTv.setTextColor(getResources().getColor(R.color.platform_but_text_color));
                mItemFocusTv.setSelected(false);
                mItemFocusTv.setTextColor(getResources().getColor(R.color.dynamic_text_666666));
                mItemHotTv.setSelected(false);
                mItemHotTv.setTextColor(getResources().getColor(R.color.dynamic_text_666666));
                break;
            case 2:
                mItemRecommendTv.setSelected(false);
                mItemRecommendTv.setTextColor(getResources().getColor(R.color.dynamic_text_666666));
                mItemFocusTv.setSelected(true);
                mItemFocusTv.setTextColor(getResources().getColor(R.color.platform_but_text_color));
                mItemHotTv.setSelected(false);
                mItemHotTv.setTextColor(getResources().getColor(R.color.dynamic_text_666666));
                break;
        }
    }


    private void doClick(View view) {
        if (view.getId() == R.id.item_recommend_tv) {
            ActionCountUtils.Companion.count(YDL_USER_ASK_TYPE_CLICK, "推荐");
            vpContent.setCurrentItem(1);
        } else if (view.getId() == R.id.item_hot_tv) {
            ActionCountUtils.Companion.count(YDL_USER_ASK_TYPE_CLICK, "最新");
            vpContent.setCurrentItem(0);
        } else if (view.getId() == R.id.item_focus_tv) {
            ActionCountUtils.Companion.count(YDL_USER_ASK_TYPE_CLICK, "关注");
            vpContent.setCurrentItem(2);
        } else if (view.getId() == R.id.publish_trend_btn) {
            ActionCountUtils.Companion.count(YDL_USER_ASK_QUESTIONS_BUTTON_CLICK);
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(getActivity(), true)) {
                trendsAndQuestionDialog = new TrendsAndQuestionDialog(requireContext(), new TrendsQuestionListener() {
                    @Override
                    public void publishTrends() {
                        //发布动态
                        Intent intent = new Intent(getActivity().getApplicationContext(), PublishTrendActivity.class);
                        //默认改为今日打卡
                        Bundle bundle = new Bundle();
                        bundle.putString(DynamicConstants.PUBLISH_TYPE, "topic_publish");
                        bundle.putString("topic_id", "44");
                        bundle.putString("topic_title", "今日打卡");
                        bundle.putInt("dynamic_question", 1);
                        intent.putExtra("bundle", bundle);
                        startActivity(intent);
//                        PublishTrendActivityTrends.Companion.start(requireContext(),"44","今日打卡");
                    }

                    @Override
                    public void publishQuestion() {
                        //提问题
                        Intent intent = new Intent(getActivity().getApplicationContext(), PublishTrendActivity.class);
                        //默认改为今日打卡
                        Bundle bundle = new Bundle();
                        bundle.putString(DynamicConstants.PUBLISH_TYPE, "topic_publish");
                        bundle.putString("topic_id", "44");
                        bundle.putString("topic_title", "今日打卡");
                        bundle.putInt("dynamic_question", 2);
                        intent.putExtra("bundle", bundle);
                        startActivity(intent);
                    }
                });
                trendsAndQuestionDialog.show();
            }
        } else if (view.getId() == R.id.trends_tv_mind_more) {
            ActionCountUtils.Companion.count(YDL_USER_THOUGHTS_GROUP_MORE_CLICK);
            Intent intent = new Intent(getActivity(), AllTopicActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
        }
//        else if (view.getId() == R.id.iv_background) {
//            YDLRouterManager.Companion.router(IYDLRouterConstant.ROUTER_FM_LIST);
//        }
    }

    @Override
    public void onFetchedDatas(Fragment[] fragments) {
        mFragments = fragments;
        initViewPager();
    }

    public void setBannerData(List<TrendsListBean.Banner> list) {
        v_banner.initData(list);
    }

    @Override
    public void onFetchedDataFailed() {

    }

    public void displayShowCase() {
    }

    @Override
    public void onRefresh() {
        swl.setRefreshing(true);
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                ((TrendsContentListFragment) mFragments[vpContent.getCurrentItem()]).onRefresh();
                swl.setRefreshing(false);
            }
        }, 300);
    }

    public void showMindsGroup(TopicListDataBean topicListDatas) {
        if (topicListDatas.list == null || topicListDatas.list.size() <= 0) {
            return;
        }
        for (int i = 0; i < 3 && i < topicListDatas.list.size(); i++) {
            switch (i) {
                case 0:
                    GlideApp.with(this)
                            .load(topicListDatas.list.get(i).getImg_bg_url())
                            .centerCrop()
                            .transform(new RoundedCornersTransformation(20, 0, RoundedCornersTransformation.CornerType.LEFT))
                            .into(topicRoundIv1);
                    trendsTopicTv1.setText(topicListDatas.list.get(i).getTopic_title());
                    frlTopicIv1.setOnClickListener(view -> {
                        mindTopicClick(topicListDatas.list.get(0).getTopic_title(), topicListDatas.list.get(0).getTopic_id(), trendsTopicTv1.getText().toString());
                    });
                    break;
                case 1:
                    GlideApp.with(this)
                            .load(topicListDatas.list.get(i).getImg_bg_url())
                            .centerCrop()
                            .transform(new RoundedCornersTransformation(20, 0, RoundedCornersTransformation.CornerType.TOP_RIGHT))
                            .into(topicRoundIv2);
                    trendsTopicTv2.setText(topicListDatas.list.get(i).getTopic_title());
                    frlTopicIv2.setOnClickListener(view -> {
                        mindTopicClick(topicListDatas.list.get(1).getTopic_title(), topicListDatas.list.get(1).getTopic_id(), trendsTopicTv2.getText().toString());
                    });
                    break;
                case 2:
                    GlideApp.with(this)
                            .load(topicListDatas.list.get(i).getImg_bg_url())
                            .centerCrop()
                            .transform(new RoundedCornersTransformation(20, 0, RoundedCornersTransformation.CornerType.BOTTOM_RIGHT))
                            .into(topicRoundIv3);
                    trendsTopicTv3.setText(topicListDatas.list.get(i).getTopic_title());
                    frlTopicIv3.setOnClickListener(view -> {
                        mindTopicClick(topicListDatas.list.get(2).getTopic_title(), topicListDatas.list.get(2).getTopic_id(), trendsTopicTv3.getText().toString());
                    });
                    break;
            }
        }


    }

    private void mindTopicClick(String title, String id, String imgName) {
        BuryPointUtils.getInstance().createMap()
                .put("theme_name", title)
                .put("theme_ID", id)
                .burryPoint("Theme_click");
        ActionCountUtils.Companion.count(YDL_USER_THOUGHTS_GROUP_TYPE_CLICK, imgName);
        Intent intent = new Intent();
        intent.setClass(getActivity(), TopicDetailActivity.class);
        intent.putExtra("topic_id", id);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        getActivity().startActivity(intent);
    }

    public void showTopTrend(List<TrendsListBean.ExtData> extDatas) {
        mLooperTextView.setTipList(extDatas);
    }

    public void setGoneLooperTextView() {
        mLooperTextView.setVisibility(View.GONE);
    }

    private void bindView(View bindSource) {
        swl = bindSource.findViewById(R.id.trend_home_swl);
        vpContent = bindSource.findViewById(R.id.vp_content);
        topicRoundIv1 = bindSource.findViewById(R.id.trends_topic_iv1);
        topicRoundIv2 = bindSource.findViewById(R.id.trends_topic_iv2);
        topicRoundIv3 = bindSource.findViewById(R.id.trends_topic_iv3);
        mConstraintLayout = bindSource.findViewById(R.id.trends_home_csl);
        tvMindGroup = bindSource.findViewById(R.id.trends_tv_mind_group);
        tvMindMore = bindSource.findViewById(R.id.trends_tv_mind_more);
        frlTopicIv3 = bindSource.findViewById(R.id.frl_topic_iv3);
        frlTopicIv2 = bindSource.findViewById(R.id.frl_topic_iv2);
        frlTopicIv1 = bindSource.findViewById(R.id.frl_topic_iv1);
        mAppBarLayout = bindSource.findViewById(R.id.trends_home_appBar);
        mItemRecommendTv = bindSource.findViewById(R.id.item_recommend_tv);
        mItemHotTv = bindSource.findViewById(R.id.item_hot_tv);
        mItemFocusTv = bindSource.findViewById(R.id.item_focus_tv);
        trendsTopicTv3 = bindSource.findViewById(R.id.trends_topic_tv3);
        trendsTopicTv2 = bindSource.findViewById(R.id.trends_topic_tv2);
        trendsTopicTv1 = bindSource.findViewById(R.id.trends_topic_tv1);
        mPublishTrendButton = bindSource.findViewById(R.id.publish_trend_btn);
        mLooperTextView = bindSource.findViewById(R.id.ternd_loop_tv);
        mToolBarTv = bindSource.findViewById(R.id.toolbar_tv);
        v_banner = bindSource.findViewById(R.id.v_banner);
        tvMindMore.setOnClickListener(v -> {
            doClick(v);
        });
        mPublishTrendButton.setOnClickListener(v -> {
            doClick(v);
        });
        mItemRecommendTv.setOnClickListener(v -> {
            doClick(v);
        });
        mItemHotTv.setOnClickListener(v -> {
            doClick(v);
        });
        mItemFocusTv.setOnClickListener(v -> {
            doClick(v);
        });
    }
}
