package com.yidianling.dynamic.trendsHome.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.ydl.ydl_router.manager.YDLRouterManager
import com.yidianling.common.tools.RxImageTool
import com.yidianling.dynamic.R
import com.yidianling.dynamic.model.TrendsListBean
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.view.banner.GlideImageLoader
import kotlinx.android.synthetic.main.dynamic_trends_home_banner.view.*

/**
 * @author yuanwai
 * @描述:问答首页banner
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/18
 */
class TrendsHomeBannerView : FrameLayout {

    constructor(context: Context):super(context){

    }

    constructor(context: Context,attributeSet: AttributeSet) : super(context,attributeSet){

    }

    /**
     * banner数据缓存
     */
    private var mDataList: List<TrendsListBean.Banner>? = null

    private var dp14 = 0
    private var dp4 = 0
    private var margin = 0

    init {
        initView()
    }

    private fun initView() {
        val params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        View.inflate(context, R.layout.dynamic_trends_home_banner, this)
        layoutParams = params
        dp14 = RxImageTool.dip2px(14f)
        dp4 = RxImageTool.dip2px(4f)
        margin = RxImageTool.dip2px(2.5f)
    }

    fun initData(list: List<TrendsListBean.Banner>?) {
        if (null == mDataList) {
            mDataList = ArrayList()
        } else {
            (mDataList as ArrayList).clear()
        }
        if (null == list || list.isEmpty()){
            img_single.visibility = View.VISIBLE
            img_single.setOnClickListener {
                YDLRouterManager.router(IYDLRouterConstant.ROUTER_FM_LIST)
            }
        }else{
            img_single.visibility = View.GONE
            (mDataList as ArrayList<TrendsListBean.Banner>).addAll(list)
            val urlLists = ArrayList<String>()
            val count = (mDataList as ArrayList<TrendsListBean.Banner>).size - 1
            for (index in 0..count) {
                urlLists.add((mDataList as ArrayList<TrendsListBean.Banner>)[index].bannerImageUrl!!)
            }
            banner.setImageLoader(GlideImageLoader()).setImages(urlLists).start()
            banner.setOnBannerListener {
                YDLRouterManager.router(list[it].bannerLinkUrl)
            }
        }
    }
}