package com.yidianling.fm;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.fm.response.FM;


/**
 * fm列表项
 * Created by softrice on 15/12/11.
 */
public class FMListItemView extends LinearLayout {

    private ImageView sdv_head;
    private TextView tv_title;
    private TextView tv_anchor;
    private TextView tv_listen_num;

    public FMListItemView(Context context) {
        super(context);
        inflate(context, R.layout.fm_ui_fm_list_item, this);
        sdv_head = findViewById(R.id.sdv_head);
        tv_title = findViewById(R.id.tv_title);
        tv_anchor = findViewById(R.id.tv_anchor);
        tv_listen_num = findViewById(R.id.tv_listen_num);
    }


    public void setData(FM fm) {
        if (!TextUtils.isEmpty(fm.getImageUrl())) {
            GlideApp.with(getContext())
                    .load(fm.getImageUrl())
                    .placeholder(R.drawable.platform_default_img)
                    .into(sdv_head);
        }
        tv_title.setText(fm.getName());
        tv_anchor.setText("主播：" + fm.getAuthor());
        tv_listen_num.setText("收听：" + fm.getHits());
    }
}
