package com.yidianling.fm.modular

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.media.audio.AudioPlayer
import com.ydl.media.view.PlayerFloatHelper
import com.yidianling.fm.FMActivity
import com.yidianling.fm.FMDetailActivity
import com.yidianling.fm.api.service.IFMService

/**
 * Created by xj on 2019/11/6.
 */
@Route(path = "/fm/FMService")
class FMServiceImpl : IFMService {

    constructor()

    override fun init(context: Context?) {

    }

    /**
     * 打开FM列表页面
     */
    override fun fmListIntent(activity: Activity): Intent {
        return FMActivity.newIntent(activity)
    }

    /**
     * 打开FM播放页面
     */
    override fun fmDetailIntent(activity: Activity, id: Int): Intent {
        return FMDetailActivity.newIntent(activity, id)
    }

    /**
     * 打开FM播放页面
     */
    override fun fmDetailIntent(activity: Activity, id: Int, isSplash: Boolean): Intent {
        return FMDetailActivity.newIntent(activity, id, isSplash)
    }

    /**
     * 获取FM播放ID
     */
    override fun getFmId(): Int {
        return PlayerFloatHelper.getFmId()
    }

    /**
     * 关闭音乐播放
     */
    override fun closePlayer() {
        if (AudioPlayer.get().isPlaying) {
            AudioPlayer.get().resetPlayer()
        }
    }

    /**
     * 判断是否正在播放中
     */
    override fun isPlaying(): Boolean {
        return AudioPlayer.get().isPlaying
    }

    /**
     * 暂停播放
     */
    override fun pause(){
        AudioPlayer.get().pausePlayer()
    }

    override fun replay() {}
}