package com.yidianling.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.alibaba.android.arouter.launcher.ARouter
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.utils.Utils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.home.R
import com.yidianling.home.constants.HomeBIConstants
import com.yidianling.home.model.bean.MeditationModuleBean
import com.yidianling.user.api.service.IUserService

class MeditationTypeAdapter(
    private val context: Context,
    private val data: List<MeditationModuleBean.MeditationDetail>?,
    private val moreLink: String?,
    private val homeLink: String? = null,
    private val cateId: Long? = null,
    private val buried: String? = null,
    private val mark: Int? = null,
    private val meditationType: Int? = null
) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            CONTENT_TYPE -> {
                MeditationTypeViewHolder(
                    LayoutInflater.from(context)
                        .inflate(R.layout.home_layout_meditation_item, parent, false)
                )
            }
            else -> {
                MeditationTypeMoreViewHolder(
                    LayoutInflater.from(context)
                        .inflate(R.layout.home_layout_meditation_more_type, parent, false)
                )
            }
        }

    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {

        when (holder) {
            is MeditationTypeViewHolder -> {

                holder.ivType?.let {
                    Glide.with(context)
                        .load(data?.get(position)?.coverImageUrl)
                        .thumbnail(0.1f)
                        .transition(DrawableTransitionOptions.withCrossFade())
                        .into(it)
                }

                holder.tvName?.let {
                    it.text = data?.get(position)?.title ?: ""
                }

                holder.cvLayout?.setOnClickListener {
                    ActionCountUtils.baiDuCountSign3(
                        HomeBIConstants.YDL_USER_MAIN_PAGE_MUSE,
                        HomeBIConstants.YDL_HOME_MEDITATION_CLICK,
                        buried ?: "",
                        (position + 1).toString(),
                        ""
                    )
                    if (meditationType == 0) {
                        if (Utils.isFastClick()) {
                            //防止连击
                            return@setOnClickListener
                        }
                        if (!ModularServiceManager.provide(IUserService::class.java)
                                .loginByOneKeyLogin(context, true)
                        ) {
                            return@setOnClickListener
                        }
                        if (data == null) {
                            return@setOnClickListener
                        }
                        ARouter.getInstance().build("/muse/play")
                            .withLong("MEDITATION_ID", data[position]?.meditationId)
                            .withInt("MEDITATION_TYPE", meditationType)
                            .withFloat("MEDIA_DURATION", data[position].duration ?: 0.0f)
                            .withString("MEDIA_URL", data[position].mediaIdCoverImageUrl)
                            .withString("MEDIA_COVER_URL", data[position].mediaIdCoverImageUrl)
                            .navigation()


//                        YDLRouterManager.router(ROUTER_MUSE_PLAY,
//                            YDLRouterParams().putExtra("MEDITATION_ID" , data[position]?.meditationId.toString())
//                                .putExtra("MEDITATION_TYPE", meditationType.toString())
//                                .putExtra("MEDIA_DURATION", (data[position].duration?:0).toString())
//                                .putExtra("MEDIA_URL", data[position].mediaIdCoverImageUrl.toString())
//                                .putExtra("MEDIA_COVER_URL", data[position].mediaIdCoverImageUrl.toString()))

                    } else {
                        if (Utils.isFastClick()) {
                            //防止连击
                            return@setOnClickListener
                        }
                        if (data == null) {
                            return@setOnClickListener
                        }
                        val homeLink =
                            "${homeLink}mark=$mark&cateId=$cateId&meditationId=${data[position]?.meditationId}"
                        if (!homeLink.isNullOrBlank()) {
                            NewH5Activity.start(context, H5Params(homeLink, null))
                        }
                    }
                }
            }
            is MeditationTypeMoreViewHolder -> {
                holder.llMoreLayout?.setOnClickListener {
                    if (Utils.isFastClick()) {
                        //防止连击
                        return@setOnClickListener
                    }
                    //冥想助眠更多点击事件
                    ActionCountUtils.count(
                        HomeBIConstants.YDL_HOME_MEDITATION_VOICE_MORE_CLICK,
                        buried ?: ""
                    )

                    val moreLink = "${moreLink}mark=$mark&cateId=$cateId"
                    if (!moreLink.isNullOrBlank()) {
                        NewH5Activity.start(context, H5Params(moreLink, null))
                    }
                }
            }
        }

    }

    override fun getItemCount(): Int {
        return if (data?.isNotEmpty() == true) {
            data.size + 1
        } else {
            0
        }
    }

    override fun getItemId(position: Int) = position.toLong()

    override fun getItemViewType(position: Int): Int {
        return if (data?.isNotEmpty() == true && position == data.size) {
            FOOTER_TYPE
        } else {
            CONTENT_TYPE
        }
    }

    inner class MeditationTypeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val cvLayout: FrameLayout? = itemView.findViewById(R.id.fl_layout)
        val ivType: ImageView? = itemView.findViewById(R.id.iv_meditation_type)
        val tvName: TextView? = itemView.findViewById(R.id.tv_meditation_type)
    }

    inner class MeditationTypeMoreViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val llMoreLayout: LinearLayout? = itemView.findViewById(R.id.ll_more_type)
    }

    companion object {
        const val CONTENT_TYPE = 0
        const val FOOTER_TYPE = 1
    }


}