package com.yidianling.home.event

import android.view.View
import androidx.recyclerview.widget.RecyclerView
import com.yidianling.home.model.bean.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 首页点击事件接口类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
interface IHomeBaseEvent {

    /**
     * 服务电话点击事件
     */
    fun serviceCallClick()

    /**
     * 动态编辑按钮点击
     */
    fun publishTrendClick()

    /**
     * 咨询条目点击事件
     */
    fun consultItemClick(linkUrl: String?, doctorId: String)

    /**
     * 咨询私聊点击事件
     */
    fun consultChatClick(doctorId: String?)

    /**
     * 测试条目点击事件
     */
    fun testItemClick(linkUrl: String?)

    /**
     * 测试更多点击事件
     */
    fun testMoreClick()

    /**
     * 咨询更多点击事件
     */
    fun consultMoreClick()

    /**
     * 搜索框点击事件
     */
    fun searchTvClick(text:String)

    /**
     * 列表滚动事件
     */
    fun onPageScroll(view_rl_top_bg: View): RecyclerView.OnScrollListener?

    /**
     * 跳转链接点击
     * Banner & 首页分类 & 首页条目 使用
     */
    fun linkTo(linkUrl: String)

    /**
     * banner点击跳转
     */
    fun bannerClick(banner:HomeHeaderBean.FocusListBean)

    /**
     * 首页分类跳转
     */
    fun categoryClick(category: HomeHeaderBean.CategoryGoldListDataBean)

    /**
     * 心理咨询点击事件
     */
    fun reservationExpertsClick()

    /**
     * 即可倾诉点击事件
     */
    fun nowConfideClick(listenFree: Boolean)

    /**
     * 心理课堂点击事件
     */
    fun psychologyClassClick()

    /**
     * 心理测试点击事件
     */
    fun psychologyTestClick()

    /**
     * 倾诉更多点击事件
     */
    fun confideMoreClick()

    /**
     * 倾述咨询师点击
     * @param linkUrl 跳转地址
     */
    fun confideClick(linkUrl: String?, confideId:String, doctorId: Int, uid: String?)
    /**
     * 私聊
     */
    fun toChatForMsg(doctorId: String?)

    /**
     * 课程item点击事件
     */
    fun courseItemClick(bean: HomeCourseBean.ListBean)

    /**
     * 课程更多点击事件
     */
    fun courseMreClick()

    /**
     * 问答条目关注点击事件
     * @param id : 用户uid
     */
    fun askItemFocusClick(position:Int,id: String)

    /**
     * 问答条目点赞事件
     * @param id : 动态id
     */
    fun askItemZanClick(position:Int,index:Int,id: String)

    /**
     * 问答更多点击事件
     */
    fun askMoreClick()

    /**
     * 问答条目点击事件
     */
    fun askItemClick(bean:HomeAskBean.DataBean)

    /**
     * 电台条目点击播放事件
     */
    fun fmPlayClick(bean: HomeFMBean.ListBean)

    /**
     * 电台条目点击进入详情
     */
    fun fmItemClick(bean: HomeFMBean.ListBean)

    /**
     * 电台更多点击事件
     */
    fun fmMoreClick()

    /**
     * 文章更多点击事件
     */
    fun articleMoreClick()

    /**
     * 文章item点击事件
     */
    fun articleItemClick(bean: HomeArticleBean.Bean?)

    /**
     * 获取倾述列表数据
     * 最终调用
     * @see com.yidianling.home.ui.fragment.YdlHomeFragment.getConfideData
     *
     * @param type 倾述类型
     * @param selectPosition 选中的position
     */
    fun getConfideData(type: HomeHeaderBean.ListenCategoryDateBean, selectPosition: Int)

    /**
     * 获取咨询列表数据
     * 最终调用
     * @see com.yidianling.home.ui.fragment.YdlHomeFragment.getConsultData
     *
     * @param type 类型
     * @param selectPosition 选中的position
     */
    fun getConsultData(type: HomeHeaderBean.ConsultCategoryDateBean, selectPosition: Int)

    /*
    * 跳转话题详情
    *
    * */
    fun jumpToTopicDetail(topic_id:String)
}