package com.yidianling.home.http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.router.YdlCommonOut
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.home.model.bean.*
import com.yidianling.user.api.service.IUserService
import io.reactivex.Observable

class HomeBaseHttp {
    open var consultListSize: String="3"
    open var confideListSize: String="3"
    open var courseListSize: String="3"
    open var articleListSize: String="4"
    open var fmListSize: String="4"
    open var dynamicListSize: String="6"
    
    companion object {
        fun getInstance(): HomeBaseHttp {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = HomeBaseHttp()
    }

    private var homeApi: HomeBasePagerApi? = null

    fun getHomePagerApi(): HomeBasePagerApi {
        if (homeApi == null) {
            homeApi = YDLHttpUtils.obtainApi(HomeBasePagerApi::class.java)
        }
        return homeApi!!
    }

    //首页头部 分类&Banner 请求
    fun newHomeHeaderRequest(): Observable<BaseAPIResponse<HomeHeaderBean>> {
        return getHomePagerApi().getHomeHeaderData(2)
    }

    //首页倾述请求
    fun getConfideData(goodType: String): Observable<BaseAPIResponse<HomeConfideBean>> {
        val loginBean = ModularServiceManager.provide(IUserService::class.java).getUserInfo()
        var userId = loginBean?.uid ?: "";
        return getHomePagerApi().getConfideData(goodType, uid = userId,limit = confideListSize);
    }

    //首页课程请求
    fun getCourseData(listType: String = "10"): Observable<BaseAPIResponse<HomeCourseBean>> {
        val loginBean = ModularServiceManager.provide(IUserService::class.java).getUserInfo()
        var userId = loginBean?.uid ?: "";
        return getHomePagerApi().getCourseData(listType, uid = userId,limit = courseListSize);
    }

    //首页测试请求
    fun getTestData(): Observable<BaseAPIResponse<MutableList<HomeTestItemBean>>> {
        val loginBean = ModularServiceManager.provide(IUserService::class.java).getUserInfo()
        var userId = loginBean?.uid ?: "";
        return getHomePagerApi().getTestData(uid = userId)
    }

    //首页问答请求
    fun getAskData(): Observable<BaseAPIResponse<HomeAskBean>> {
        val loginBean = ModularServiceManager.provide(IUserService::class.java).getUserInfo()
        var userId = loginBean?.uid ?: "";
        var token = loginBean?.accessToken ?: "";
        return getHomePagerApi().getAskData(accessToken = token, uid = userId,perPageRows = dynamicListSize);
    }

    //首页电台请求
    fun getFMData(): Observable<BaseAPIResponse<HomeFMBean>> {
        return getHomePagerApi().getFMData(perPageRows = fmListSize);
    }

    //首页文章请求
    fun getArticleData(): Observable<BaseAPIResponse<HomeArticleBean>> {
        articleListSize = if (YdlCommonOut.getApp().packageName == "com.cxzapp.xinlizixun") "6" else "3"
        return getHomePagerApi().getArticleData(perPageRows = articleListSize)
    }

    //首页咨询请求
    fun getConsultData(goodType: String): Observable<BaseAPIResponse<HomeConsultBean>> {
        val loginBean = ModularServiceManager.provide(IUserService::class.java).getUserInfo()
        var userId = loginBean?.uid ?: ""
        consultListSize = if (YdlCommonOut.getApp().packageName == "com.cxzapp.xinlizixun") "4" else "3"
        return getHomePagerApi().getConsultData(category = goodType, uid = userId,limit = consultListSize)
    }

    //首页问答 - 点赞
    fun askZan(id: String): Observable<BaseResponse<AskResultBean>> {
        val cmd = AskRequestParamBean.ZanAction("2", id)
        return RxUtils.mapObservable(cmd).flatMap { getHomePagerApi().askZan(it) }
    }

    //首页问答 - 关注
    fun askFocus(id: String): Observable<BaseResponse<AskResultBean>> {
        val cmd = AskRequestParamBean.FocusCmd(id, "1")
        return RxUtils.mapObservable(cmd).flatMap { getHomePagerApi().askFocus(it) }
    }

    fun getMeditationInfo(): Observable<BaseAPIResponse<MeditationModuleBean>> {
        return getHomePagerApi().getMeditation()
    }
}