package com.yidianling.home.view

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Color
import android.graphics.Typeface
import android.media.MediaPlayer
import android.text.SpannableString
import android.text.Spanned
import android.text.style.StyleSpan
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayoutMediator
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.utils.Utils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.home.adapter.MeditationViewPagerAdapter
import com.yidianling.home.R
import com.yidianling.home.constants.HomeBIConstants
import com.yidianling.home.model.bean.MeditationModuleBean
import kotlinx.android.synthetic.main.home_muse_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 冥想模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/09/10
 */
class HomeMuseView(private val mContext: Context) :
    LinearLayout(mContext) {

    private val meditationTitles = mutableListOf<String>()

    init {
        initView()
    }

    @SuppressLint("RestrictedApi")
    private fun initView() {
        orientation = VERTICAL
        val params = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_muse_view, this)
        homeModuleMuseViewHomeCommonTitleView.setTitle("助眠·冥想")
    }

    fun initData(bean: MeditationModuleBean?) {

        if (null != bean) {

            val moreLink = bean.mditationIndexInfo?.upperFloorMore

            homeModuleMuseViewHomeCommonTitleView.setOnClickListener {

                if (Utils.isFastClick()) {
                    //防止连击
                    return@setOnClickListener
                }
                //冥想助眠更多点击事件
                ActionCountUtils.count(HomeBIConstants.YDL_HOME_MEDITATION_MORE_CLICK)
                if (!moreLink.isNullOrBlank()) {
                    NewH5Activity.start(context, H5Params(moreLink, null))
                }

            }

            fl_layout?.setOnClickListener {

                if (Utils.isFastClick()) {
                    //防止连击
                    return@setOnClickListener
                }
                //冥想助眠更多点击事件
                ActionCountUtils.count(HomeBIConstants.YDL_HOME_MEDITATION_MORE_CLICK)
                if (!moreLink.isNullOrBlank()) {
                    NewH5Activity.start(context, H5Params(moreLink, null))
                }

            }


            val greeting = bean.mditationIndexInfo?.greetings ?: "你好"
            tv_time.text = greeting
            val slogan =
                if (bean.mditationIndexInfo?.desc.isNullOrBlank()) {
                    "无常的日子里，呼吸间拾起力量"
                } else {
                    bean.mditationIndexInfo?.desc
                }
            tv_meditation_slogan.text = slogan

            val videoUrl = bean.mditationIndexInfo?.videoLink

            video_view?.setVideoPath(videoUrl)
            video_view?.setOnErrorListener { mp, what, extra ->
                true
            }
            video_view?.setOnPreparedListener {
                it?.setVideoScalingMode(MediaPlayer.VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING)
                video_view?.setOnInfoListener { mp, what, extra ->
                    if (what == MediaPlayer.MEDIA_INFO_VIDEO_RENDERING_START) {
                        video_view.setBackgroundColor(Color.TRANSPARENT)
                    }
                    true
                }
                it?.start()
                it?.setVolume(0.0F, 0.0F)
            }


            video_view?.setOnCompletionListener { video_view?.start() }

            bean.mditationListResponse?.forEach {
                meditationTitles.add(it.comment)
            }

            view_pager.isUserInputEnabled = false
            view_pager.adapter = MeditationViewPagerAdapter(mContext, bean)

            tab_layout.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
                override fun onTabSelected(tab: TabLayout.Tab?) {
                    //冥想|声音|睡眠点击事件
                    ActionCountUtils.count(HomeBIConstants.YDL_HOME_MEDITATION_SUBJECT_CLICK,
                        tab?.let { bean?.mditationListResponse?.get(it.position)?.buried } ?:"")

                    var text: String? = tab?.text.toString().trim()
                    val spStr = SpannableString(text)
                    val styleSpan = StyleSpan(Typeface.BOLD)
                    spStr.setSpan(styleSpan, 0, text?.length ?: 0, Spanned.SPAN_INCLUSIVE_EXCLUSIVE)
                    tab?.text = spStr
                }

                override fun onTabUnselected(tab: TabLayout.Tab?) {
                    var text: String? = tab?.text.toString().trim()
                    val spStr = SpannableString(text)
                    val styleSpan = StyleSpan(Typeface.NORMAL)
                    spStr.setSpan(styleSpan, 0, text?.length ?: 0, Spanned.SPAN_INCLUSIVE_EXCLUSIVE)
                    tab?.text = spStr
                }

                override fun onTabReselected(tab: TabLayout.Tab?) {

                }

            })

            TabLayoutMediator(tab_layout, view_pager) { tab, position ->
                tab.text = meditationTitles[position]
            }.attach()

        }
    }

}