package com.yidianling.home.constract

import android.app.Activity
import android.content.Context
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.home.constants.IHomeBaseContract
import com.yidianling.home.model.bean.*
import io.reactivex.Observable

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 心理咨询首页约束类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class IHomeContract {

    interface View : IHomeBaseContract.View {

        /**
         * 获取优惠券数据回调
         */
        fun couponDataResponse(data: List<CouponBean>)

        /**
         * 领取优惠券回调
         */
        fun receiveCouponResponse(data: BaseResponse<Any>)

        /**
         * 领取优惠券
         */
        fun receiveCoupon(data: List<CouponBean>)
    }

    interface Presenter : IHomeBaseContract.Presenter<View> {

        /**
         * 获取优惠券信息
         */
        fun prepareCoupon(activity: Activity)

        /**
         * 领取优惠券
         */
        fun receiveCoupon(list:List<CouponBean>)

    }

    interface Model: IHomeBaseContract.Model {
        /**
         * 领取优惠券
         */
        fun receiveCoupon(uid: String, couponIds: String): Observable<BaseResponse<Any>>

        /**
         * 获取优惠券
         */
        fun getCoupons(uid: String): Observable<BaseResponse<List<CouponBean>>>

        fun getMeditation(): Observable<MeditationModuleBean>
    }
}