package com.yidianling.home.event

import android.content.Context
import android.graphics.drawable.AnimationDrawable
import android.widget.ImageView
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.media.audio.AudioPlayer
import com.ydl.media.audio.model.Music
import com.ydl.media.view.PlayTypeEnum
import com.ydl.media.view.PlayerFloatHelper
import com.ydl.media.view.PlayerFloatView
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.yidianling.home.constract.IHomeContract
import com.yidianling.home.model.bean.CouponBean
import com.yidianling.home.model.bean.HomeConfideBean
import com.yidianling.home.ui.view.CouponDialog


/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 首页点击事件实现类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeImpl(context: Context, homeView: IHomeContract.View) : HomeBaseImpl(context, homeView), IHomeEvent {
    private var lastVoiceView: ImageView? = null
    private var floatViewClickListener: PlayerFloatView.FloatViewPlayListener? = null

    override fun clickEnsure(list: List<CouponBean>): CouponDialog.OnClickEnsureListener {
        return object : CouponDialog.OnClickEnsureListener {
            override fun clickEnsure(status: Int) {
                //立即领取
                if (status == CouponDialog.STATUS_RECEIVER) {
                    mHomeView?.receiveCoupon(list)
                }
                //查看我的卡券
                if (status == CouponDialog.STATUS_GET) {
                    ARouter.getInstance().build(IYDLRouterConstant.ROUTER_MINE_REDPACKET)
                            .withString("is_from_main", "1")
                            .navigation()
                }
            }
        }
    }

    override fun confidePlayClick(voiceView: ImageView, bean: HomeConfideBean.BodyBean) {
        val music = Music()
        music.title = bean.confidedName
        music.coverPath = bean.confidedIcon
        music.path = bean.confideVoice
        AudioPlayer.get().singlePlay(music, false)
        PlayerFloatHelper.playingType = PlayTypeEnum.PLAY_TYPE_CONFIDE

        if (PlayerFloatHelper.isShow()) {
            if (PlayerFloatHelper.playingType == PlayTypeEnum.PLAY_TYPE_CONFIDE) {
                PlayerFloatHelper.removeView()

                PlayerFloatHelper.show(mContext!!)
            } else {
                PlayerFloatHelper.setPlayingState(mContext!!)
            }
        } else {
            mContext?.let { PlayerFloatHelper.show(it) }
        }
        stopPlayAnim()

        var animationDrawable = voiceView?.getDrawable() as AnimationDrawable
        animationDrawable.start()
        lastVoiceView = voiceView

        if (floatViewClickListener == null) {
            floatViewClickListener = object : PlayerFloatView.FloatViewPlayListener {
                override fun onStartClick() {
                    startPlayAnim()
                }

                override fun onPlayFinish() {
                    stopPlayAnim()

                    if (PlayerFloatHelper.isShow()) {
                        PlayerFloatHelper.removeResetView()
                    }
                }

                override fun onPauseClick() {
                    stopPlayAnim()
                }

            }

            PlayerFloatHelper.addClickListener(floatViewClickListener as PlayerFloatView.FloatViewPlayListener)
        }
    }

    private fun stopPlayAnim() {
        if (lastVoiceView != null) {
            var animationDrawable = lastVoiceView?.getDrawable() as AnimationDrawable
            animationDrawable.stop()
            animationDrawable.selectDrawable(3);
        }
    }

    private fun startPlayAnim() {
        if (lastVoiceView != null) {
            var animationDrawable = lastVoiceView?.getDrawable() as AnimationDrawable
            animationDrawable.start()
        }
    }

}


