package com.yidianling.home.http

import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.home.model.bean.*
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * @author jiucheng
 * @描述:首页接口实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
class HomeHttp private constructor() {

    companion object {
        fun getInstance(): HomeHttp {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = HomeHttp()
    }

    private var homePagerApi: HomePagerApi? = null

    private fun getHomePagerApi(): HomePagerApi {
        if (homePagerApi == null) {
            homePagerApi = YDLHttpUtils.obtainApi(HomePagerApi::class.java)
        }
        return homePagerApi!!
    }

    //领取优惠券
    fun receiveCoupon(uid: String, couponIds: String): Observable<BaseResponse<Any>> {
        val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), couponIds)
        return getHomePagerApi().receiveCoupon(uid, body)
    }

    //获取优惠券
    // applyUsers 用户
    // applyEnds 用户版
    fun getCoupons(uid: String): Observable<BaseResponse<List<CouponBean>>> {
        return getHomePagerApi().getCoupons(uid, "1", "3")
    }




}