package com.yidianling.home.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA_URL
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.home.model.bean.CouponBean
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * @author jiucheng
 * @描述:首页接口api
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
interface HomePagerApi {

    //领取优惠券
    @POST("marketing/coupon/{uid}/receive")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA_URL)
    fun receiveCoupon(@Path("uid") uid: String, @Body body: RequestBody): Observable<BaseResponse<Any>>

    //获取优惠券
    @GET("marketing/coupon/{uid}/obtain")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA_URL)
    fun getCoupons(
        @Path("uid") uid: String, @Query("applyUsers") applyUsers: String, @Query(
            "applyEnds"
        ) applyEnds: String
    ): Observable<BaseResponse<List<CouponBean>>>
}