package com.yidianling.home.ui.view

import android.content.Context
import androidx.constraintlayout.widget.ConstraintLayout
import android.util.AttributeSet
import android.view.View
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import kotlinx.android.synthetic.xlzx.home_common_title_big_full_view.view.*

/**
 * @author liupneg
 * @描述: 首页通用标题，富文本样式
 * @Company 壹点灵
 */
class HomeCommonTitleBigFullView(private val mContext: Context, private val attributeSet: AttributeSet) :
    ConstraintLayout(mContext, attributeSet) {

    init {
        initView()
    }

    private fun initView() {
        View.inflate(mContext, R.layout.home_common_title_big_full_view, this)
    }

    fun setTitle(title: String) {
        homeModuleCommonTitleViewFullTitle.text = title
    }

    fun setMoreText(text: String) {
        homeModuleCommonTitleViewMorell.visibility = View.VISIBLE
        homeModuleCommonTitleViewMoreText.text = text
    }

    fun setTopMargin(topMargin: Int) {
        val params = layoutParams as MarginLayoutParams
        params.topMargin = RxImageTool.dp2px(topMargin.toFloat())
        layoutParams = params
    }
}