package com.yidianling.home.ui.view

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Paint
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.ydl.ydl_image.config.SimpleImageOpConfiger
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.HomeImpl
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.event.IHomeEvent
import com.yidianling.home.model.bean.HomeConfideBean
import kotlinx.android.synthetic.xlzx.home_confide_expert_info_view.view.*


/**
 * @author jiucheng
 * @描述:首页倾诉模块--专家个人信息view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/16
 */
class HomeConfideExpertInfoView(
    private var mContext: Context,
    private var homeEvent: HomeImpl?
) : FrameLayout(mContext) {
    private var dp70 = 0

    init {
        initView()

        dp70 = RxImageTool.dip2px(70f)
    }

    private fun initView() {
        var params = FrameLayout.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(context, R.layout.home_confide_expert_info_view, this)
    }

    fun setData(bean: HomeConfideBean.BodyBean?, position: Int, isLast: Boolean) {
        if (bean == null) {
            visibility = View.GONE
            return
        }
        //设置头像
        setHead(bean)
        //设置名称
        tv_name.text = bean.confidedName
        //设置倾诉标签View的最大宽度
        tag_view.setConfideWidth()
        //咨询师标签
        tag_view.initData(bean.confidedTag as MutableList<String>)
        //设置向TA倾诉人数
        setConfideNum(bean)
        //设置接通率文案
        setConnection(bean)
        //设置向TA倾诉按钮状态
        setConfideButton(bean)
        //设置红包、原价
        setCoupon(bean)
        //最后一项显示分割线
        if (isLast) {
            view_line.visibility = View.GONE
        } else {
            view_line.visibility = View.VISIBLE
        }
        this.setOnClickListener {
            homeEvent?.confideClick(bean.linkUrl, bean.confidedId.toString(), bean.doctorId, bean.uid.toString())
        }

        iv_confide_voice.setOnClickListener {
            homeEvent?.confidePlayClick(iv_confide_voice, bean)
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bean: HomeConfideBean.BodyBean) {
        val op = SimpleImageOpConfiger()
        op.errorPic = R.drawable.platform_head_place_hold_pic
        op.loadingPic = R.drawable.platform_head_place_hold_pic
        op.transform = 0
        YDLImageCacheManager.showImage(mContext, bean.confidedIcon, img_head, op)
    }

    /**
     * 设置向TA倾诉人数
     */
    private fun setConfideNum(bodyBean: HomeConfideBean.BodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideNum)) {
            tv_confideNum.visibility = View.GONE
            tv_tv_confideNumContent.visibility = View.GONE
        } else {
            tv_confideNum.visibility = View.VISIBLE
            tv_tv_confideNumContent.visibility = View.VISIBLE
            if (bodyBean.confideNum?.indexOf("人") != -1) {
                bodyBean.confideNum =
                    bodyBean.confideNum?.substring(0, bodyBean.confideNum?.length!! - 1)
            }
            tv_confideNum.text = bodyBean.confideNum
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: HomeConfideBean.BodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideConnection)) {
            tv_Connection.visibility = View.INVISIBLE
            tv_ConnectionContent.visibility = View.INVISIBLE
        } else {
            tv_Connection.visibility = View.VISIBLE
            tv_ConnectionContent.visibility = View.VISIBLE
            tv_Connection.text = bodyBean.confideConnection
        }
    }

    /**
     * 设置向TA倾诉按钮状态
     */
    private fun setConfideButton(bodyBean: HomeConfideBean.BodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中  4继续倾诉
            1 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_1)
            }
            2 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_2)
            }
            3 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_3)
            }
            4 -> {
                tv_confide.setBackgroundResource(R.drawable.home_confide_line_4)
            }
        }
        tv_confide.setOnClickListener {
            if (bodyBean.confideLine == 2) {//喊他上线  私聊
                homeEvent!!.toChatForMsg(bodyBean.uid.toString())
            } else {
                homeEvent!!.confideClick(bodyBean.linkUrl, bodyBean.confidedId.toString(), bodyBean.doctorId, bodyBean.uid.toString())
            }
        }
    }

    /**
     * 设置红包、原价
     */
    @SuppressLint("SetTextI18n")
    private fun setCoupon(bodyBean: HomeConfideBean.BodyBean) {
        if (bodyBean.couponMoney.toFloat().toInt() <= 0) {//优惠金额
            tvCoupon.visibility = View.GONE
            tvOriginalPrice.visibility = View.GONE
            tv_price.text = "¥${bodyBean.confideFee}"
        } else {
            val couponMoney = bodyBean.couponMoney.toFloat().toInt()
            val confideFee = bodyBean.confideFee.toFloat().toInt()
            val sb = StringBuilder()
            sb.append("立减").append(couponMoney).append("元")
            tvCoupon.text = sb.toString()
            tvCoupon.visibility = View.VISIBLE
            tvOriginalPrice.visibility = View.VISIBLE
            val originalBuffer = StringBuilder()
            originalBuffer.append("原价¥").append(bodyBean.confideFee)
            tvOriginalPrice.text = originalBuffer.toString()
            //添加删除线
            tvOriginalPrice.paint.flags = Paint.STRIKE_THRU_TEXT_FLAG
            if (couponMoney >= confideFee) {
                tv_price.text = "¥0"
            } else {
                val price = confideFee - couponMoney
                tv_price.text = "¥$price"
            }
        }
    }
}
