package com.yidianling.home.ui.widget

import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.utils.ScreenUtil
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import com.yidianling.home.ui.view.HomePagerBannerRealView
import kotlinx.android.synthetic.xlzx.home_pager_banner_category_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 首页顶部模块-分类模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/16
 */
class HomeModuleCategoryView : FrameLayout {

    /**
     * 数据缓存
     */
    var mDataList: ArrayList<HomeHeaderBean.CategoryGoldListDataBean>? = null

    /**
     * 分类view宽度
     */
    var categoryWidth: Int = 0
    /**
     * 图片宽高
     */
    var imageViewWidth: Int = 0
    /**
     * 文本宽度
     */
    var imageViewHeight: Int = 0
    /**
     * 间隔
     */
    var margin: Int = 0
    /**
     * 八个的时候文本宽度
     */
    var textViewWidth: Int = 0
    /**
     * 八个的时候文本高度
     */
    var textViewHeight: Int = 0
    /**
     * 八个时候分类宽度
     */
    var categoryEightWidth: Int = 0
    /**
     * 八个时候分类宽度
     */
    var imageEightViewWidth: Int = 0

    var dp1: Int = 0
    var dp3: Int = 0
    var dp6: Int = 0
    var dp8: Int = 0
    var dp12: Int = 0
    //左右间距
    var dp15: Int = 0
    /**
     * 倍数
     */
    private var multiple: Int = 0
    /**
     * 测评首页事件处理类
     */
    private var homeEvent: IHomeBaseEvent? = null

    constructor(context: Context?) : super(context) {
        HomeModuleCategoryView(context, null)
    }

    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs) {
        initView();
    }

    fun setEvent(homeEvent: IHomeBaseEvent) {
        this.homeEvent = homeEvent
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.home_pager_banner_category_view, this)
        val params = LayoutParams(
            LayoutParams.MATCH_PARENT,
            LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        initArgs()
    }

    /**
     * 初始化变量
     */
    private fun initArgs() {
        categoryWidth = ScreenUtil.screenWidth - RxImageTool.dp2px(12f + 3f + 3f + 12f)
        imageViewWidth = categoryWidth / 3
        imageViewHeight = imageViewWidth * 52 / 107
        dp1 = RxImageTool.dip2px(1f)
        dp3 = RxImageTool.dip2px(3f)
        dp6 = RxImageTool.dip2px(4f)
        dp12 = RxImageTool.dip2px(12f)

        categoryEightWidth = ScreenUtil.screenWidth - RxImageTool.dp2px(8f)
        textViewWidth = categoryEightWidth / 4
        imageEightViewWidth = RxImageTool.dip2px(38f)
        textViewHeight = RxImageTool.dip2px(28f)
        margin = (categoryEightWidth - 4 * imageEightViewWidth) / 8
        dp8 = RxImageTool.dip2px(8f)
        dp15 = RxImageTool.dip2px(4f)
    }

    fun initData(askCategoryDataBean: List<HomeHeaderBean.CategoryGoldListDataBean>?) {
        if (null == askCategoryDataBean || askCategoryDataBean.isEmpty()) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        if (null == mDataList) {
            mDataList = ArrayList()
        }
        if (getChange(askCategoryDataBean, mDataList)) {
            mDataList!!.clear()
            mDataList!!.addAll(askCategoryDataBean)
        }
        refreshView()
    }

    /**
     * 判断数据是否变化
     */
    private fun getChange(
        bean: List<HomeHeaderBean.CategoryGoldListDataBean>?,
        cacheBean: List<HomeHeaderBean.CategoryGoldListDataBean>?
    ): Boolean {
        if (bean?.size != cacheBean?.size) {
            return true
        }
        for (index in 0 until bean?.size!!) {
            if (!bean[index].icon.equals(cacheBean!![index].icon)
                || !bean[index].title.equals(cacheBean!![index].title)
                || bean[index].id != cacheBean!![index].id
            ) {
                return true
            }
        }
        return false
    }

    /**
     * 刷新View
     */
    private fun refreshView() {
        homeModulePagerBannerFlRoot.removeAllViews()
        var i = 0
        // 后端没资源，Android自己做兼容，复原原来的代码
        mDataList?.let {
            if (mDataList?.size!! >= 8) {
                for (item in mDataList!!) {
                    if (i > 7) {
                        break
                    }
                    val imageView = createEightIcon(i)
                    val textView = createText(i)

                    homeModulePagerBannerFlRoot.addView(imageView)
                    homeModulePagerBannerFlRoot.addView(textView)

                    imageView.setOnClickListener {
                        homeEvent!!.categoryClick(item)
                    }
                    textView.setOnClickListener {
                        homeEvent!!.categoryClick(item)
                    }
                    bindIconData(imageView, item)
                    bindTextData(textView, item)
                    i++
                }
            } else if (mDataList?.size!! == 6) {
                for (item in mDataList!!) {
                    if (i > 5) {
                        break
                    }
                    val imageView = createSixIcon(i)

                    homeModulePagerBannerFlRoot.addView(imageView)

                    imageView.setOnClickListener {
                        homeEvent!!.categoryClick(item)
                    }

                    bindIconData(imageView, item)
                    i++
                }
            }
        }
    }

    /**
     * 创建图标
     */
    private fun createSixIcon(i: Int): ImageView {
        val imageParams = LayoutParams(imageViewWidth, imageViewHeight)
        val imageView = ImageView(context)
        imageView.scaleType = ImageView.ScaleType.CENTER_CROP

        if (i > 2) {
            //第二行
            imageParams.topMargin = imageViewHeight + dp1
            imageParams.leftMargin = dp12 + dp3 * (i - 3) + imageViewWidth * (i - 3)
        } else {
            //第一行
            imageParams.topMargin = 0
            imageParams.leftMargin = dp12 + dp3 * i + imageViewWidth * i
        }
        imageView.layoutParams = imageParams
        return imageView
    }

    /**
     * 创建图标
     */
    private fun createEightIcon(i: Int): ImageView {
        val imageParams = FrameLayout.LayoutParams(imageEightViewWidth, imageEightViewWidth)
        val imageView = ImageView(context)
        imageView.scaleType = ImageView.ScaleType.CENTER_CROP

        if (i > 3) {
            multiple = 2
            imageParams.topMargin =
                imageEightViewWidth + dp8 + textViewHeight + dp8 + RxImageTool.dip2px(1f) - dp3 - dp1 - dp1 - dp1 - dp1
            imageParams.leftMargin = dp15 + margin * (i - 3) + (i - 4) * (imageEightViewWidth + margin)
        } else {
            multiple = 1
            imageParams.topMargin = (dp8 + dp3 - dp6 - dp1 - dp1)
            imageParams.leftMargin = dp15 + margin * (i + 1) + i * (imageEightViewWidth + margin)
        }
        imageView.layoutParams = imageParams

        return imageView
    }

    /**
     * 创建文本
     */
    private fun createText(index: Int): TextView {
        val textParams = FrameLayout.LayoutParams(textViewWidth, LayoutParams.WRAP_CONTENT)
        val textView = TextView(context)
        textView.setTextColor(Color.parseColor("#666666"))

        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12f)
        textView.gravity = Gravity.CENTER_HORIZONTAL
        if (index > 3) {
            textParams.topMargin = 2 * (imageEightViewWidth + dp8) + textViewHeight + dp8 - dp3 - dp3 - dp1 - dp1 - dp1 - dp1
            textParams.leftMargin = dp15 + textViewWidth * (index - 4)
        } else {
            textParams.topMargin = imageEightViewWidth + (dp8 + dp3 - dp6) + dp8 - dp3 - dp1 - dp1
            textParams.leftMargin = dp15 + textViewWidth * (index)
        }
        textView.layoutParams = textParams

        return textView
    }

    /**
     * 设置文本
     */
    private fun bindTextData(
        textView: TextView,
        categoryBean: HomeHeaderBean.CategoryGoldListDataBean
    ) {
        textView.text = categoryBean.title
    }

    /**
     * 加载图片
     */
    private fun bindIconData(
        imageView: ImageView,
        categoryBean: HomeHeaderBean.CategoryGoldListDataBean
    ) {
        GlideApp.with(context).load(categoryBean.icon)
            .centerCrop().into(imageView)
    }
}