package com.yidianling.home.listener

import android.content.Context
import android.util.Log
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.tabs.TabLayout
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.adapter.YdlHomeAdapter
import com.yidianling.home.constract.HomeViewConfig
import com.yidianling.home.constract.IHomeContract

/**
 * @author yuanwai
 * @描述:悬浮按钮监听事件
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/25
 */
class HomeConfideRecyleSuspendListener : RecyclerView.OnScrollListener() {

    private var mContext: Context? = null

    private var mCurrentPosition = 0

    private var mSuspensionHeight: Int = RxImageTool.dip2px(51f)
    //倾诉筛选layout
    private var confideFilterView: LinearLayout? = null
    //咨询筛选layout
    private var consultFilterView: LinearLayout? = null
    //首页界面View接口
    private var mHomeView: IHomeContract.View? = null

    private var adapter: YdlHomeAdapter? = null

    private var mPhoneCallView: ImageView? = null
    //是否执行收缩动画
    private var excuteStartAnim: Boolean = true
    //是否执行展开动画
    private var excuteEndAnim: Boolean = true

    private var dp5: Int = 0
    private var dp14: Int = 0
    private var dp15: Int = 0
    private var dp34: Int = 0
    private var cvWidth: Int = 0
    private var maxCVWidth: Int = 0
    private var minCVWidth: Int = 0

    init {
        dp5 = RxImageTool.dip2px(5f)
        dp14 = RxImageTool.dip2px(14f)
        dp15 = RxImageTool.dip2px(15f)
        dp34 = RxImageTool.dip2px(34f)
    }

    fun setContext(context: Context) {
        mContext = context
        cvWidth = RxDeviceTool.getScreenWidth(context) - RxImageTool.dip2px(73f)
        minCVWidth = RxImageTool.dip2px(105f)
        maxCVWidth = cvWidth
    }

    fun setHomeView(homeView: IHomeContract.View) {
        this.mHomeView = homeView
    }

    fun setConfideFilterView(filterView: LinearLayout) {
        this.confideFilterView = filterView
    }

    fun setConsultFilterView(filterView: LinearLayout) {
        this.consultFilterView = filterView
    }

    fun setSectionAdapter(adapter: YdlHomeAdapter) {
        this.adapter = adapter
    }

    fun setPhoneCallImageView(callView: ImageView) {
        this.mPhoneCallView = callView
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        super.onScrollStateChanged(recyclerView, newState)
        if (null != confideFilterView) {
            mSuspensionHeight = confideFilterView!!.height
        }
    }

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
        if (null == adapter) {
            return
        }
        Log.e("Tag", "-------dy=$dy")
//        moveSearchView(dy)
        val manager = recyclerView.layoutManager as LinearLayoutManager
        if (mCurrentPosition != manager.findFirstVisibleItemPosition() && manager.findFirstVisibleItemPosition() != -1) {
            mCurrentPosition = manager.findFirstVisibleItemPosition()
        }
        if (adapter!!.getItemViewType(mCurrentPosition) == HomeViewConfig.getOrder().confideIndex) {
            val view = manager.findViewByPosition(mCurrentPosition)
            if (view != null) {
                if (view is ViewGroup) {
                    if (view.childCount > 1 && view.getChildAt(1) is TabLayout) {
                        val tabLayout = view.getChildAt(1)
                        val location = IntArray(2)
                        tabLayout.getLocationOnScreen(location)
                        if (location[1] - RxImageTool.dip2px(40f) <= mSuspensionHeight) {
                            confideFilterView!!.visibility = View.VISIBLE
                        } else {
                            confideFilterView!!.visibility = View.INVISIBLE
                        }
                    }
                }
            }

            val nextView = manager.findViewByPosition(mCurrentPosition + 1)
            if (nextView != null) {
                if (nextView.top <= (mSuspensionHeight + RxImageTool.dip2px(41f))) {
                    confideFilterView!!.visibility = View.INVISIBLE
                }
            }
        } else if (adapter!!.getItemViewType(mCurrentPosition) == HomeViewConfig.getOrder().consultIndex) {
            val view = manager.findViewByPosition(mCurrentPosition)
            if (view != null) {
                if (view is ViewGroup) {
                    if (view.getChildAt(1) is TabLayout) {
                        val tabLayout = view.getChildAt(1)
                        val location = IntArray(2)
                        tabLayout.getLocationOnScreen(location)
                        if (location[1] - RxImageTool.dip2px(40f) <= mSuspensionHeight) {
                            consultFilterView?.visibility = View.VISIBLE
                        } else {
                            consultFilterView?.visibility = View.INVISIBLE
                        }
                    }
                }
            }

            val nextView = manager.findViewByPosition(mCurrentPosition + 1)
            if (nextView != null) {
                if (nextView.top <= (mSuspensionHeight + RxImageTool.dip2px(41f))) {
                    consultFilterView!!.visibility = View.INVISIBLE
                }
            }
        } else if (adapter!!.getItemViewType(mCurrentPosition) == HomeViewConfig.getOrder().buttonIndex) {
            if (excuteStartAnim) {
                mHomeView?.startAnim()
                excuteStartAnim = false
                excuteEndAnim = true
            }
            confideFilterView?.visibility = View.INVISIBLE
            consultFilterView?.visibility = View.INVISIBLE
        } else if (adapter!!.getItemViewType(mCurrentPosition) == HomeViewConfig.getOrder().bannerIndex) {
            if (excuteEndAnim) {
                mHomeView?.endAnim()
                excuteEndAnim = false
                excuteStartAnim = true
            }
            confideFilterView?.visibility = View.INVISIBLE
            consultFilterView?.visibility = View.INVISIBLE
        } else {
            confideFilterView?.visibility = View.INVISIBLE
            consultFilterView?.visibility = View.INVISIBLE
        }
    }

    /**
     * 移动搜索View
     */
    private fun moveSearchView(dy: Int) {
//        if (null != mCardView){
//            cvWidth -= dy
//            if (cvWidth < minCVWidth){
//                cvWidth = minCVWidth
//                mPhoneCallView?.visibility = View.GONE
//            }else if (cvWidth > maxCVWidth){
//                cvWidth = maxCVWidth
//                mPhoneCallView?.visibility = View.VISIBLE
//            }else{
//                mPhoneCallView?.visibility = View.VISIBLE
//            }
//            val params = RelativeLayout.LayoutParams(cvWidth,dp34)
//            params.setMargins(dp15,dp14,dp15,dp5)
//            mCardView?.layoutParams = params
//        }
    }
}