package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.widget.LinearLayout
import androidx.cardview.widget.CardView
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.yidianling.common.tools.RxDeviceTool
import kotlinx.android.synthetic.ydl.home_assuage_grief_image_more_five_item_view.view.*
import kotlinx.android.synthetic.ydl.home_assuage_grief_image_under_four_item_view.view.*
import kotlinx.android.synthetic.ydl.home_assuage_grief_image_under_two_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 解忧*问答模块内部图片模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/15
 */
class HomeAssuageGriefImageItemView(private val mContext: Context, private val urlList: List<String>, private var homeEvent: IHomeBaseEvent?) : CardView(mContext) {

    init {
        initView()
    }

    private fun initView() {
        radius = 4f
        cardElevation = 0f
        var screenWidth = RxDeviceTool.getScreenWidth(mContext)
        var viewWidth = (screenWidth - 2 * 30 * RxDeviceTool.getScreenDensity(mContext)).toInt()
        var params: LinearLayout.LayoutParams?

        //根据图片的数量，加载不同的图片布局
        if (urlList.size <= 2) {
            var viewHeight = viewWidth * 178 / 315
            params = LinearLayout.LayoutParams(viewWidth, viewHeight)
            params.bottomMargin = (20 * RxDeviceTool.getScreenDensity(mContext)).toInt()
            layoutParams = params
            View.inflate(mContext, R.layout.home_assuage_grief_image_under_two_item_view, this)

            YDLImageCacheManager.showImage(mContext, urlList[0], homeModuleAssuageGriefUnderTwoItemViewImg)

        } else if (urlList.size <= 4) {
            var viewHeight = viewWidth * 178 / 315
            params = LinearLayout.LayoutParams(viewWidth, viewHeight)
            params.bottomMargin = (20 * RxDeviceTool.getScreenDensity(mContext)).toInt()
            layoutParams = params
            View.inflate(mContext, R.layout.home_assuage_grief_image_under_four_item_view, this)

            YDLImageCacheManager.showImage(mContext, urlList[0], homeModuleAssuageGriefUnderFourItemViewFirstImg)
            YDLImageCacheManager.showImage(mContext, urlList[1], homeModuleAssuageGriefUnderFourItemViewSecondImg)
            YDLImageCacheManager.showImage(mContext, urlList[2], homeModuleAssuageGriefUnderFourItemViewThirdImg)

            homeModuleAssuageGriefUnderFourthItemViewTag.text = urlList.size.toString() + "图"

        } else if (urlList.size >= 5) {
            var viewHeight = viewWidth * 180 / 315
            params = LinearLayout.LayoutParams(viewWidth, viewHeight)
            params.bottomMargin = (20 * RxDeviceTool.getScreenDensity(mContext)).toInt()
            layoutParams = params
            View.inflate(mContext, R.layout.home_assuage_grief_image_more_five_item_view, this)

            YDLImageCacheManager.showImage(mContext, urlList[0], homeModuleAssuageGriefUnderFiveItemViewFirstImg)
            YDLImageCacheManager.showImage(mContext, urlList[1], homeModuleAssuageGriefUnderFiveItemViewSecondImg)
            YDLImageCacheManager.showImage(mContext, urlList[2], homeModuleAssuageGriefUnderFiveItemViewThirdImg)
            YDLImageCacheManager.showImage(mContext, urlList[3], homeModuleAssuageGriefUnderFiveItemViewFourthImg)
            YDLImageCacheManager.showImage(mContext, urlList[4], homeModuleAssuageGriefUnderFiveItemViewFiveImg)

            homeModuleAssuageGriefUnderFiveItemViewTag.text = urlList.size.toString() + "图"
        }

    }

    fun updateData() {

    }
}