package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.constract.HomeViewConfig
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeAskBean
import kotlinx.android.synthetic.ydl.home_assuage_grief_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 解忧*问答模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeAssuageGriefView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : LinearLayout(mContext) {

    private var cacheList: ArrayList<HomeAskBean.DataBean> = ArrayList()

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL
        val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.home_assuage_grief_view, this)
        homeModuleAssuageGriefViewHomeCommonTitleView.setTitle(HomeViewConfig.getOrder().dynamicTitle)
        homeModuleAssuageGriefViewHomeCommonTitleView.setOnClickListener {
            homeEvent?.askMoreClick()
        }
    }

    fun initData(position: Int, list: List<HomeAskBean.DataBean>?) {
        //添加View
        list?.let {
            if (null != list && cacheList.size != list?.size) {
                cacheList.clear()
                cacheList.addAll(list!!)
                updateHomeAssuageGriefItemViewNumber()
            }
            //刷新数据
            for (index in 0..childCount) {
                val itemView = getChildAt(index)
                if (itemView is HomeAssuageGriefItemView) {
                    if ((index - 1) < list!!.size) {
                        itemView.updateData(list!![index - 1], position, index - 1)
                    }
                }
            }
        }
    }

    /**
     * 更新itemView的数量以适应新的数据集
     */
    private fun updateHomeAssuageGriefItemViewNumber() {
        var childCountRecord = childCount - 1 //减1是因为第一个子View是标题View
        while (cacheList.size > childCountRecord) {
            addView(HomeAssuageGriefItemView(mContext, homeEvent))
            childCountRecord++
        }
        while (cacheList.size < childCountRecord && getChildAt(childCountRecord) is HomeAssuageGriefItemView) {
            removeViewAt(childCountRecord)
            childCountRecord--
        }
    }
}