package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import kotlinx.android.synthetic.ydl.home_button_banner_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 顶部预约专家，即时倾诉，心理课堂，心理测试按钮模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeButtonBannerView(
    private val mContext: Context,
    private var homeEvent: IHomeBaseEvent?,
    var listenFree: Boolean
) : LinearLayout(mContext) {
    init {
        initView()
    }

    fun setVisibilityFree(boolean: Boolean) {
        if (boolean) {
            qingsuGif.visibility = View.VISIBLE
            homeModuleButtonBannerSecondTitle.text = "免费热线"
        } else {
            qingsuGif.visibility = View.GONE
            homeModuleButtonBannerSecondTitle.text = "倾诉热线"
        }
    }

    private fun initView() {
        val params = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_button_banner_view, this)
        setVisibilityFree(listenFree)
        Glide.with(context)
            .load(R.drawable.qingsu_new_free_dynamic)
            .diskCacheStrategy(DiskCacheStrategy.RESOURCE)
            .into(qingsuGif)
        homeModuleButtonBannerFirst.setOnClickListener {
            homeEvent?.reservationExpertsClick()
        }
        homeModuleButtonBannerSecond.setOnClickListener {
            homeEvent?.nowConfideClick(listenFree)
        }
        homeModuleButtonBannerThird.setOnClickListener {
            homeEvent?.psychologyClassClick()
        }
        homeModuleButtonBannerFourth.setOnClickListener {
            homeEvent?.psychologyTestClick()
        }
    }
}