package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeCourseBean
import com.ydl.ydl_image.manager.YDLImageCacheManager
import kotlinx.android.synthetic.ydl.home_course_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 课程成长模块item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/14
 */
class HomeCourseItemView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?): RelativeLayout(mContext) {

    init {
        initView()
    }

    private fun initView() {
        val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.home_course_item_view, this)
    }

    /**
     * 刷新数据
     */
    fun updateData(bean: HomeCourseBean.ListBean?) {

        YDLImageCacheManager.showImage(mContext,bean?.pic,homeModuleCourseItemViewImg)
        homeModuleCourseItemViewTitle.text = bean?.title
        homeModuleCourseItemViewPersonNum.text = bean?.readNums.toString()

        if (bean?.applyFee == 0f) {
            homeModuleCourseItemViewFreePrice.visibility = View.VISIBLE
            homeModuleCourseItemViewExpensePriceHideView.visibility = View.GONE
        }else {
            if (bean?.isPromotion == 1) {
                homeModuleCourseItemViewExpensePrice.text = "￥" + String.format("%.2f", bean?.promotionApplyFee!!)
            }else {
                homeModuleCourseItemViewExpensePrice.text = "￥" + String.format("%.2f", bean?.applyFee!!)
            }
        }

        setOnClickListener {
            homeEvent?.courseItemClick(bean)
        }
    }
}