package com.yidianling.home.ui.view

import android.content.Context
import android.graphics.Color
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.utils.ScreenUtil
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.adapter.CategoryAdapter
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import kotlinx.android.synthetic.ydl.home_pager_banner_category_view.view.*


/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 首页顶部模块-分类模块 金刚位跳转H5或咨询列表页面
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/16
 */
class HomePagerBannerCategoryItemView(mContext: Context, homeEvent: IHomeBaseEvent) : FrameLayout(mContext) {
    /**
     * 数据缓存
     */
    var mDataList: ArrayList<HomeHeaderBean.CategoryGoldListDataBean>? = null

    /**
     * 分类view宽度
     */
    var categoryWidth: Int = 0
    /**
     * 图片宽高
     */
    var imageViewWidth: Int = 0
    /**
     * 文本宽度
     */
    var textViewWidth: Int = 0
    /**
     * 文本高度
     */
    var textViewHeight: Int = 0
    /**
     * 间隔
     */
    var margin: Int = 0

    var dp8: Int = 0
    var dp10 : Int = 0
    /**
     * 是否添加了实时测试状态View
     */
    var hasRealTestView: Boolean = false

    private var realTestView: HomePagerBannerRealView? = null
    /**
     * 线
     */
    private var lineView: View? = null
    /**
     * 倍数
     */
    private var multiple: Int = 0

    /**
     * 测评首页事件处理类
     */
    private var homeEvent: IHomeBaseEvent? = null
    private lateinit var categoryAdapter: CategoryAdapter

    init {
        initView()
        this.homeEvent = homeEvent
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.home_pager_banner_category_view, this)
        val params = FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.WRAP_CONTENT)
//        params.topMargin = ScreenUtil.screenHeight * (356f / 750f).toInt()
        layoutParams = params
//        initArgs()
    }

    /**
     * 初始化变量
     */
    private fun initArgs() {
        categoryWidth = ScreenUtil.screenWidth
        textViewWidth = categoryWidth / 5
        imageViewWidth = RxImageTool.dip2px(38f)
        margin = (categoryWidth - 5 * imageViewWidth) / 10
        dp8 = RxImageTool.dip2px(8f)
        dp10 = RxImageTool.dip2px(10f)
        //高度=文字12dp+16dp间距
        textViewHeight = RxImageTool.dip2px(28f)
    }

    //, homeSaleData: List<HomeHeaderBean.HomeSaleDataBean>?
    fun initData(askCategoryDataBean: MutableList<HomeHeaderBean.CategoryGoldListDataBean>?) {
        if (null == askCategoryDataBean || askCategoryDataBean.isEmpty()) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        if (null == mDataList) {
            mDataList = ArrayList()
        }
        if (getChange(askCategoryDataBean, mDataList)) {
            mDataList!!.clear()
            mDataList!!.addAll(askCategoryDataBean)
        }
        homeEvent?.let {
            categoryAdapter = CategoryAdapter(context, mDataList!!, it)
        }
        homeModulePagerBannerFlRoot.adapter = categoryAdapter
        homeModulePagerBannerFlRoot.layoutManager = GridLayoutManager(
            context,
            5,
            LinearLayoutManager.VERTICAL,
            false
        )

//        refreshView()
//        setRealTextView(homeSaleData)
    }

    /**
     * 判断数据是否变化
     */
    private fun getChange(
        bean: MutableList<HomeHeaderBean.CategoryGoldListDataBean>?,
        cacheBean: MutableList<HomeHeaderBean.CategoryGoldListDataBean>?
    ): Boolean {
        if (bean?.size != cacheBean?.size) {
            return true
        }
        for (index in 0 until bean?.size!!) {
            if (!bean[index].icon.equals(cacheBean!![index].icon)
                || !bean[index].title.equals(cacheBean!![index].title)
                || bean[index].id != cacheBean!![index].id
            ) {
                return true
            }
        }
        return false
    }

    /**
     * 刷新View
     */
    private fun refreshView() {
        homeModulePagerBannerFlRoot.removeAllViews()
        var i = 0
        for (item in mDataList!!) {
            val imageView = createIcon(i)
            val textView = createText(i)

            homeModulePagerBannerFlRoot.addView(imageView)
            homeModulePagerBannerFlRoot.addView(textView)

            imageView.setOnClickListener {
                homeEvent!!.categoryClick(item)
            }
            textView.setOnClickListener {
                homeEvent!!.categoryClick(item)
            }
            bindIconData(imageView, item)
            bindTextData(textView, item)
            i++
        }
    }

    /**
     * 创建图标
     */
    private fun createIcon(i: Int): ImageView {
        val imageParams = FrameLayout.LayoutParams(imageViewWidth, imageViewWidth)
        val imageView = ImageView(context)
        imageView.scaleType = ImageView.ScaleType.CENTER_CROP

        if (i > 4) {
            multiple = 2
            imageParams.topMargin = imageViewWidth + dp10 + textViewHeight
            imageParams.leftMargin = margin * (i - 4) + (i - 5) * (imageViewWidth + margin)
        } else {
            multiple = 1
            imageParams.leftMargin = margin * (i + 1) + i * (imageViewWidth + margin)
        }
        imageView.layoutParams = imageParams

        return imageView
    }

    /**
     * 加载图片
     */
    private fun bindIconData(
        imageView: ImageView,
        categoryBean: HomeHeaderBean.CategoryGoldListDataBean
    ) {
        GlideApp.with(context).load(categoryBean.icon)
            .centerCrop().into(imageView)
    }

    /**
     * 创建文本
     */
    private fun createText(index: Int): TextView {
        val textParams = FrameLayout.LayoutParams(textViewWidth, textViewHeight)
        val textView = TextView(context)
        textView.setTextColor(Color.parseColor("#242424"))

        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12f)
        textView.gravity = Gravity.CENTER_HORIZONTAL
        if (index > 4) {
            textParams.topMargin = 2 * (imageViewWidth + dp8) + textViewHeight
            textParams.leftMargin = textViewWidth * (index - 5)
        } else {
            textParams.topMargin = imageViewWidth + dp8
            textParams.leftMargin = textViewWidth * (index)
        }
        textView.layoutParams = textParams

        return textView
    }

    /**
     * 设置文本
     */
    private fun bindTextData(
        textView: TextView,
        categoryBean: HomeHeaderBean.CategoryGoldListDataBean
    ) {
        textView.text = categoryBean.title
    }

    /**
     * 初始化实时测评状态View
     */
    private fun initRealTextView() {
        if (null == realTestView) {
            var realTestParam = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
            realTestParam.topMargin = multiple * (imageViewWidth + dp8 + textViewHeight) + dp8 + RxImageTool.dip2px(10f)
            realTestView = HomePagerBannerRealView(context, homeEvent!!)
            realTestView!!.layoutParams = realTestParam
        }
    }

    private fun initLineView() {
        var lineParam = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dip2px(0.5f))
        var dp15 = RxImageTool.dip2px(15f)
        lineParam.leftMargin = dp15
        lineParam.rightMargin = dp15
        lineParam.topMargin = multiple * (imageViewWidth + dp8 + textViewHeight) + dp8
        lineView = View(context)
        lineView!!.setBackgroundColor(resources.getColor(R.color.platform_big_bg_color))
        lineView!!.layoutParams = lineParam
    }

    /**
     * 实时测评状态赋值
     */
    private fun setRealTextView(list: List<HomeHeaderBean.HomeSaleDataBean>?) {
        if (!hasRealTestView) {
            initLineView()
            homeModulePagerBannerFlRoot.addView(lineView)
            initRealTextView()
            homeModulePagerBannerFlRoot.addView(realTestView)
            hasRealTestView = true
        }
        realTestView!!.initData(list)
    }

    fun onDestory() {
        if (null == realTestView) {
            return
        }
        realTestView!!.onDestory()
    }
}