package com.yidianling.im.config.provider

import android.content.Context
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum
import com.netease.nimlib.sdk.msg.model.IMMessage
import com.netease.nimlib.sdk.uinfo.model.UserInfo
import com.ydl.ydlcommon.utils.UserInfoCache
import com.yidianling.uikit.api.wrapper.NimUserInfoProvider

/**
 * Created by haorui on 2019/5/17.
 * Des:
 */
class CustomUserInfoProvider(context:Context) : NimUserInfoProvider(context) {

    override fun getUserInfo(account: String): UserInfo {
        return object : UserInfo {
            override fun getAvatar(): String {
                return UserInfoCache.getInstance().getUser(account).avatar
            }

            override fun getName(): String {
                return UserInfoCache.getInstance().getUser(account).nickName
            }

            override fun getAccount(): String {
                return account
            }
        }
    }

    override fun getDisplayNameForMessageNotifier(account: String?, sessionId: String?, sessionType: SessionTypeEnum?): String {
        return UserInfoCache.getInstance().getUser(account).nickName
    }
}
