package com.yidianling.im.http

import com.ydl.ydlcommon.base.config.YDLConstants
import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.im.api.bean.IMExpertBuild
import com.yidianling.im.api.bean.MsgDetail
import com.yidianling.im.api.bean.UpdateStatusBean
import com.yidianling.im.bean.MsgData
import com.yidianling.im.bean.MsgHome
import com.yidianling.im.bean.SystemMsgBean
import com.yidianling.im.ui.page.fragment.bean.ChatModelBean
import com.yidianling.im.ui.page.fragment.bean.InteractBean
import com.yidianling.im.ui.page.fragment.bean.NoticeItemBean
import com.yidianling.im.ui.page.fragment.bean.UnreadMessageBean
import io.reactivex.Observable
import retrofit2.http.*

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/03/10
 */
interface ImApi {

    @POST("call/v2/dial/yunxin")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun nim2Token(@Body body: Map<String, String>): Observable<BaseResponse<String?>>

    @POST("counselor/device/callline")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun reportSupportLine(@Body body: Map<String, @JvmSuppressWildcards Any>): Observable<BaseAPIResponse<Any?>>

    //获得消息列表
    @FormUrlEncoded
    @POST("sms/list")
    fun getSysMsgList(@FieldMap params: Map<String, String>): Observable<BaseResponse<List<SystemMsgBean>>>

    //获得消息详情
    @FormUrlEncoded
    @POST("sms/detail")
    fun getMsgDetail(@FieldMap params: Map<String, String>): Observable<BaseResponse<MsgDetail>>

    //全部标记为已读
    @FormUrlEncoded
    @POST("sms/update-read")
    fun updateRead(@FieldMap params: Map<String, String>): Observable<BaseResponse<UpdateStatusBean>>

    //获得消息列表
    @FormUrlEncoded
    @POST("sms/list")
    fun getMsgList(@FieldMap params: Map<String, String>): Observable<BaseResponse<List<MsgData>>>

    /**
     * 置顶/取消置顶会话
     */
    @FormUrlEncoded
    @POST("sms/oper-talk")
    fun topMessage(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //消息主页
    @FormUrlEncoded
    @POST("sms/home-new")
    fun msgHome(@Field(YDLConstants.HOLDER_PARAM) params: String): Observable<BaseResponse<List<MsgHome>>>

    //删除私聊记录
    @FormUrlEncoded
    @POST("consult/rm-history")
    fun rmHistory(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    /**
     * 移除会话
     */
    @FormUrlEncoded
    @POST("sms/rm-talk")
    fun rmTalk(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //私聊 获取聊天者的订单关系数据
    @FormUrlEncoded
    @POST("consult/get-expert")
    fun getExpert(@FieldMap params: Map<String, String>): Observable<BaseResponse<IMExpertBuild>>


    //以下接口为消息改版后新加
    //私聊 获取各消息未读数
    @GET("chat/getNotifyCountMessage")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun getUnreadMessage(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<UnreadMessageBean>>

    //私聊 获取私聊消息
    @GET("chat/getPrivateMessageList")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun getAllChatMessage(@QueryMap params: Map<String, String>) : Observable<BaseAPIResponse<ChatModelBean>>

    //私聊 获取通知消息
    @GET("chat/getNotifyMessageList")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun getNoticeMessage(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<List<NoticeItemBean>>>

    //私聊 已读或清除消息
    @GET("chat/allMessageReadOrDel")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun clearMessage(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<Boolean>>

    //私聊 获取互动消息
    @GET("chat/getInteractiveMessageList")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun getInteractMessage(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<InteractBean>>
}