package com.yidianling.im.http

import com.yidianling.im.bean.*
import com.yidianling.im.http.param.*
import com.yidianling.im.message.param.MsgDetailParam
import com.yidianling.im.message.param.MsgListParam
import com.yidianling.im.message.param.ReadParam
import com.yidianling.im.ui.page.fragment.bean.*
import com.yidianling.im.ui.param.*
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.im.api.bean.*
import com.yidianling.im.api.param.RmHistoryParam
import com.yidianling.im.api.param.RmTalkParam
import com.yidianling.im.api.param.TopMessageParam
import io.reactivex.Observable

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/03/10
 */
interface ImHttp {


    fun getSysMsgList(param: MsgListParam): Observable<BaseResponse<List<SystemMsgBean>>>

    fun getMsgDetail(param: MsgDetailParam): Observable<BaseResponse<MsgDetail>>

    fun updateRead(param: ReadParam): Observable<BaseResponse<UpdateStatusBean>>

    fun getMsgList(param: MsgListParam): Observable<BaseResponse<List<MsgData>>>

    fun topMessage(param: TopMessageParam): Observable<BaseResponse<Any>>

    fun msgHome(): Observable<BaseResponse<List<MsgHome>>>

    fun rmHistory(param: RmHistoryParam): Observable<BaseResponse<Any>>

    fun rmTalk(param: RmTalkParam): Observable<BaseResponse<Any>>

    fun getExpert(param: ExpertParam): Observable<BaseResponse<IMExpertBuild>>

    fun getAllChatMessage(param: ChatParam): Observable<BaseAPIResponse<ChatModelBean>>

    fun getNoticeMessage(param: NoticeParam): Observable<BaseAPIResponse<List<NoticeItemBean>>>

    fun clearMessage(param: ClearMessageParam): Observable<BaseAPIResponse<Boolean>>

    fun getInteractMessage(param: InteractMessageParam): Observable<BaseAPIResponse<InteractBean>>

    fun getUnreadMessage(param: UnreadParam): Observable<BaseAPIResponse<UnreadMessageBean>>

}