package com.yidianling.im.http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.im.api.bean.*
import com.yidianling.im.bean.*
import com.yidianling.im.http.param.ExpertParam
import com.yidianling.im.api.param.RmHistoryParam
import com.yidianling.im.api.param.RmTalkParam
import com.yidianling.im.api.param.TopMessageParam
import com.yidianling.im.message.param.MsgDetailParam
import com.yidianling.im.message.param.MsgListParam
import com.yidianling.im.message.param.ReadParam
import com.yidianling.im.ui.page.fragment.bean.ChatModelBean
import com.yidianling.im.ui.page.fragment.bean.InteractBean
import com.yidianling.im.ui.page.fragment.bean.NoticeItemBean
import com.yidianling.im.ui.page.fragment.bean.UnreadMessageBean
import com.yidianling.im.ui.param.*
import io.reactivex.Observable

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/03/10
 */
class ImHttpImpl private constructor() : ImHttp {


    companion object {
        fun getInstance(): ImHttpImpl {
            return Holder.INSTANCE
        }

        fun clearImApi() {
            Holder.INSTANCE.imApi = null
        }
    }

    private var imApi: ImApi? = null
    private var imJavaApi: ImApi? = null

    fun getImApi(): ImApi {
        if (imApi == null) {
            imApi = YDLHttpUtils.obtainApi(ImApi::class.java)
        }
        return imApi!!
    }

    private fun getImJavaApi(): ImApi {
        if (imJavaApi == null) {
            imJavaApi = YDLHttpUtils.obtainApi(ImApi::class.java)
        }
        return imJavaApi!!
    }

//    private val imApi: ImApi by lazy {
//        RetrofitProvider.getRetrofit().create(ImApi::class.java)
//    }


    override fun getSysMsgList(param: MsgListParam): Observable<BaseResponse<List<SystemMsgBean>>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().getSysMsgList(it) }
    }

    override fun getMsgDetail(param: MsgDetailParam): Observable<BaseResponse<MsgDetail>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().getMsgDetail(it) }
    }

    override fun updateRead(param: ReadParam): Observable<BaseResponse<UpdateStatusBean>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().updateRead(it) }
    }

    override fun getMsgList(param: MsgListParam): Observable<BaseResponse<List<MsgData>>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().getMsgList(it) }
    }

    override fun topMessage(param: TopMessageParam): Observable<BaseResponse<Any>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().topMessage(it) }
    }

    override fun msgHome(): Observable<BaseResponse<List<MsgHome>>> {
        return getImApi().msgHome("")
                .compose(RxUtils.netCheck())
    }

    override fun rmHistory(param: RmHistoryParam): Observable<BaseResponse<Any>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().rmHistory(it) }
    }

    override fun rmTalk(param: RmTalkParam): Observable<BaseResponse<Any>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().rmTalk(it) }
    }

    override fun getExpert(param: ExpertParam): Observable<BaseResponse<IMExpertBuild>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImApi().getExpert(it) }
    }

    override fun getUnreadMessage(param: UnreadParam): Observable<BaseAPIResponse<UnreadMessageBean>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImJavaApi().getUnreadMessage(it) }
    }

    override fun getAllChatMessage(param: ChatParam): Observable<BaseAPIResponse<ChatModelBean>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImJavaApi().getAllChatMessage(it) }
    }

    override fun getNoticeMessage(param: NoticeParam): Observable<BaseAPIResponse<List<NoticeItemBean>>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImJavaApi().getNoticeMessage(it) }
    }

    override fun clearMessage(param: ClearMessageParam): Observable<BaseAPIResponse<Boolean>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImJavaApi().clearMessage(it) }
    }

    override fun getInteractMessage(param: InteractMessageParam): Observable<BaseAPIResponse<InteractBean>> {
        return RxUtils.mapObservable(param)
                .flatMap { getImJavaApi().getInteractMessage(it) }
    }

    object Holder {
        val INSTANCE = ImHttpImpl()
    }
}