package com.yidianling.im.session;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;

import com.google.gson.Gson;
import com.netease.nimlib.sdk.NIMClient;
import com.netease.nimlib.sdk.RequestCallback;
import com.netease.nimlib.sdk.StatusCode;
import com.netease.nimlib.sdk.auth.LoginInfo;
import com.netease.nimlib.sdk.avchat.constant.AVChatType;
import com.netease.nimlib.sdk.avchat.model.AVChatAttachment;
import com.netease.nimlib.sdk.msg.MsgService;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.constant.MsgDirectionEnum;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.netease.nimlib.sdk.team.constant.TeamTypeEnum;
import com.netease.nimlib.sdk.team.model.Team;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.UpLoadLogUtils;
import com.ydl.ydlcommon.utils.log.LogHelper;
import com.ydl.ydlcommon.view.dialog.CommonDialog;
import com.yidianling.avchatkit.TeamAVChatProfile;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.im.http.ImRetrofitApi;
import com.yidianling.im.router.ImIn;
import com.yidianling.im.session.action.AVChatAction;
import com.yidianling.im.session.action.H5VideoAction;
import com.yidianling.im.session.action.HelpAction;
import com.yidianling.im.session.action.MakeCollectionsAction;
import com.yidianling.im.session.action.OrderAction;
import com.yidianling.im.session.action.RedPacketAction;
import com.yidianling.im.session.action.SendCardAction;
import com.yidianling.im.session.action.TeamAVChatAction;
import com.yidianling.im.session.extension.CustomAttachAssistantReceivedMoney;
import com.yidianling.im.session.extension.CustomAttachChatTipMsg;
import com.yidianling.im.session.extension.CustomAttachConsult;
import com.yidianling.im.session.extension.CustomAttachConsultCallStatus;
import com.yidianling.im.session.extension.CustomAttachConsultPerfectData;
import com.yidianling.im.session.extension.CustomAttachConsultSubScript;
import com.yidianling.im.session.extension.CustomAttachConsultSubScriptPayment;
import com.yidianling.im.session.extension.CustomAttachLingXiJumpConfideList;
import com.yidianling.im.session.extension.CustomAttachLingxiAnswerQuestion;
import com.yidianling.im.session.extension.CustomAttachLingxiFirstQuestion;
import com.yidianling.im.session.extension.CustomAttachLingxiWhichQuestion;
import com.yidianling.im.session.extension.CustomAttachModifyTime;
import com.yidianling.im.session.extension.CustomAttachParser;
import com.yidianling.im.session.extension.CustomAttachPleaseSubscribeConsultDate;
import com.yidianling.im.session.extension.CustomAttachReceivedMoney;
import com.yidianling.im.session.extension.CustomAttachRedPacket;
import com.yidianling.im.session.extension.CustomAttachSubScriptTime;
import com.yidianling.im.session.extension.CustomAttachTipMsg;
import com.yidianling.im.session.extension.CustomAttachment;
import com.yidianling.im.session.extension.CustomAttachmentBusinessCard;
import com.yidianling.im.session.extension.CustomAttachmentConfirmOrder;
import com.yidianling.im.session.extension.CustomAttachmentEvaluate;
import com.yidianling.im.session.extension.CustomAttachmentFilter;
import com.yidianling.im.session.extension.CustomAttachmentJumpToDaoYi;
import com.yidianling.im.session.extension.CustomAttachmentOrderAlreadyDone;
import com.yidianling.im.session.extension.CustomAttachmentOrderStatus;
import com.yidianling.im.session.extension.CustomAttachmentPhoneCallRedPacket;
import com.yidianling.im.session.extension.CustomAttachmentPhoneCallSystemNotice;
import com.yidianling.im.session.extension.CustomAttachmentReceivedSuccess;
import com.yidianling.im.session.extension.CustomAttachmentReceivedTimeout;
import com.yidianling.im.session.extension.CustomAttachmentRecommendAssistant;
import com.yidianling.im.session.extension.CustomAttachmentRedStatus;
import com.yidianling.im.session.extension.CustomAttachmentShareMsg;
import com.yidianling.im.session.extension.CustomAttachmentSwitchKeFuTips;
import com.yidianling.im.session.extension.CustomAttachmentTest;
import com.yidianling.im.session.extension.CustomCustomerServiceCardAttachment;
import com.yidianling.im.session.extension.CustomRecommendExpertListMsg;
import com.yidianling.im.session.extension.CustomSystemTips;
import com.yidianling.im.session.extension.DefaultCustomAttachment;
import com.yidianling.im.session.extension.StickerAttachment;
import com.yidianling.im.session.viewholder.MsgViewHolderAVChat;
import com.yidianling.im.session.viewholder.MsgViewHolderAssistantReceivedMoney;
import com.yidianling.im.session.viewholder.MsgViewHolderBusinessCard;
import com.yidianling.im.session.viewholder.MsgViewHolderChatTip;
import com.yidianling.im.session.viewholder.MsgViewHolderConfirmOrder;
import com.yidianling.im.session.viewholder.MsgViewHolderConsult;
import com.yidianling.im.session.viewholder.MsgViewHolderConsultCallStatus;
import com.yidianling.im.session.viewholder.MsgViewHolderConsultSubScribe;
import com.yidianling.im.session.viewholder.MsgViewHolderConsultSubScribePayment;
import com.yidianling.im.session.viewholder.MsgViewHolderCustomTip;
import com.yidianling.im.session.viewholder.MsgViewHolderCustomerServiceCard;
import com.yidianling.im.session.viewholder.MsgViewHolderDefCustom;
import com.yidianling.im.session.viewholder.MsgViewHolderEvaluate;
import com.yidianling.im.session.viewholder.MsgViewHolderJumpToDaoYi;
import com.yidianling.im.session.viewholder.MsgViewHolderLingXiJumpConfideList;
import com.yidianling.im.session.viewholder.MsgViewHolderLingxiAnswerQuestion;
import com.yidianling.im.session.viewholder.MsgViewHolderLingxiFirstQuestion;
import com.yidianling.im.session.viewholder.MsgViewHolderLingxiWhichQuestion;
import com.yidianling.im.session.viewholder.MsgViewHolderModifyTime;
import com.yidianling.im.session.viewholder.MsgViewHolderOrderAlreadyDone;
import com.yidianling.im.session.viewholder.MsgViewHolderOrderStatus;
import com.yidianling.im.session.viewholder.MsgViewHolderPerfectConsultData;
import com.yidianling.im.session.viewholder.MsgViewHolderPhoneCallRedPacket;
import com.yidianling.im.session.viewholder.MsgViewHolderPhoneCallSystemNotice;
import com.yidianling.im.session.viewholder.MsgViewHolderPleaseSubscribeConsultDate;
import com.yidianling.im.session.viewholder.MsgViewHolderReceivedMoney;
import com.yidianling.im.session.viewholder.MsgViewHolderReceivedStatus;
import com.yidianling.im.session.viewholder.MsgViewHolderRecommendAssistant;
import com.yidianling.im.session.viewholder.MsgViewHolderRecommendExpertList;
import com.yidianling.im.session.viewholder.MsgViewHolderRedPacket;
import com.yidianling.im.session.viewholder.MsgViewHolderRedStatus;
import com.yidianling.im.session.viewholder.MsgViewHolderSendTest;
import com.yidianling.im.session.viewholder.MsgViewHolderShareMsg;
import com.yidianling.im.session.viewholder.MsgViewHolderSticker;
import com.yidianling.im.session.viewholder.MsgViewHolderSubscriptTime;
import com.yidianling.im.session.viewholder.MsgViewHolderSwitchKeFuTips;
import com.yidianling.im.session.viewholder.MsgViewHolderSystemTips;
import com.yidianling.im.session.viewholder.MsgViewHolderTip;
import com.yidianling.im.ui.param.BuryRedPointParam;
import com.yidianling.nimbase.api.model.session.SessionCustomization;
import com.yidianling.nimbase.api.model.session.SessionEventListener;
import com.yidianling.nimbase.business.session.actions.BaseAction;
import com.yidianling.nimbase.impl.cache.TeamDataCache;
import com.yidianling.uikit.api.NimUIKit;
import com.yidianling.uikit.business.session.actions.ImageAction;
import com.yidianling.uikit.business.session.actions.VideoAction;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderUnknown;
import com.yidianling.uikit.business.team.model.TeamExtras;
import com.yidianling.uikit.business.team.model.TeamRequestCode;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.yidianling.uikit.custom.bridge.IP2PCustomActionHandler;
import com.yidianling.user.api.bean.UserResponseBean;

import java.util.ArrayList;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * UIKit自定义消息界面用法展示类
 */
public class SessionHelper {

    private static SessionCustomization p2pCustomization;

    private static SessionCustomization teamCustomization;

    private static SessionCustomization myP2pCustomization;

    private static SessionCustomization normalTeamCustomization;

    private static SessionCustomization advancedTeamCustomization;

    private static int last_user_type = -2;

    public static void init() {
        // 注册自定义消息附件解析器
        NIMClient.getService(MsgService.class).registerCustomAttachmentParser(new CustomAttachParser());
        // 注册各种扩展消息类型的显示ViewHolder
        registerViewHolders();
        // 设置会话中点击事件响应处理
        setSessionListener();
    }

    public static void startP2PSession(Context context, int user_type, String account, IMMessage anchor, IP2PCustomActionHandler actionHandler) {
        LogHelper.Companion.getInstance().writeLogSync("开启聊天："
                + "user_type = " + user_type
                + ", account = " + account);
        //只要打开聊天页面，就请求接口，服务端用来判断消息红点显示隐藏
        notifyRedPoint(account, ImIn.INSTANCE.getUserInfo().getUid());
        StatusCode status = NIMClient.getStatus();
        if (status == StatusCode.UNLOGIN) {
            RequestCallback<LoginInfo> callback = new RequestCallback<LoginInfo>() {
                @Override
                public void onSuccess(LoginInfo param) {
                    if (!(ImIn.INSTANCE.getUserInfo().getUid() + "").equals(account)) {
                        actionHandler.setUserType(user_type);
                        NimUIKit.startYDLChatting(context, account, SessionTypeEnum.P2P, getP2pCustomization(user_type), anchor, actionHandler);
                    } else {
                        NimUIKit.startYDLChatting(context, account, SessionTypeEnum.P2P, getMyP2pCustomization(), anchor, null);
                    }
                }

                @Override
                public void onFailed(int code) {
                    // 上传日志
                    UpLoadLogUtils.INSTANCE.upLoadLog("WYYXLogin", code, "login IM failed");
                    if (code == 408 || code == 415) {
                        CommonDialog dialog = new CommonDialog(context);
                        dialog.setMessage("连接超时，请切换网络(4G/wifi)尝试")
                                .setRightClick("知道了", null)
                                .setCancelAble(false)
                                .show();
                    } else {
                        ToastUtil.toastLong(context, code + "");
                    }
                }

                @Override
                public void onException(Throwable exception) {
                    try {
                        UpLoadLogUtils.INSTANCE.upLoadLog("IMLogin", -1, exception.toString());
                    } catch (Exception e) {
                    }
                }
            };
            UserResponseBean userInfo = ImIn.INSTANCE.getUserResponse();
            String imAccount = "", imToken = "";
            if (userInfo != null) {
                imAccount = userInfo.getUid();
                imToken = userInfo.getHxpwd();
            }
            ImIn.INSTANCE.loginIm(imAccount, imToken, callback);
            return;
        }

        if (!(ImIn.INSTANCE.getUserInfo().getUid() + "").equals(account)) {
            actionHandler.setUserType(user_type);
            NimUIKit.startYDLChatting(context, account, SessionTypeEnum.P2P, getP2pCustomization(user_type), anchor,
                    actionHandler);
        } else {
            NimUIKit.startYDLChatting(context, account, SessionTypeEnum.P2P, getMyP2pCustomization(), anchor, null);
        }
    }

    /*
     * 通知服务端红点
     * */
    private static void notifyRedPoint( String assistantUid, String userId) {
        String str =  new Gson().toJson(new BuryRedPointParam(assistantUid, userId));
        RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str);
        Disposable subscribe = ImRetrofitApi.Companion.getImRetrofitApi().imBuryRedPoints(body)
                .compose(RxUtils.INSTANCE.resultJavaData())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(it -> {
                            LogUtil.e("redPointsSuccess");
                        }, throwable ->
                                LogUtil.e(throwable.getMessage())
                );
    }


    public static void startTeamSession(Context context, String tid) {
        startTeamSession(context, tid, null, null);
    }

    public static void startTeamSession(Context context, String tid, IMMessage anchor, IP2PCustomActionHandler myP2PMoreListener) {
        NimUIKit.startYDLChatting(context, tid, SessionTypeEnum.Team, getTeamCustomization(tid), anchor, myP2PMoreListener);
    }

    //====================Get Customization====================

    public static SessionCustomization getP2pCustomization(int user_type) {

        if (last_user_type != user_type) {
            last_user_type = user_type;
            p2pCustomization = null;
            p2pCustomization = new SessionCustomization() {
                // 由于需要Activity Result， 所以重载该函数。
                @Override
                public void onActivityResult(final Activity activity, int requestCode, int resultCode, Intent data) {
                    super.onActivityResult(activity, requestCode, resultCode, data);

                }

                @Override
                public MsgAttachment createStickerAttachment(String category, String item) {
                    return new StickerAttachment(category, item);
                }
            };

            // 定制加号点开后可以包含的操作
            ArrayList<BaseAction> actions = new ArrayList<>();
            actions.add(new ImageAction());
            actions.add(new VideoAction());
            //语音视频
            if ((ImIn.INSTANCE.getUserInfo().getUser_type() == 1 && (user_type == 1 || user_type == 3)) || user_type == -1) {//1代表用户不能和用户聊天
            } else {
                // 助理也不能跟用户电话/视频聊天
                if (ImIn.INSTANCE.getUserInfo().getUser_type() != 3) {
                    actions.add(new H5VideoAction(AVChatType.AUDIO));
                }
            }
            if (user_type == 2) {
                actions.add(new OrderAction());
            }
            //跟ios同步，助理也不展示帮助按钮
            if (ImIn.INSTANCE.getUserInfo().getUser_type() != 3) {
                actions.add(new HelpAction());
            }

            if (user_type == 2) {
                actions.add(new RedPacketAction());
            }

            //助理
            if (ImIn.INSTANCE.getUserInfo().getUser_type() == 3) {
                actions.add(new MakeCollectionsAction()); // 发起收款
                actions.add(new SendCardAction()); // 发送客服名片
            }

            p2pCustomization.actions = actions;

            ArrayList<SessionCustomization.OptionsButton> buttons = new ArrayList<>();
            SessionCustomization.OptionsButton infoButton = new SessionCustomization.OptionsButton() {

                @Override
                public void onClick(Context context, View view, String sessionId) {
                    if (ActionHandlerStorage.getL(sessionId) != null) {
                        ActionHandlerStorage.getL(sessionId).clickMoreIcon();
                    }
                }
            };
            infoButton.iconId = R.drawable.platform_common_more;
            buttons.add(infoButton);
            p2pCustomization.buttons = buttons;

            p2pCustomization.withSticker = true;
        }

        return p2pCustomization;
    }

    private static SessionCustomization getMyP2pCustomization() {
        if (myP2pCustomization == null) {
            myP2pCustomization = new SessionCustomization() {
                // 由于需要Activity Result， 所以重载该函数。
                @Override
                public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
                    if (requestCode == TeamRequestCode.REQUEST_CODE && resultCode == Activity.RESULT_OK) {
                        String result = data.getStringExtra(TeamExtras.RESULT_EXTRA_REASON);
                        if (result == null) {
                            return;
                        }
                        if (result.equals(TeamExtras.RESULT_EXTRA_REASON_CREATE)) {
                            String tid = data.getStringExtra(TeamExtras.RESULT_EXTRA_DATA);
                            if (TextUtils.isEmpty(tid)) {
                                return;
                            }
                            startTeamSession(activity, tid);
                            activity.finish();
                        }
                    }
                }

                @Override
                public MsgAttachment createStickerAttachment(String category, String item) {
                    return new StickerAttachment(category, item);
                }
            };
        }

        // 定制加号点开后可以包含的操作
        ArrayList<BaseAction> actions = new ArrayList<>();
        actions.add(new AVChatAction(AVChatType.AUDIO));
        actions.add(new AVChatAction(AVChatType.VIDEO));

        myP2pCustomization.actions = actions;

        ArrayList<SessionCustomization.OptionsButton> buttons = new ArrayList<>();
        SessionCustomization.OptionsButton infoButton = new SessionCustomization.OptionsButton() {

            @Override
            public void onClick(Context context, View view, String sessionId) {
                if (ActionHandlerStorage.getL(sessionId) != null) {
                    ActionHandlerStorage.getL(sessionId).clickMoreIcon();
                }
            }
        };
        infoButton.iconId = R.drawable.im_more12x;
        buttons.add(infoButton);
        if (p2pCustomization != null){
            p2pCustomization.buttons = buttons;
        }
        myP2pCustomization.withSticker = true;
        return myP2pCustomization;
    }

    private static SessionCustomization getTeamCustomization(String tid) {
        if (normalTeamCustomization == null) {
            // 定制加号点开后可以包含的操作， 默认已经有图片，视频等消息了
            final TeamAVChatAction avChatAction = new TeamAVChatAction(AVChatType.VIDEO);
            TeamAVChatProfile.sharedInstance().registerObserver(true);
            ArrayList<BaseAction> actions = new ArrayList<>();
            actions.add(new ImageAction());
            actions.add(new VideoAction());
            actions.add(avChatAction);
            SessionTeamCustomization.SessionTeamCustomListener listener = new SessionTeamCustomization.SessionTeamCustomListener() {
                @Override
                public void onSelectedAccountsResult(ArrayList<String> selectedAccounts) {
                    avChatAction.onSelectedAccountsResult(selectedAccounts);
                }

                @Override
                public void onSelectedAccountFail() {
                    avChatAction.onSelectedAccountFail();
                }
            };
            normalTeamCustomization = new SessionTeamCustomization(listener);
            normalTeamCustomization.actions = actions;
        }
        if (advancedTeamCustomization == null) {
            // 定制加号点开后可以包含的操作， 默认已经有图片，视频等消息了
            final TeamAVChatAction avChatAction = new TeamAVChatAction(AVChatType.VIDEO);
            TeamAVChatProfile.sharedInstance().registerObserver(true);
            ArrayList<BaseAction> actions = new ArrayList<>();
            actions.add(new ImageAction());
            actions.add(new VideoAction());
            //去掉群聊的视频通话按钮
//            actions.add(avChatAction);

            SessionTeamCustomization.SessionTeamCustomListener listener = new SessionTeamCustomization.SessionTeamCustomListener() {

                @Override
                public void onSelectedAccountsResult(ArrayList<String> selectedAccounts) {
                    avChatAction.onSelectedAccountsResult(selectedAccounts);
                }

                @Override
                public void onSelectedAccountFail() {
                    avChatAction.onSelectedAccountFail();
                }
            };
            advancedTeamCustomization = new SessionTeamCustomization(listener);
            advancedTeamCustomization.actions = actions;
        }
        if (TextUtils.isEmpty(tid)) {
            return normalTeamCustomization;
        } else {
            Team team = TeamDataCache.getInstance().getTeamById(tid);
            if (team != null && team.getType() == TeamTypeEnum.Advanced) {
                return advancedTeamCustomization;
            }
        }
        return normalTeamCustomization;
    }

    private static void registerViewHolders() {
        NimUIKit.registerMsgItemViewHolder(AVChatAttachment.class, MsgViewHolderAVChat.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachment.class, MsgViewHolderDefCustom.class);
        NimUIKit.registerMsgItemViewHolder(StickerAttachment.class, MsgViewHolderSticker.class);
        NimUIKit.registerTipMsgViewHolder(MsgViewHolderTip.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentTest.class, MsgViewHolderSendTest.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentEvaluate.class, MsgViewHolderEvaluate.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachConsult.class, MsgViewHolderConsult.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentRecommendAssistant.class, MsgViewHolderRecommendAssistant.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachRedPacket.class, MsgViewHolderRedPacket.class);//红包消息
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentRedStatus.class, MsgViewHolderRedStatus.class);//红包状态
        NimUIKit.registerMsgItemViewHolder(CustomAttachReceivedMoney.class, MsgViewHolderReceivedMoney.class);//收款消息
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentReceivedSuccess.class, MsgViewHolderReceivedStatus.class);//收款提醒消息(成功)
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentReceivedTimeout.class, MsgViewHolderReceivedStatus.class);//收款提醒消息（超时）
        NimUIKit.registerMsgItemViewHolder(DefaultCustomAttachment.class, MsgViewHolderUnknown.class);
        NimUIKit.registerTipMsgViewHolder(MsgViewHolderTip.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachSubScriptTime.class, MsgViewHolderSubscriptTime.class);//添加预约时间
        NimUIKit.registerMsgItemViewHolder(CustomAttachTipMsg.class, MsgViewHolderCustomTip.class);//自定义样式提醒消息
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentOrderStatus.class, MsgViewHolderOrderStatus.class);//订单提醒消息
        NimUIKit.registerMsgItemViewHolder(CustomAttachChatTipMsg.class, MsgViewHolderChatTip.class);//短时间内发送过多私聊 给你警示
        NimUIKit.registerMsgItemViewHolder(CustomAttachModifyTime.class, MsgViewHolderModifyTime.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentPhoneCallRedPacket.class, MsgViewHolderPhoneCallRedPacket.class);//倾述后评价红包
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentPhoneCallSystemNotice.class, MsgViewHolderPhoneCallSystemNotice.class);//本地自定义消息
        NimUIKit.registerMsgItemViewHolder(CustomSystemTips.class, MsgViewHolderSystemTips.class);//本地系统自定义消息 对应24
        NimUIKit.registerMsgItemViewHolder(CustomRecommendExpertListMsg.class, MsgViewHolderRecommendExpertList.class);//推荐专家列表 对应25
        NimUIKit.registerMsgItemViewHolder(CustomAttachConsultSubScript.class, MsgViewHolderConsultSubScribe.class);//确认咨询预约消息  27
        NimUIKit.registerMsgItemViewHolder(CustomAttachConsultPerfectData.class, MsgViewHolderPerfectConsultData.class);//完善咨询资料提醒消息
        NimUIKit.registerMsgItemViewHolder(CustomAttachPleaseSubscribeConsultDate.class, MsgViewHolderPleaseSubscribeConsultDate.class);//请预约咨询时间
        NimUIKit.registerMsgItemViewHolder(CustomCustomerServiceCardAttachment.class, MsgViewHolderCustomerServiceCard.class);//客服小壹名片
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentShareMsg.class, MsgViewHolderShareMsg.class);//分享推送30
        NimUIKit.registerMsgItemViewHolder(CustomAttachConsultCallStatus.class, MsgViewHolderConsultCallStatus.class);//咨询声网的拨打状态 32
        NimUIKit.registerMsgItemViewHolder(CustomAttachAssistantReceivedMoney.class, MsgViewHolderAssistantReceivedMoney.class);
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentBusinessCard.class, MsgViewHolderBusinessCard.class);//专家自定义名片 ，TYPE=34
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentJumpToDaoYi.class, MsgViewHolderJumpToDaoYi.class);//跳转导医聊天窗口触发导医分配逻辑，TYPE=35
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentSwitchKeFuTips.class, MsgViewHolderSwitchKeFuTips.class);//客服转介需求，TYPE=40
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentFilter.class, MsgViewHolderUnknown.class);// 注册消息过滤器
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentConfirmOrder.class, MsgViewHolderConfirmOrder.class);//确认完成订单消息类型38
        NimUIKit.registerMsgItemViewHolder(CustomAttachmentOrderAlreadyDone.class, MsgViewHolderOrderAlreadyDone.class);//已完成订单消息类型39
        NimUIKit.registerMsgItemViewHolder(CustomAttachLingxiWhichQuestion.class, MsgViewHolderLingxiWhichQuestion.class);//灵犀2.0-您想要咨询下列哪些问题
        NimUIKit.registerMsgItemViewHolder(CustomAttachLingxiAnswerQuestion.class, MsgViewHolderLingxiAnswerQuestion.class);//灵犀2.0-回答问题
        NimUIKit.registerMsgItemViewHolder(CustomAttachLingxiFirstQuestion.class, MsgViewHolderLingxiFirstQuestion.class);//灵犀2.0-首问语
        NimUIKit.registerMsgItemViewHolder(CustomAttachLingXiJumpConfideList.class, MsgViewHolderLingXiJumpConfideList.class);//灵犀2.0-倾诉列表
//        NimUIKit.registerMsgItemViewHolder(CustomAttachConsultSubScriptPayment.class, MsgViewHolderConsultSubScribePayment.class);//咨询预约支付


    }

    private static void setSessionListener() {
        SessionEventListener listener = new SessionEventListener() {

            @Override
            public void onAvatarClicked(Context context, IMMessage message) {
                //收到的消息
                if (message.getDirect() == MsgDirectionEnum.In) {
                    // 一般用于打开用户资料页面
                    if (ActionHandlerStorage.getL(message.getSessionId()) != null) {//
                        int userType = ActionHandlerStorage.getL(message.getSessionId()).getUserType();//1普通用户2专家3助理
                        if (userType == 1 || userType == 3) {
                            //跳转用户主页
                            ActionHandlerStorage.getL(message.getSessionId()).showUserHome();
                        } else if (userType == 2) {
                            //跳转专家主页
                            ActionHandlerStorage.getL(message.getSessionId()).showZhuanjPage();
                        }
                    }
                }
            }

            @Override
            public void onAvatarLongClicked(Context context, IMMessage message) {
                // 一般用于群组@功能，或者弹出菜单，做拉黑，加好友等功能
            }

            @Override
            public void onAckMsgClicked(Context context, IMMessage message) {
                // 已读回执事件处理，用于群组的已读回执事件的响应，弹出消息已读详情

            }
        };
        NimUIKit.setSessionListener(listener);
    }
}
