package com.yidianling.im.session;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.View;

import com.yidianling.uikit.api.NimUIKit;
import com.yidianling.uikit.business.contact.selector.activity.ContactSelectActivity;
import com.yidianling.uikit.business.session.activity.YDLTeamMessageActivity;
import com.yidianling.uikit.business.team.model.TeamExtras;
import com.yidianling.uikit.business.team.model.TeamRequestCode;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.team.model.Team;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.StickerAttachment;
import com.yidianling.nimbase.api.model.session.SessionCustomization;
import com.yidianling.nimbase.common.ToastHelper;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 抽象出来的，群组更多定制化选项，普通群和高级群同样功能的抽象
 * Created by winnie on 2018/3/19.
 */

public class SessionTeamCustomization extends SessionCustomization{

    public interface SessionTeamCustomListener extends Serializable {

        void onSelectedAccountsResult(ArrayList<String> selectedAccounts);

        void onSelectedAccountFail();
    }

    private SessionTeamCustomListener sessionTeamCustomListener;

    public SessionTeamCustomization(SessionTeamCustomListener listener) {
        this.sessionTeamCustomListener = listener;
        // 定制ActionBar右边的按钮，可以加多个
        ArrayList<OptionsButton> optionsButtons = new ArrayList<>();
        OptionsButton cloudMsgButton = new OptionsButton() {
            @Override
            public void onClick(Context context, View view, String sessionId) {
                if (ActionHandlerStorage.getL(sessionId)!=null){
                    Team t = NimUIKit.getTeamProvider().getTeamById(sessionId);
                    ActionHandlerStorage.getL(sessionId).h5ActivityStart((YDLTeamMessageActivity)context,"consult/history-ct?tid="+t.getId(),false);
                }
            }
        };
        cloudMsgButton.iconId = R.mipmap.im_chat_ico_lishi;

        OptionsButton infoButton = new OptionsButton() {
            @Override
            public void onClick(Context context, View view, String sessionId) {
                Team team = NimUIKit.getTeamProvider().getTeamById(sessionId);
                if (team != null && team.isMyTeam()) {
                    NimUIKit.startTeamInfo(context, sessionId);
                } else {
                    ToastHelper.showToast(context, R.string.im_team_invalid_tip);
                }
            }
        };
        infoButton.iconId = R.mipmap.im_more12x;
        optionsButtons.add(cloudMsgButton);
        optionsButtons.add(infoButton);

        buttons = optionsButtons;
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        if (requestCode == TeamRequestCode.REQUEST_CODE) {
            if (resultCode == Activity.RESULT_OK) {
                String reason = data.getStringExtra(TeamExtras.RESULT_EXTRA_REASON);
                boolean finish = reason != null && (reason.equals(TeamExtras
                        .RESULT_EXTRA_REASON_DISMISS) || reason.equals(TeamExtras.RESULT_EXTRA_REASON_QUIT));
                if (finish) {
                    activity.finish(); // 退出or解散群直接退出多人会话
                }
            }
        } else if (requestCode == TeamRequestCode.REQUEST_TEAM_VIDEO) {
            if (resultCode == Activity.RESULT_OK) {
                ArrayList<String> selectedAccounts = data.getStringArrayListExtra(ContactSelectActivity.RESULT_DATA);
                sessionTeamCustomListener.onSelectedAccountsResult(selectedAccounts);
            } else {
                sessionTeamCustomListener.onSelectedAccountFail();
            }
        }
    }

    @Override
    public MsgAttachment createStickerAttachment(String category, String item) {
        return new StickerAttachment(category, item);
    }
}
