package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * 收款消息拓展
 * Created by harvie on 2017/1/10.
 */

public class CustomAttachAssistantReceivedMoney extends CustomAttachment {
    private static final String KEY_TITLE = "title";
    private static final String KEY_NUM = "num";
    private static final String KEY_ORPAY = "orPay";
    private static final String KEY_URL = "url";
    private String num = "";//订单金额
    private String title = "";//订单标题题
    private int orPay;//支付状态 0未支付1已支付
    private String url = "";//订单id

    public CustomAttachAssistantReceivedMoney() {
        super(CustomAttachmentType.ASSISTANT_RECEIVEDMONEY);
    }

    public CustomAttachAssistantReceivedMoney(String num, String title, int orPay, String url) {
        super(CustomAttachmentType.ASSISTANT_RECEIVEDMONEY);
        this.num = num;
        this.title = title;
        this.orPay = orPay;
        this.url = url;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.url = data.getString(KEY_URL);
        this.title = data.getString(KEY_TITLE);
        this.num = data.getString(KEY_NUM);
        this.orPay = data.getInteger(KEY_ORPAY);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_URL, url);
        data.put(KEY_TITLE, title);
        data.put(KEY_NUM, num);
        data.put(KEY_ORPAY, orPay);
        return data;
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getOrPay() {
        return orPay;
    }

    public String getTitle() {
        return title;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOrPay(int orPay) {
        this.orPay = orPay;
    }

}
