package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachmentParser;

/**
 * Created by zhoujianghua on 2015/4/9.
 */
public class CustomAttachParser implements MsgAttachmentParser {

    private static final String KEY_TYPE = "type";
    private static final String KEY_DATA = "data";

    @Override
    public MsgAttachment parse(String json) {
        CustomAttachment attachment = null;
        try {
            JSONObject object = JSON.parseObject(json);
            int type = object.getInteger(KEY_TYPE);
            JSONObject data = object.getJSONObject(KEY_DATA);
            switch (type) {
                case CustomAttachmentType.Guess:
//                    attachment = new GuessAttachment();
                    break;
//                case CustomAttachmentType.SnapChat:
//                    return new SnapChatAttachment(data);
//                case CustomAttachmentType.Sticker:
//                    attachment = new StickerAttachment();
//                    break;
                case CustomAttachmentType.RTS:
//                    attachment = new RTSAttachment();
                    break;
                case CustomAttachmentType.TEST:
                case CustomAttachmentType.TYPE_LINGXI_TEST_QUESTION:
                    attachment = new CustomAttachmentTest();
                    break;
                case CustomAttachmentType.EVALUATE:
                    attachment = new CustomAttachmentEvaluate();
                    break;
                case CustomAttachmentType.CONSULT:
                    attachment = new CustomAttachConsult();
                    break;
                case CustomAttachmentType.ASSISTANT:
                    attachment = new CustomAttachmentRecommendAssistant();
                    break;
                case CustomAttachmentType.REDPACKET:
                    attachment = new CustomAttachRedPacket();
                    break;
                case CustomAttachmentType.REDSTATUS:
                case CustomAttachmentType.REDTIMEOUT:
                    attachment = new CustomAttachmentRedStatus();
                    break;
                case CustomAttachmentType.RECEIVEDMONEY:
                    //收款消息解析器
                    attachment = new CustomAttachReceivedMoney();
                    break;
                case CustomAttachmentType.RECEIVEDMONEY_STATUS:
                    //收款消息支付状态发生变化
                    attachment = new CustomAttachmentReceivedSuccess();
                    break;
                case CustomAttachmentType.RECEIVEDMONEY_TIMEOUT:
                    //收款消息超时未支付
                    attachment = new CustomAttachmentReceivedTimeout();
                    break;
                case CustomAttachmentType.ADD_SUBSCRIPT_TIME:
                    //添加预约时间提醒
                    attachment = new CustomAttachSubScriptTime();
                    break;
                case CustomAttachmentType.TIP_MSG:
                    //自定义样式提醒消息
                    attachment = new CustomAttachTipMsg();
                    break;
                case CustomAttachmentType.ORDER_TIP:
                    //订单状态
                    attachment = new CustomAttachmentOrderStatus();
                    break;
                //修改
                case CustomAttachmentType.MODIFY_TIME:
                    attachment = new CustomAttachModifyTime();
                    break;
                case CustomAttachmentType.TYPE_PHONE_CALL_RED_PACKET:
                    attachment = new CustomAttachmentPhoneCallRedPacket();
                    break;
                case CustomAttachmentType.TYPE_PHONE_CALL_SYSTEM_NOTICE:
                    attachment = new CustomAttachmentPhoneCallSystemNotice();
                    break;
                case CustomAttachmentType.TYPE_CUSTOM_SYSTEM_TIPS:
                    attachment = new CustomSystemTips();
                    break;
                case CustomAttachmentType.TYPE_RECOMMEND_EXPORTS:
                    attachment = new CustomRecommendExpertListMsg();
                    break;
                case CustomAttachmentType.TYPE_CONSULT_SUBSCRIBE_SURE:
                    //咨询预约时间确认
                    attachment = new CustomAttachConsultSubScript();
                    break;
                case CustomAttachmentType.TYPE_CONSULT_PERFECT_DATA:
                    //完善咨询资料消息
                    attachment = new CustomAttachConsultPerfectData();
                    break;
                case CustomAttachmentType.TYPE_PLEASE_SUBSCRIBE_CONSULT_DATE:
                    //请预约咨询时间
                    attachment = new CustomAttachPleaseSubscribeConsultDate();
                    break;
                case CustomAttachmentType.TYPE_CUSTOMER_SERVICE:
                    //客服小壹名片
                    attachment = new CustomCustomerServiceCardAttachment();
                    break;
                case CustomAttachmentType.TYPE_PUSH_SHARE:
                    //分享消息，倾诉推荐，课程，测评，文章
                    attachment = new CustomAttachmentShareMsg();
                    break;
                case CustomAttachmentType.TYPE_CUSTOMER_CONSULT_CALL_STATUS:
                    //咨询的声网拨打状态的自定义消息
                    attachment = new CustomAttachConsultCallStatus();
                    break;
                case CustomAttachmentType.ASSISTANT_RECEIVEDMONEY:
                    attachment = new CustomAttachAssistantReceivedMoney();
                    break;
                case CustomAttachmentType.TYPE_EXPERT_DETAIL_CARD:
                    //专家自定义名片
                    attachment = new CustomAttachmentBusinessCard();
                    break;
                case CustomAttachmentType.TYPE_JUMPTO_DAOYI:
                    //跳转导医聊天界面
                    attachment = new CustomAttachmentJumpToDaoYi();
                    break;
                case CustomAttachmentType.TYPE_SWITCH_KEFU_TIPS:
                    //客服转介需求
                    attachment = new CustomAttachmentSwitchKeFuTips();
                    break;
                //41 42消息过滤掉
                case CustomAttachmentType.TYPE_FILTER_41:
                case CustomAttachmentType.TYPE_FILTER_42:
                case CustomAttachmentType.TYPE_FILTER_61:
                case CustomAttachmentType.TYPE_FILTER_70:
                case CustomAttachmentType.TYPE_FILTER_71:
                case CustomAttachmentType.TYPE_FILTER_80:
                    attachment = new CustomAttachmentFilter();
                    break;
                case CustomAttachmentType.TYPE_CONFIRM_ORDER://38  确认订单消息
                    attachment = new CustomAttachmentConfirmOrder();
                    break;
                case CustomAttachmentType.TYPE_ORDER_ALREADY_DONE://39  订单已完成
                    attachment = new CustomAttachmentOrderAlreadyDone();
                    break;
                case CustomAttachmentType.TYPE_LINGXI_WHICH_QUESTION://灵犀2.0-您想要咨询下列哪些问题
                    attachment = new CustomAttachLingxiWhichQuestion();
                    break;
                case CustomAttachmentType.TYPE_LINGXI_ANSWER_QUESTION://灵犀2.0-回答问题
                    attachment = new CustomAttachLingxiAnswerQuestion();
                    break;
                case CustomAttachmentType.TYPE_LINGXI_JUMP_CONFIDE_LIST: // 跳转倾诉列表
                    attachment = new CustomAttachLingXiJumpConfideList();
                    break;
                case CustomAttachmentType.TYPE_LINGXI_FIRST_QUESTION: //首问语
                    attachment = new CustomAttachLingxiFirstQuestion();
                    break;
//                case CustomAttachmentType.TYPE_CONSULT_SUBSCRIBE_PAY:
//                    attachment = new CustomAttachConsultSubScriptPayment();
//                    break;
                default:
                    attachment = new DefaultCustomAttachment();
                    break;
            }

            if (attachment != null) {
                attachment.fromJson(data);
            }
        } catch (Exception e) {
        }

        return attachment;
    }

    public static String packData(int type, JSONObject data) {
        JSONObject object = new JSONObject();
        object.put(KEY_TYPE, type);
        if (data != null) {
            object.put(KEY_DATA, data);
        }

        return object.toJSONString();
    }
}
