package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * @author huozhiliang
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/9/7
 */
public class CustomAttachmentBusinessCard extends CustomAttachment {
    private String NAME = "name";
    private String SECONDTITLE = "teamCertifications";
    private String EXPERTIMG = "head";
    private String TAGLIST = "tag2";
    private String FEEDBACKRATE = "feedbackRate";
    private String COMMENTNUM = "commentNum";
    private String WORKYEARS = "workYears";
    private String ORDERNUM = "orderNum";
    private String HELPLONG = "helpLong";
    private String DOCTORCARDURL="doctorCardUrl";

    public String name; //专家名字
    public String secondTitle; //专家介绍
    public String expertImg; //专家头像
    public String tagList; //专家标签列表
    public Float feedbackRate=0f;//评价分
    public String commentNum;//评价人数
    public String workYears;//持证年限
    public String orderNum;//服务人数
    public String helpLong;//服务时长
    public String doctorCardUrl;//跳转专家名片URL

    CustomAttachmentBusinessCard() {
        super(CustomAttachmentType.TYPE_EXPERT_DETAIL_CARD);
    }

    @Override
    protected void parseData(JSONObject data) {
        name = data.getString(NAME);
        secondTitle = data.getString(SECONDTITLE);
        expertImg = data.getString(EXPERTIMG);
        tagList = data.getString(TAGLIST);
        feedbackRate = data.getFloat(FEEDBACKRATE);
        commentNum = data.getString(COMMENTNUM);
        workYears = data.getString(WORKYEARS);
        orderNum = data.getString(ORDERNUM);
        helpLong = data.getString(HELPLONG);
        doctorCardUrl=data.getString(DOCTORCARDURL);
    }


    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(NAME, name);
        data.put(SECONDTITLE, secondTitle);
        data.put(EXPERTIMG, expertImg);
        data.put(TAGLIST, tagList);
        data.put(FEEDBACKRATE, feedbackRate);
        data.put(COMMENTNUM, commentNum);
        data.put(WORKYEARS, workYears);
        data.put(ORDERNUM, orderNum);
        data.put(HELPLONG, helpLong);
        data.put(DOCTORCARDURL,doctorCardUrl);
        return data;
    }
}
