package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * 后台推送到订单状态消息
 * Created by harvie on 2017/1/13.
 */

public class CustomAttachmentOrderStatus extends CustomAttachment {
    private static final String KEY_FROM_CONTENT = "from_content";
    private static final String KEY_FROM_UID = "from_uid";
    private static final String KEY_TO_UID = "to_uid";
    private static final String KEY_POCKET_ID="orderid";

    private String from_content ="";
    private String from_uid = "";
    private String to_uid = "";
    private String orderid = "";

    public CustomAttachmentOrderStatus() {
        super(CustomAttachmentType.ORDER_TIP);
    }

    @Override
    protected void parseData(JSONObject data) {
        from_content = data.getString(KEY_FROM_CONTENT);
        from_uid = data.getString(KEY_FROM_UID);
        to_uid = data.getString(KEY_TO_UID);
        orderid=data.getString(KEY_POCKET_ID);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_FROM_CONTENT, from_content);
        data.put(KEY_FROM_UID, from_uid);
        data.put(KEY_TO_UID, to_uid);
        data.put(KEY_POCKET_ID,orderid);
        return data;
    }

    public String getFrom_content() {
        return from_content;
    }

    public String getFrom_uid() {
        return from_uid;
    }

    public String getTouid() {
        return to_uid;
    }

    public String getOrderid() {
        return orderid;
    }

    /**
     * 是否是   已开启私聊   消息
     * @return
     */
    public Boolean isStartChatMessage() {
        if ("已开启私聊".equals(getFrom_content())) {
            return true;
        }
        return false;
    }
}
