package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yidianling.uikit.custom.http.response.RecommendExpertBean;

import java.util.ArrayList;

/**
 * 专家推荐列表消息
 * Created by xj on 2016/12/14;
 */
public class CustomRecommendExpertListMsg extends CustomAttachment {

    private static final String RECOMMEND_EXPERT_LIST = "recommend_expert_list";
    private static final String RECOMMEND_EXPERT_LIST_TYPE = "recommend_expert_list_type";
    private static final String SHOW_RECOMMEND_EXPERT= "show_recommend_expert";

    private ArrayList<RecommendExpertBean> list = null;
    private int messageType = 0; //1专家离线  2专家忙碌
    private boolean showExpertList; //是否显示专家列表

    public CustomRecommendExpertListMsg() {
        super(CustomAttachmentType.TYPE_RECOMMEND_EXPORTS);
    }

    public CustomRecommendExpertListMsg(ArrayList<RecommendExpertBean> list, int messageType, boolean showExpertList) {
        super(CustomAttachmentType.TYPE_RECOMMEND_EXPORTS);
        this.list = list;
        this.messageType = messageType;
        this.showExpertList = showExpertList;
    }

    @Override
    protected void parseData(JSONObject data) {
        this.list = (ArrayList<RecommendExpertBean>) JSON.parseArray(data.getString(RECOMMEND_EXPERT_LIST), RecommendExpertBean.class);
        this.messageType = Integer.parseInt(data.getString(RECOMMEND_EXPERT_LIST_TYPE));
        this.showExpertList = data.getBoolean(SHOW_RECOMMEND_EXPERT);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(RECOMMEND_EXPERT_LIST, list);
        data.put(RECOMMEND_EXPERT_LIST_TYPE, messageType);
        data.put(SHOW_RECOMMEND_EXPERT, showExpertList);
        return data;
    }

    public ArrayList<RecommendExpertBean> getList() {
        return this.list;
    }

    public int getMessageType() { return messageType; }

    public boolean getShowExpertList() { return showExpertList; }
}
