package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachChatTipMsg;
import com.ydl.ydlcommon.utils.Utils;

/**
 * Created by harvie on 2015/11/25.
 * 自定义样式提醒消息ViewHolder 短时间内私聊次数过多给你警示
 */
public class MsgViewHolderChatTip extends MsgViewHolderBase {

    protected TextView notificationTextView;

    public MsgViewHolderChatTip(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_chat_tip;
    }

    @Override
    protected void inflateContentView() {
        notificationTextView = (TextView) view.findViewById(R.id.message_receive_tv);
    }

    @Override
    protected void bindContentView() {
        CustomAttachChatTipMsg customAttachTipMsg = (CustomAttachChatTipMsg) message.getAttachment();
        String content = customAttachTipMsg.getFrom_content();
        if (content!=null){
            notificationTextView.setText(Utils.textValueOfStart(R.drawable.im_nim_ic_failed,content));
        }

        hideItemBg();
    }

    @Override
    protected boolean isMiddleItem() {
        return true;
    }
}
