package com.yidianling.im.session.viewholder;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachConsultCallStatus;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * Created by zhoujianghua on 2015/8/6.
 */
public class MsgViewHolderConsultCallStatus extends MsgViewHolderBase {

    private ImageView typeImageLeft;
    private ImageView typeImageRight;
    private TextView statusLabel;

    public MsgViewHolderConsultCallStatus(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_consult_call_status;
    }

    @Override
    protected void inflateContentView() {
        typeImageLeft = findViewById(R.id.type_img_left);
        typeImageRight = findViewById(R.id.type_img_right);
        statusLabel = findViewById(R.id.tv_state);
    }

    @Override
    protected void bindContentView() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        layoutByDirection(customAttachTipMsg);

    }

    private void layoutByDirection(CustomAttachConsultCallStatus customAttachTipMsg) {

        if (isReceivedMessage()) {
            typeImageLeft.setVisibility(View.VISIBLE);
            typeImageRight.setVisibility(View.GONE);
        } else {
            typeImageLeft.setVisibility(View.GONE);
            typeImageRight.setVisibility(View.VISIBLE);
        }


        if (isReceivedMessage()) {
            statusLabel.setText(customAttachTipMsg.getCallee());
        } else {
            statusLabel.setText(customAttachTipMsg.getCaller());
        }
    }

    @Override
    protected int leftBackground() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            return R.drawable.im_message_receive_content_tip_bg;
        } else {
            return R.drawable.im_message_receive_content_bg;
        }
    }

    @Override
    protected int rightBackground() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            return R.drawable.im_message_send_content_tip_bg;
        } else {
            return R.drawable.im_message_send_content_bg;
        }
    }

}
