package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachTipMsg;

/**
 * Created by harvie on 2015/11/25.
 * 自定义样式提醒消息ViewHolder
 */
public class MsgViewHolderCustomTip extends MsgViewHolderBase {

    protected TextView notificationTextView;

    public MsgViewHolderCustomTip(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_tip;
    }

    @Override
    protected void inflateContentView() {
        notificationTextView = (TextView) view.findViewById(R.id.message_receive_tv);
    }

    @Override
    protected void bindContentView() {
        CustomAttachTipMsg customAttachTipMsg = (CustomAttachTipMsg) message.getAttachment();
        String content = customAttachTipMsg.getFrom_content();
        if (content!=null){
            notificationTextView.setText(content);
        }

        hideItemBg();
    }

    @Override
    protected boolean isMiddleItem() {
        return true;
    }
}
