package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentEvaluate;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;


/**
 * 订单评价
 * Created by Wi1ls on 2016/11/25;
 */
public class MsgViewHolderEvaluate extends MsgViewHolderBase {
    private String user_url;
    private String doc_url;
    private String orderid;

    private TextView tv_title;
    private TextView tv_flag;
    private TextView check;

    public MsgViewHolderEvaluate(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_p2p_evaluate;
    }

    @Override
    protected void inflateContentView() {
        tv_title = (TextView) view.findViewById(R.id.evaluate_title);
        tv_flag = (TextView) view.findViewById(R.id.tv_flag);
        check = (TextView) view.findViewById(R.id.check);
    }

    @Override
    protected void bindContentView() {
        CustomAttachmentEvaluate customAttachmentEvaluate = (CustomAttachmentEvaluate) message.getAttachment();
        user_url = customAttachmentEvaluate.getUser_url();
        doc_url = customAttachmentEvaluate.getDoc_url();
        orderid = customAttachmentEvaluate.getOrderid();

    }

    @Override
    protected void onItemClick() {
        NewH5Activity.start(view.getContext(), new H5Params(user_url + "?orderid=" + orderid, null));
    }
}
