package com.yidianling.im.session.viewholder;

import android.app.Activity;
import android.view.View;
import android.widget.TextView;

import com.ydl.ydlcommon.modular.ModularServiceManager;
import com.yidianling.consultant.api.IConsultantService;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentJumpToDaoYi;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * @author huozhiliang
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/12/14
 */
public class MsgViewHolderJumpToDaoYi extends MsgViewHolderBase implements View.OnClickListener {
    private TextView jumpToDaoYi;
    private TextView daoYiDesc;

    public MsgViewHolderJumpToDaoYi(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_jump_to_daoyi;
    }

    @Override
    protected void inflateContentView() {
        CustomAttachmentJumpToDaoYi customJumpDaoYi = (CustomAttachmentJumpToDaoYi) message.getAttachment();
        jumpToDaoYi=findViewById(R.id.jumpToDaoYi);
        daoYiDesc=findViewById(R.id.desc);
        jumpToDaoYi.setOnClickListener(this);
        daoYiDesc.setText(customJumpDaoYi.desc);
    }

    @Override
    protected void bindContentView() {

    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.jumpToDaoYi) {
            /*--跳转导医逻辑
             ---和PHP开发黄启群---沟通过后location传0
             就不会走测评相关的逻辑*/
            ModularServiceManager.INSTANCE.provide(IConsultantService.class).jumpConsultAssistant((Activity) context,0);
        }
    }
}
