package com.yidianling.im.session.viewholder;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachConsultPerfectData;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydlcommon.utils.log.LogHelper;

/**
 * author : harvie
 * 完善咨询资料提醒消息
 */

public class MsgViewHolderPerfectConsultData extends MsgViewHolderBase {

    private View lin_body,lin_tips;
    private ImageView img;
    private TextView tv_content,tv_btn,tv_look,tv_text;

    public String url;//跳转url
    public String title;
    public String tips;//提醒消息
    public int flag;//0提醒完善文字消息 1 带背景提示完善消息 2 已完善消息



    public MsgViewHolderPerfectConsultData(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_consult_perfect_data;
    }

    @Override
    protected void inflateContentView() {
        lin_body = view.findViewById(R.id.lin_body);
        img = view.findViewById(R.id.img_icon);
        tv_content = view.findViewById(R.id.tv_content);
        lin_tips = view.findViewById(R.id.lin_tips);
        tv_btn = view.findViewById(R.id.tv_btn);
        tv_look = view.findViewById(R.id.tv_look);
        tv_text = view.findViewById(R.id.tv_text);

        if (isReceivedMessage()){
            lin_body.setBackgroundResource(R.drawable.im_bg_radius_topright_blue_8);
            img.setImageResource(R.mipmap.im_consult_perfect_data);
        }else {
            lin_body.setBackgroundResource(R.drawable.im_bg_radius_topleft_blue_8);
            img.setImageResource(R.mipmap.im_consult_perfect_data_2);
        }

    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachConsultPerfectData){
            url = ((CustomAttachConsultPerfectData) attachment).url;
            title = ((CustomAttachConsultPerfectData) attachment).title;
            tips = ((CustomAttachConsultPerfectData) attachment).tips;
            flag = ((CustomAttachConsultPerfectData) attachment).flag;

        }
        tv_content.setText(title);

        if (flag==0){
            lin_tips.setVisibility(View.VISIBLE);
            tv_look.setVisibility(View.GONE);
            lin_body.setVisibility(View.GONE);
            hideHead();
            if (!TextUtils.isEmpty(tips)){
                try {
                    String[] strs = tips.split("\\|");
                    tv_text.setText(strs[0]);
                    tv_btn.setText(strs[1]);
                }catch (Exception e){
                    e.printStackTrace();
                    LogHelper.Companion.getInstance().writeLogSync(e.getLocalizedMessage());
                }
            }
        }else {
            lin_tips.setVisibility(View.GONE);
            tv_look.setVisibility(View.VISIBLE);
            lin_body.setVisibility(View.VISIBLE);
        }

        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        if (flag != 0 && !TextUtils.isEmpty(url)){
            NewH5Activity.start(context,new H5Params(url,null));
        }
    }
}
