package com.yidianling.im.session.viewholder;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachPleaseSubscribeConsultDate;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;

/**
 * author : harvie
 * 请预约咨询时间提醒消息
 */

public class MsgViewHolderPleaseSubscribeConsultDate extends MsgViewHolderBase {

    private TextView tv_content;

    private String url;
    private String title;


    public MsgViewHolderPleaseSubscribeConsultDate(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_consult_subscribe_date;
    }

    @Override
    protected void inflateContentView() {
        View rela_root = view.findViewById(R.id.rela_root);
        tv_content = view.findViewById(R.id.tv_content);
        if (isReceivedMessage()){
            rela_root.setBackgroundResource(R.drawable.im_bg_radius_no_topleft_white_8);
        }else {
            rela_root.setBackgroundResource(R.drawable.im_bg_radius_no_topright_white_8);
        }
    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachPleaseSubscribeConsultDate){
            url = ((CustomAttachPleaseSubscribeConsultDate) attachment).url;
            title = ((CustomAttachPleaseSubscribeConsultDate) attachment).title;
        }

        tv_content.setText(title);

        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        if (TextUtils.isEmpty(url)){
            return;
        }
        NewH5Activity.start(context,new H5Params(url,null));
    }
}
