package com.yidianling.im.session.viewholder;

import androidx.appcompat.app.AppCompatActivity;
import android.widget.ImageView;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.base.BaseApp;
import com.yidianling.im.R;
import com.yidianling.im.helper.IMChatUtil;
import com.yidianling.im.session.extension.CustomAttachmentRecommendAssistant;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;


/**
 * Created by Wi1ls on 2016/12/14;
 */
public class MsgViewHolderRecommendAssistant extends MsgViewHolderBase {
    private String touid;//userType=1,表示助手uid;type=2表示用户uid
    private String img;//头像
    private String name;//用户名
    private String usertype;//1表示用户收到,2表示助手收到 3咨询师名片
    private String title;//用以消息列表展示

    private ImageView recommend_head;
    private TextView recommend_title;
    private TextView recommend_content;
    private TextView recommend_type;

    private String custom_receiver = "ta会协助你解决咨询相关的问题";
    private String assistant_receiver = "ta需要你协助解决咨询相关的问题";

    public MsgViewHolderRecommendAssistant(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_recommend;
    }

    @Override
    protected void inflateContentView() {
        recommend_head = (ImageView) view.findViewById(R.id.recommend_head);
        recommend_title = (TextView) view.findViewById(R.id.recommend_title);
        recommend_content = (TextView) view.findViewById(R.id.recommend_content);
        recommend_type = (TextView) view.findViewById(R.id.recommend_type);
    }

    @Override
    protected void bindContentView() {
        CustomAttachmentRecommendAssistant customAttachmentRecommendAssistant = (CustomAttachmentRecommendAssistant) message.getAttachment();
        touid = customAttachmentRecommendAssistant.getTouid();
        img = customAttachmentRecommendAssistant.getImg();
        name = customAttachmentRecommendAssistant.getName();
        usertype = customAttachmentRecommendAssistant.getUser_type();
        title = customAttachmentRecommendAssistant.getTitle();
        GlideApp.with(BaseApp.Companion.getInstance()).load(img).into(recommend_head);
        if (usertype != null) {
            switch (usertype) {
                case "1":
                    recommend_title.setText("这是我的助理名片");
                    recommend_content.setText(name);
                    recommend_type.setText("助理名片");
                    break;
                case "2":
                    recommend_title.setText("这是我的客户名片");
                    recommend_content.setText(name);
                    recommend_type.setText("用户名片");
                    break;
                case "3":
                    recommend_title.setText("这是我的咨询师名片");
                    recommend_content.setText(name);
                    recommend_type.setText("咨询师名片");
                    break;
            }
        }
    }

    @Override
    protected void onItemClick() {
        try {
            IMChatUtil.INSTANCE.startChat((AppCompatActivity) context, touid,0);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }
}
